/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.api.Constants;
import net.adamcin.httpsig.api.Key;
import net.adamcin.httpsig.api.KeyId;
import net.adamcin.httpsig.api.Keychain;

public class DefaultKeychain
implements Keychain,
Collection<Key> {
    private final List<Key> keys = new ArrayList<Key>();
    private final Set<Algorithm> _algorithms = new LinkedHashSet<Algorithm>();

    public DefaultKeychain() {
        this(null);
    }

    public DefaultKeychain(Collection<? extends Key> identities) {
        if (identities != null) {
            this.addAll(identities);
        }
    }

    @Override
    public Set<Algorithm> getAlgorithms() {
        return Collections.unmodifiableSet(this._algorithms);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.keys.contains(o);
    }

    @Override
    public Iterator<Key> iterator() {
        return this.keys.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.keys.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.keys.toArray(a);
    }

    @Override
    public boolean add(Key key) {
        this._algorithms.addAll(key.getAlgorithms());
        return this.keys.add(key);
    }

    @Override
    public boolean remove(Object o) {
        return this.keys.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.keys.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Key> c) {
        boolean changed = false;
        if (c != null) {
            for (Key key : c) {
                if (!this.add(key)) continue;
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.keys.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.keys.retainAll(c);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this._algorithms.clear();
    }

    @Override
    public Keychain discard() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("keychain is empty");
        }
        if (this.size() > 1) {
            ArrayList<Key> _keys = new ArrayList<Key>(this.keys.size() - 1);
            Iterator<Key> _idents = this.iterator();
            _idents.next();
            while (_idents.hasNext()) {
                _keys.add(_idents.next());
            }
            return new DefaultKeychain(_keys);
        }
        return new DefaultKeychain();
    }

    @Override
    public Key currentKey() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("keychain is empty");
        }
        return this.iterator().next();
    }

    @Override
    public Keychain filterAlgorithms(Collection<Algorithm> algorithms) {
        ArrayList<Key> filteredKeys = new ArrayList<Key>();
        for (Key key : this) {
            for (Algorithm algorithm : key.getAlgorithms()) {
                if (!algorithms.contains((Object)algorithm)) continue;
                filteredKeys.add(key);
            }
        }
        return new DefaultKeychain(filteredKeys);
    }

    @Override
    public Map<String, Key> toMap(KeyId keyIdentifier) {
        LinkedHashMap<String, Key> map = new LinkedHashMap<String, Key>(this.size());
        if (keyIdentifier == null) {
            for (Key key : this) {
                String keyId = Constants.DEFAULT_KEY_IDENTIFIER.getId(key);
                if (keyId == null) continue;
                map.put(keyId, key);
            }
        } else {
            for (Key key : this) {
                String keyId = keyIdentifier.getId(key);
                if (keyId == null) continue;
                map.put(keyId, key);
            }
        }
        return Collections.unmodifiableMap(map);
    }
}

