/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import net.adamcin.httpsig.api.Constants;

public final class RequestContent
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(RequestContent.class.getName());
    @Deprecated
    public static final String DATE_FORMAT = "EEE MMM d HH:mm:ss yyyy zzz";
    public static final String DATE_FORMAT_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final List<String> SUPPORTED_DATE_FORMATS = Arrays.asList("EEE, dd MMM yyyy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy zzz");
    private static final long serialVersionUID = -2968642080214687632L;
    @Deprecated
    private final String requestLine;
    private final String method;
    private final String path;
    private final Map<String, List<String>> headers;

    private RequestContent(String requestLine, String method, String path, Map<String, List<String>> headers) {
        this.requestLine = requestLine;
        this.method = method;
        this.path = path;
        this.headers = headers;
    }

    @Deprecated
    public byte[] getContent(List<String> headers, Charset charset) {
        return this.getContentString(headers).getBytes(charset);
    }

    @Deprecated
    public String getContentString(List<String> headers) {
        return this.getStringToSign(headers, true);
    }

    public String getStringToSign(List<String> headers) {
        return this.getStringToSign(headers, false);
    }

    public byte[] getBytesToSign(List<String> headers, Charset charset) {
        return this.getStringToSign(headers).getBytes(charset);
    }

    private String getStringToSign(List<String> headers, boolean suppressRequestTargetPrefix) {
        StringBuilder hashBuilder = new StringBuilder();
        if (headers != null) {
            for (String header : headers) {
                String _header = header.toLowerCase();
                if (Constants.IGNORE_HEADERS.contains(_header) || _header.startsWith(":")) continue;
                if ("request-line".equals(_header)) {
                    if (this.requestLine == null) continue;
                    hashBuilder.append(this.requestLine).append('\n');
                    continue;
                }
                if ("(request-target)".equals(_header)) {
                    if (this.getRequestTarget() == null) continue;
                    if (!suppressRequestTargetPrefix) {
                        hashBuilder.append("(request-target)").append(": ");
                    }
                    hashBuilder.append(this.getRequestTarget()).append('\n');
                    continue;
                }
                for (String value : this.getHeaderValues(_header)) {
                    hashBuilder.append(_header).append(": ").append(value).append('\n');
                }
            }
        }
        return hashBuilder.toString().trim();
    }

    public String toString() {
        return this.getStringToSign(this.getHeaderNames());
    }

    public List<String> getHeaderNames() {
        ArrayList<String> headerNames = new ArrayList<String>();
        if (this.method != null && this.path != null) {
            headerNames.add("(request-target)");
        }
        headerNames.addAll(this.headers.keySet());
        return Collections.unmodifiableList(headerNames);
    }

    @Deprecated
    public String getRequestLine() {
        return this.requestLine;
    }

    public String getRequestTarget() {
        if (this.method == null || this.path == null) {
            return null;
        }
        return this.method.toLowerCase() + " " + this.path;
    }

    public String getDate() {
        List<String> dateValues = this.getHeaderValues("date");
        return dateValues.isEmpty() ? null : dateValues.get(0);
    }

    public List<String> getHeaderValues(String name) {
        String _name = name.toLowerCase();
        if ("request-line".equals(_name)) {
            LOGGER.warning("[getHeaderValues] Use of the request-line header is deprecated. Please use (request-target) instead.");
            return this.requestLine != null ? Collections.singletonList(this.requestLine) : Collections.emptyList();
        }
        if ("(request-target)".equals(_name)) {
            return this.getRequestTarget() != null ? Collections.singletonList(this.getRequestTarget()) : Collections.emptyList();
        }
        if (this.headers.containsKey(_name)) {
            return Collections.unmodifiableList(this.headers.get(_name));
        }
        return Collections.emptyList();
    }

    protected static Date tryParseDate(String date) {
        if (date != null) {
            for (String formatString : SUPPORTED_DATE_FORMATS) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(formatString, Locale.US);
                    dateFormat.setTimeZone(RequestContent.getGMT());
                    return dateFormat.parse(date);
                }
                catch (ParseException e) {
                    LOGGER.warning("[tryParseDate] date string " + date + " does not match format " + formatString);
                }
            }
        }
        return null;
    }

    public Date getDateGMT() {
        if (this.getDate() != null) {
            return RequestContent.tryParseDate(this.getDate());
        }
        return null;
    }

    public Calendar getDateTZ(TimeZone timeZone) {
        TimeZone tz = timeZone != null ? timeZone : TimeZone.getDefault();
        Date dateGMT = this.getDateGMT();
        if (dateGMT != null) {
            GregorianCalendar calGMT = new GregorianCalendar(RequestContent.getGMT());
            calGMT.setTime(dateGMT);
            return RequestContent.convertDate(calGMT, tz);
        }
        return null;
    }

    private static TimeZone getGMT() {
        return TimeZone.getTimeZone("UTC");
    }

    private static Calendar convertDate(Calendar orig, TimeZone to) {
        GregorianCalendar calendar = new GregorianCalendar(orig.getTimeZone());
        calendar.setTime(orig.getTime());
        ((Calendar)calendar).add(14, ((Calendar)calendar).getTimeZone().getRawOffset() * -1);
        if (((Calendar)calendar).getTimeZone().inDaylightTime(calendar.getTime())) {
            ((Calendar)calendar).add(14, ((Calendar)calendar).getTimeZone().getDSTSavings() * -1);
        }
        ((Calendar)calendar).add(14, to.getRawOffset());
        if (to.inDaylightTime(calendar.getTime())) {
            ((Calendar)calendar).add(14, to.getDSTSavings());
        }
        ((Calendar)calendar).setTimeZone(to);
        return calendar;
    }

    public static final class Builder {
        @Deprecated
        private String requestLine = null;
        private String method = null;
        private String path = null;
        private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();

        @Deprecated
        public Builder setRequestLine(String requestLine) {
            this.requestLine = requestLine;
            return this;
        }

        public Builder setRequestTarget(String method, String path) {
            this.method = method != null ? method.trim().toUpperCase() : null;
            this.path = path != null ? path.trim() : null;
            return this;
        }

        public Builder addHeader(String name, String value) {
            if (value != null) {
                String _value = value.trim();
                String _name = name.trim().toLowerCase();
                if (Constants.IGNORE_HEADERS.contains(_name) || _name.startsWith(":")) {
                    return this;
                }
                if ("request-line".equals(_name)) {
                    return this;
                }
                if ("(request-target)".equals(_name)) {
                    return this;
                }
                if (!"date".equals(_name) || RequestContent.tryParseDate(_value) != null) {
                    ArrayList<String> values = null;
                    if (this.headers.containsKey(_name)) {
                        this.headers.get(_name);
                    } else {
                        values = new ArrayList<String>();
                        this.headers.put(_name, values);
                    }
                    if (values != null) {
                        values.add(_value);
                    }
                }
            }
            return this;
        }

        public Builder addDate(Calendar calendar) {
            if (calendar != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(RequestContent.DATE_FORMAT_RFC1123, Locale.US);
                dateFormat.setTimeZone(calendar.getTimeZone());
                this.addHeader("date", dateFormat.format(calendar.getTime()));
            }
            return this;
        }

        public Builder addDate(Date dateGMT) {
            if (dateGMT != null) {
                GregorianCalendar calendar = new GregorianCalendar(RequestContent.getGMT());
                calendar.setTime(dateGMT);
                this.addDate(calendar);
            }
            return this;
        }

        public Builder addDateNow() {
            this.addDate(new GregorianCalendar(RequestContent.getGMT()));
            return this;
        }

        public RequestContent build() {
            return new RequestContent(this.requestLine, this.method, this.path, Collections.unmodifiableMap(this.headers));
        }
    }
}

