/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.ActiveObjectsException;
import net.java.ao.Common;
import net.java.ao.DBParam;
import net.java.ao.DatabaseProvider;
import net.java.ao.DefaultPolymorphicTypeMapper;
import net.java.ao.EntityManagerConfiguration;
import net.java.ao.EntityProxy;
import net.java.ao.EntityProxyAccessor;
import net.java.ao.EntityStreamCallback;
import net.java.ao.PolymorphicTypeMapper;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.ReadOnlyEntityProxy;
import net.java.ao.SchemaConfiguration;
import net.java.ao.ValueGenerator;
import net.java.ao.cache.Cache;
import net.java.ao.cache.CacheLayer;
import net.java.ao.cache.RAMCache;
import net.java.ao.schema.CachingNameConverters;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.NameConverters;
import net.java.ao.schema.SchemaGenerator;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.schema.info.EntityInfo;
import net.java.ao.schema.info.EntityInfoResolver;
import net.java.ao.schema.info.FieldInfo;
import net.java.ao.sql.SqlUtils;
import net.java.ao.types.TypeInfo;
import net.java.ao.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManager {
    private static final Logger log = LoggerFactory.getLogger(EntityManager.class);
    private final DatabaseProvider provider;
    private final EntityManagerConfiguration configuration;
    private final SchemaConfiguration schemaConfiguration;
    private final NameConverters nameConverters;
    private final EntityInfoResolver entityInfoResolver;
    private Cache cache;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private PolymorphicTypeMapper typeMapper;
    private final ReadWriteLock typeMapperLock = new ReentrantReadWriteLock(true);
    private final com.google.common.cache.Cache<Class<? extends ValueGenerator<?>>, ValueGenerator<?>> valGenCache;

    public EntityManager(DatabaseProvider provider, EntityManagerConfiguration configuration) {
        this.provider = (DatabaseProvider)Preconditions.checkNotNull((Object)provider);
        this.configuration = (EntityManagerConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.cache = new RAMCache();
        this.valGenCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends ValueGenerator<?>>, ValueGenerator<?>>(){

            public ValueGenerator<?> load(Class<? extends ValueGenerator<?>> generatorClass) throws Exception {
                return generatorClass.newInstance();
            }
        });
        this.nameConverters = new CachingNameConverters(configuration.getNameConverters());
        this.schemaConfiguration = (SchemaConfiguration)Preconditions.checkNotNull((Object)configuration.getSchemaConfiguration());
        this.typeMapper = new DefaultPolymorphicTypeMapper(new HashMap());
        this.entityInfoResolver = (EntityInfoResolver)Preconditions.checkNotNull((Object)configuration.getEntityInfoResolverFactory().create(this.nameConverters, provider.getTypeManager()), (Object)"entityInfoResolver");
    }

    public void migrate(Class<? extends RawEntity<?>> ... entities) throws SQLException {
        SchemaGenerator.migrate(this.provider, this.schemaConfiguration, this.nameConverters, false, entities);
    }

    public void migrateDestructively(Class<? extends RawEntity<?>> ... entities) throws SQLException {
        SchemaGenerator.migrate(this.provider, this.schemaConfiguration, this.nameConverters, true, entities);
    }

    @Deprecated
    public void flushAll() {
    }

    @Deprecated
    public void flushEntityCache() {
    }

    public void flush(RawEntity<?> ... entities) {
        HashMap toFlush = new HashMap();
        for (RawEntity<?> entity : entities) {
            this.verify(entity);
            toFlush.put(entity, this.getProxyForEntity(entity));
        }
        for (Map.Entry entry : toFlush.entrySet()) {
            ((EntityProxy)entry.getValue()).flushCache((RawEntity)entry.getKey());
        }
    }

    public <T extends RawEntity<K>, K> T[] get(Class<T> type, K ... keys) throws SQLException {
        EntityInfo<T, K> entityInfo = this.resolveEntityInfo(type);
        String primaryKeyField = entityInfo.getPrimaryKey().getName();
        return this.getFromCache(type, this.findByPrimaryKey(type, primaryKeyField), keys);
    }

    private <T extends RawEntity<K>, K> Function<T, K> findByPrimaryKey(final Class<T> type, final String primaryKeyField) {
        return new Function<T, K>(){

            @Override
            public T invoke(K k) throws SQLException {
                RawEntity[] ts = EntityManager.this.find(type, primaryKeyField + " = ?", new Object[]{k});
                if (ts.length == 1) {
                    return ts[0];
                }
                if (ts.length == 0) {
                    return null;
                }
                throw new ActiveObjectsException("Found more that one object of type '" + type.getName() + "' for key '" + k + "'");
            }
        };
    }

    protected <T extends RawEntity<K>, K> T[] peer(final EntityInfo<T, K> entityInfo, K ... keys) throws SQLException {
        return this.getFromCache(entityInfo.getEntityType(), new Function<T, K>(){

            @Override
            public T invoke(K key) {
                return EntityManager.this.getAndInstantiate(entityInfo, key);
            }
        }, keys);
    }

    private <T extends RawEntity<K>, K> T[] getFromCache(Class<T> type, Function<T, K> create, K ... keys) throws SQLException {
        RawEntity[] back = (RawEntity[])Array.newInstance(type, keys.length);
        int index = 0;
        for (K key : keys) {
            back[index++] = (RawEntity)create.invoke(key);
        }
        return back;
    }

    protected <T extends RawEntity<K>, K> T getAndInstantiate(EntityInfo<T, K> entityInfo, K key) {
        Class<T> type = entityInfo.getEntityType();
        EntityProxy<T, K> proxy = new EntityProxy<T, K>(this, entityInfo, key);
        RawEntity entity = (RawEntity)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type, EntityProxyAccessor.class}, proxy));
        return (T)entity;
    }

    public <T extends RawEntity<K>, K> T get(Class<T> type, K key) throws SQLException {
        return this.get(type, (K)EntityManager.toArray(key))[0];
    }

    protected <T extends RawEntity<K>, K> T peer(EntityInfo<T, K> entityInfo, K key) throws SQLException {
        return this.peer(entityInfo, (K)EntityManager.toArray(key))[0];
    }

    private static <K> K[] toArray(K key) {
        return new Object[]{key};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> T create(Class<T> type, DBParam ... params) throws SQLException {
        RawEntity back = null;
        EntityInfo<T, K> entityInfo = this.resolveEntityInfo(type);
        String table = entityInfo.getName();
        HashSet<DBParam> listParams = new HashSet<DBParam>();
        listParams.addAll(Arrays.asList(params));
        for (FieldInfo fieldInfo : Iterables.filter(entityInfo.getFields(), FieldInfo.HAS_GENERATOR)) {
            ValueGenerator generator;
            try {
                generator = (ValueGenerator)this.valGenCache.get(fieldInfo.getGeneratorType());
            }
            catch (ExecutionException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            catch (UncheckedExecutionException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            catch (ExecutionError e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            listParams.add(new DBParam(fieldInfo.getName(), generator.generateValue(this)));
        }
        HashSet requiredFields = Sets.newHashSet((Iterable)Sets.filter(entityInfo.getFields(), FieldInfo.IS_REQUIRED));
        for (DBParam param : listParams) {
            FieldInfo field = entityInfo.getField(param.getField());
            Preconditions.checkNotNull((Object)field, (String)"Entity %s does not have field %s", (Object[])new Object[]{type.getName(), param.getField()});
            if (field.isPrimary()) {
                Common.validatePrimaryKey(field, param.getValue());
            } else if (!field.isNullable()) {
                Preconditions.checkArgument((param.getValue() != null ? 1 : 0) != 0, (String)"Cannot set non-null field %s to null", (Object[])new Object[]{param.getField()});
                if (param.getValue() instanceof String) {
                    Preconditions.checkArgument((!StringUtils.isBlank((String)param.getValue()) ? 1 : 0) != 0, (String)"Cannot set non-null String field %s to ''", (Object[])new Object[]{param.getField()});
                }
            }
            requiredFields.remove(field);
            TypeInfo dbType = field.getTypeInfo();
            if (dbType == null || param.getValue() == null) continue;
            dbType.getLogicalType().validate(param.getValue());
        }
        if (!requiredFields.isEmpty()) {
            throw new IllegalArgumentException("The follow required fields were not set when trying to create entity '" + type.getName() + "', those fields are: " + Joiner.on((String)", ").join((Iterable)requiredFields));
        }
        Connection connection = null;
        try {
            connection = this.provider.getConnection();
            back = (RawEntity)this.peer(entityInfo, this.provider.insertReturningKey(this, connection, type, entityInfo.getPrimaryKey().getJavaType(), entityInfo.getPrimaryKey().getName(), entityInfo.getPrimaryKey().hasAutoIncrement(), table, listParams.toArray(new DBParam[listParams.size()])));
        }
        finally {
            SqlUtils.closeQuietly(connection);
        }
        back.init();
        return (T)back;
    }

    public <T extends RawEntity<K>, K> T create(Class<T> type, Map<String, Object> params) throws SQLException {
        DBParam[] arrParams = new DBParam[params.size()];
        int i = 0;
        for (String key : params.keySet()) {
            arrParams[i++] = new DBParam(key, params.get(key));
        }
        return this.create(type, arrParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RawEntity<?> ... entities) throws SQLException {
        if (entities.length == 0) {
            return;
        }
        HashMap organizedEntities = new HashMap();
        for (RawEntity<?> entity : entities) {
            this.verify(entity);
            Class<RawEntity<?>> type = this.getProxyForEntity(entity).getType();
            if (!organizedEntities.containsKey(type)) {
                organizedEntities.put(type, new LinkedList());
            }
            ((List)organizedEntities.get(type)).add(entity);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.provider.getConnection();
            for (Class type : organizedEntities.keySet()) {
                EntityInfo entityInfo = this.resolveEntityInfo(type);
                List entityList = (List)organizedEntities.get(type);
                StringBuilder sql = new StringBuilder("DELETE FROM ");
                sql.append(this.provider.withSchema(entityInfo.getName()));
                sql.append(" WHERE ").append(this.provider.processID(entityInfo.getPrimaryKey().getName())).append(" IN (?");
                for (int i = 1; i < entityList.size(); ++i) {
                    sql.append(",?");
                }
                sql.append(')');
                stmt = this.provider.preparedStatement(conn, sql);
                int index = 1;
                for (RawEntity entity : entityList) {
                    TypeInfo typeInfo = entityInfo.getPrimaryKey().getTypeInfo();
                    typeInfo.getLogicalType().putToDatabase(this, stmt, index++, Common.getPrimaryKeyValue(entity), typeInfo.getJdbcWriteType());
                }
                stmt.executeUpdate();
            }
        }
        finally {
            SqlUtils.closeQuietly(stmt);
            SqlUtils.closeQuietly(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> int deleteWithSQL(Class<? extends RawEntity<K>> type, String criteria, Object ... parameters) throws SQLException {
        int rowCount = 0;
        StringBuilder sql = new StringBuilder("DELETE FROM ");
        sql.append(this.provider.withSchema(this.nameConverters.getTableNameConverter().getName(type)));
        if (criteria != null) {
            sql.append(" WHERE ");
            sql.append(this.provider.processWhereClause(criteria));
        }
        Connection connection = this.provider.getConnection();
        try {
            PreparedStatement stmt = this.provider.preparedStatement(connection, sql);
            try {
                this.putStatementParameters(stmt, parameters);
                rowCount = stmt.executeUpdate();
            }
            finally {
                stmt.close();
            }
        }
        finally {
            connection.close();
        }
        return rowCount;
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> type) throws SQLException {
        return this.find(type, Query.select());
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> type, String criteria, Object ... parameters) throws SQLException {
        return this.find(type, Query.select().where(criteria, parameters));
    }

    public <T extends RawEntity<K>, K> T findSingleEntity(Class<T> type, String criteria, Object ... parameters) throws SQLException {
        RawEntity[] entities = this.find(type, criteria, parameters);
        if (entities.length < 1) {
            return null;
        }
        if (entities.length > 1) {
            throw new IllegalStateException("Found more than one entities of type '" + type.getSimpleName() + "' that matched the criteria '" + criteria + "' and parameters '" + parameters.toString() + "'.");
        }
        return (T)entities[0];
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> type, Query query) throws SQLException {
        EntityInfo<T, K> entityInfo = this.resolveEntityInfo(type);
        query.resolvePrimaryKey(entityInfo.getPrimaryKey());
        String selectField = entityInfo.getPrimaryKey().getName();
        Iterable<String> fields = query.getFields();
        if (Iterables.size(fields) == 1) {
            selectField = (String)Iterables.get(fields, (int)0);
        }
        return this.find(type, selectField, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> T[] find(Class<T> type, String field, Query query) throws SQLException {
        ArrayList<T> back = new ArrayList<T>();
        EntityInfo<T, K> entityInfo = this.resolveEntityInfo(type);
        query.resolvePrimaryKey(entityInfo.getPrimaryKey());
        Preload preloadAnnotation = type.getAnnotation(Preload.class);
        if (preloadAnnotation != null && !((String)Iterables.get(query.getFields(), (int)0)).equals("*") && query.getJoins().isEmpty()) {
            Iterable<String> oldFields = query.getFields();
            ArrayList<Object> newFields = new ArrayList<Object>();
            for (String newField : Common.preloadValue(preloadAnnotation, this.nameConverters.getFieldNameConverter())) {
                newField = newField.trim();
                int fieldLoc = -1;
                for (int i = 0; i < Iterables.size(oldFields); ++i) {
                    if (!((String)Iterables.get(oldFields, (int)i)).equals(newField)) continue;
                    fieldLoc = i;
                    break;
                }
                if (fieldLoc < 0) {
                    newFields.add(newField);
                    continue;
                }
                newFields.add(Iterables.get(oldFields, (int)fieldLoc));
            }
            if (!newFields.contains("*")) {
                for (String oldField : oldFields) {
                    if (newFields.contains(oldField)) continue;
                    newFields.add(oldField);
                }
            }
            query.setFields(newFields.toArray(new String[newFields.size()]));
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.provider.getConnection();
            String sql = query.toSQL(entityInfo, this.provider, this.getTableNameConverter(), false);
            stmt = this.provider.preparedStatement(conn, sql, 1004, 1007);
            this.provider.setQueryStatementProperties(stmt, query);
            query.setParameters(this, stmt);
            res = stmt.executeQuery();
            this.provider.setQueryResultSetProperties(res, query);
            TypeInfo<K> primaryKeyType = entityInfo.getPrimaryKey().getTypeInfo();
            Class<K> primaryKeyClassType = entityInfo.getPrimaryKey().getJavaType();
            String[] canonicalFields = query.getCanonicalFields(entityInfo);
            while (res.next()) {
                T entity = this.peer(entityInfo, primaryKeyType.getLogicalType().pullFromDatabase(this, res, primaryKeyClassType, field));
                CacheLayer cacheLayer = this.getProxyForEntity(entity).getCacheLayer((RawEntity<?>)entity);
                for (String cacheField : canonicalFields) {
                    cacheLayer.put(cacheField, res.getObject(cacheField));
                }
                back.add(entity);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(res, stmt, conn);
            throw throwable;
        }
        SqlUtils.closeQuietly(res, stmt, conn);
        return back.toArray((RawEntity[])Array.newInstance(type, back.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> T[] findWithSQL(Class<T> type, String keyField, String sql, Object ... parameters) throws SQLException {
        ArrayList<T> back = new ArrayList<T>();
        EntityInfo<T, K> entityInfo = this.resolveEntityInfo(type);
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            connection = this.provider.getConnection();
            stmt = this.provider.preparedStatement(connection, sql);
            this.putStatementParameters(stmt, parameters);
            res = stmt.executeQuery();
            while (res.next()) {
                back.add(this.peer(entityInfo, entityInfo.getPrimaryKey().getTypeInfo().getLogicalType().pullFromDatabase(this, res, type, keyField)));
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(res);
            SqlUtils.closeQuietly(stmt);
            SqlUtils.closeQuietly(connection);
            throw throwable;
        }
        SqlUtils.closeQuietly(res);
        SqlUtils.closeQuietly(stmt);
        SqlUtils.closeQuietly(connection);
        return back.toArray((RawEntity[])Array.newInstance(type, back.size()));
    }

    public <T extends RawEntity<K>, K> void stream(Class<T> type, EntityStreamCallback<T, K> streamCallback) throws SQLException {
        this.stream(type, Query.select("*"), streamCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> void stream(Class<T> type, Query query, EntityStreamCallback<T, K> streamCallback) throws SQLException {
        EntityInfo<T, K> entityInfo = this.resolveEntityInfo(type);
        query.resolvePrimaryKey(entityInfo.getPrimaryKey());
        String[] canonicalFields = query.getCanonicalFields(entityInfo);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.provider.getConnection();
            String sql = query.toSQL(entityInfo, this.provider, this.getTableNameConverter(), false);
            stmt = this.provider.preparedStatement(conn, sql, 1003, 1007);
            this.provider.setQueryStatementProperties(stmt, query);
            query.setParameters(this, stmt);
            res = stmt.executeQuery();
            this.provider.setQueryResultSetProperties(res, query);
            while (res.next()) {
                K primaryKey = entityInfo.getPrimaryKey().getTypeInfo().getLogicalType().pullFromDatabase(this, res, entityInfo.getPrimaryKey().getJavaType(), entityInfo.getPrimaryKey().getName());
                ReadOnlyEntityProxy<T, K> proxy = this.createReadOnlyProxy(entityInfo, primaryKey);
                RawEntity entity = (RawEntity)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, proxy));
                for (String fieldName : canonicalFields) {
                    proxy.addValue(fieldName, res);
                }
                streamCallback.onRowRead(entity);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(res, stmt, conn);
            throw throwable;
        }
        SqlUtils.closeQuietly(res, stmt, conn);
    }

    private <T extends RawEntity<K>, K> ReadOnlyEntityProxy<T, K> createReadOnlyProxy(EntityInfo<T, K> entityInfo, K primaryKey) {
        return new ReadOnlyEntityProxy<T, K>(this, entityInfo, primaryKey);
    }

    public <K> int count(Class<? extends RawEntity<K>> type) throws SQLException {
        return this.count(type, Query.select());
    }

    public <K> int count(Class<? extends RawEntity<K>> type, String criteria, Object ... parameters) throws SQLException {
        return this.count(type, Query.select().where(criteria, parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> int count(Class<? extends RawEntity<K>> type, Query query) throws SQLException {
        int n;
        EntityInfo<? extends RawEntity<K>, K> entityInfo = this.resolveEntityInfo(type);
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            connection = this.provider.getConnection();
            String sql = query.toSQL(entityInfo, this.provider, this.getTableNameConverter(), true);
            stmt = this.provider.preparedStatement(connection, sql);
            this.provider.setQueryStatementProperties(stmt, query);
            query.setParameters(this, stmt);
            res = stmt.executeQuery();
            n = res.next() ? res.getInt(1) : -1;
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(res);
            SqlUtils.closeQuietly(stmt);
            SqlUtils.closeQuietly(connection);
            throw throwable;
        }
        SqlUtils.closeQuietly(res);
        SqlUtils.closeQuietly(stmt);
        SqlUtils.closeQuietly(connection);
        return n;
    }

    public NameConverters getNameConverters() {
        return this.nameConverters;
    }

    protected <T extends RawEntity<K>, K> EntityInfo<T, K> resolveEntityInfo(Class<T> type) {
        return this.entityInfoResolver.resolve(type);
    }

    public TableNameConverter getTableNameConverter() {
        return this.nameConverters.getTableNameConverter();
    }

    public FieldNameConverter getFieldNameConverter() {
        return this.nameConverters.getFieldNameConverter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolymorphicTypeMapper(PolymorphicTypeMapper typeMapper) {
        this.typeMapperLock.writeLock().lock();
        try {
            this.typeMapper = typeMapper;
            if (typeMapper instanceof DefaultPolymorphicTypeMapper) {
                ((DefaultPolymorphicTypeMapper)typeMapper).resolveMappings(this.getTableNameConverter());
            }
        }
        finally {
            this.typeMapperLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolymorphicTypeMapper getPolymorphicTypeMapper() {
        this.typeMapperLock.readLock().lock();
        try {
            if (this.typeMapper == null) {
                throw new RuntimeException("No polymorphic type mapper was specified");
            }
            PolymorphicTypeMapper polymorphicTypeMapper = this.typeMapper;
            return polymorphicTypeMapper;
        }
        finally {
            this.typeMapperLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(Cache cache) {
        this.cacheLock.writeLock().lock();
        try {
            if (!this.cache.equals(cache)) {
                this.cache.dispose();
                this.cache = cache;
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache() {
        this.cacheLock.readLock().lock();
        try {
            Cache cache = this.cache;
            return cache;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public DatabaseProvider getProvider() {
        return this.provider;
    }

    <T extends RawEntity<K>, K> EntityProxy<T, K> getProxyForEntity(T entity) {
        return ((EntityProxyAccessor)((Object)entity)).getEntityProxy();
    }

    private Reference<RawEntity<?>> createRef(RawEntity<?> entity) {
        if (this.configuration.useWeakCache()) {
            return new WeakReference(entity);
        }
        return new SoftReference(entity);
    }

    private void verify(RawEntity<?> entity) {
        if (entity.getEntityManager() != this) {
            throw new RuntimeException("Entities can only be used with a single EntityManager instance");
        }
    }

    private void putStatementParameters(PreparedStatement stmt, Object ... parameters) throws SQLException {
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            Class<Object> entityTypeOrClass = parameter instanceof RawEntity ? ((RawEntity)parameter).getEntityType() : parameter.getClass();
            TypeInfo<?> typeInfo = this.provider.getTypeManager().getType(entityTypeOrClass);
            typeInfo.getLogicalType().putToDatabase(this, stmt, i + 1, parameter, typeInfo.getJdbcWriteType());
        }
    }

    private static class CacheKey<T> {
        private T key;
        private Class<? extends RawEntity<?>> type;

        public CacheKey(T key, Class<? extends RawEntity<T>> type) {
            this.key = key;
            this.type = type;
        }

        public int hashCode() {
            return (this.type.hashCode() + this.key.hashCode()) % 65536;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey keyObj = (CacheKey)obj;
                if (this.key.equals(keyObj.key) && this.type.equals(keyObj.type)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static interface Function<R, F> {
        public R invoke(F var1) throws SQLException;
    }
}

