/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import net.java.ao.Accessor;
import net.java.ao.AnnotationDelegate;
import net.java.ao.Common;
import net.java.ao.DatabaseProvider;
import net.java.ao.EntityManager;
import net.java.ao.ImplementationWrapper;
import net.java.ao.ManyToMany;
import net.java.ao.MethodImplWrapper;
import net.java.ao.Mutator;
import net.java.ao.OneToMany;
import net.java.ao.OneToOne;
import net.java.ao.Polymorphic;
import net.java.ao.Preload;
import net.java.ao.RawEntity;
import net.java.ao.Transient;
import net.java.ao.cache.CacheLayer;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.OnUpdate;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.sql.SqlUtils;
import net.java.ao.types.DatabaseType;
import net.java.ao.types.TypeManager;

public class EntityProxy<T extends RawEntity<K>, K>
implements InvocationHandler {
    static boolean ignorePreload = false;
    private final K key;
    private final Method pkAccessor;
    private final String pkFieldName;
    private final Class<T> type;
    private final EntityManager manager;
    private CacheLayer layer;
    private Map<String, ReadWriteLock> locks;
    private final ReadWriteLock locksLock = new ReentrantReadWriteLock();
    private ImplementationWrapper<T> implementation;
    private List<PropertyChangeListener> listeners;

    public EntityProxy(EntityManager manager, Class<T> type, K key) {
        this.key = key;
        this.type = type;
        this.manager = manager;
        this.pkAccessor = Common.getPrimaryKeyAccessor(type);
        this.pkFieldName = Common.getPrimaryKeyField(type, this.getFieldNameConverter());
        this.locks = new HashMap<String, ReadWriteLock>();
        this.listeners = new LinkedList<PropertyChangeListener>();
    }

    private FieldNameConverter getFieldNameConverter() {
        return this.manager.getNameConverters().getFieldNameConverter();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String callingClassName;
        Class<?> declaringClass;
        MethodImplWrapper methodImpl;
        if (method.getName().equals("getEntityProxy")) {
            return this;
        }
        if (method.getName().equals("getEntityType")) {
            return this.type;
        }
        if (this.implementation == null) {
            this.implementation = new ImplementationWrapper();
            this.implementation.init((RawEntity)proxy);
        }
        if (!((methodImpl = this.implementation.getMethod(method.getName(), method.getParameterTypes())) == null || Object.class.equals(declaringClass = methodImpl.getMethod().getDeclaringClass()) || (callingClassName = Common.getCallingClassName(1)) != null && callingClassName.equals(declaringClass.getName()))) {
            return methodImpl.getMethod().invoke(methodImpl.getInstance(), args);
        }
        if (method.getName().equals(this.pkAccessor.getName())) {
            return this.getKey();
        }
        if (method.getName().equals("save")) {
            this.save((RawEntity)proxy);
            return Void.TYPE;
        }
        if (method.getName().equals("getEntityManager")) {
            return this.manager;
        }
        if (method.getName().equals("addPropertyChangeListener")) {
            this.addPropertyChangeListener((PropertyChangeListener)args[0]);
            return null;
        }
        if (method.getName().equals("removePropertyChangeListener")) {
            this.removePropertyChangeListener((PropertyChangeListener)args[0]);
            return null;
        }
        if (method.getName().equals("hashCode")) {
            return this.hashCodeImpl();
        }
        if (method.getName().equals("equals")) {
            return this.equalsImpl((RawEntity)proxy, args[0]);
        }
        if (method.getName().equals("toString")) {
            return this.toStringImpl();
        }
        if (method.getName().equals("init")) {
            return null;
        }
        this.checkConstraints(method, args);
        String tableName = this.getTableNameConverter().getName(this.type);
        Class<?> attributeType = Common.getAttributeTypeFromMethod(method);
        String polyFieldName = null;
        if (attributeType != null) {
            polyFieldName = attributeType.getAnnotation(Polymorphic.class) == null ? null : this.getFieldNameConverter().getPolyTypeName(method);
        }
        Mutator mutatorAnnotation = method.getAnnotation(Mutator.class);
        Accessor accessorAnnotation = method.getAnnotation(Accessor.class);
        OneToOne oneToOneAnnotation = method.getAnnotation(OneToOne.class);
        OneToMany oneToManyAnnotation = method.getAnnotation(OneToMany.class);
        ManyToMany manyToManyAnnotation = method.getAnnotation(ManyToMany.class);
        AnnotationDelegate annotations = Common.getAnnotationDelegate(this.getFieldNameConverter(), method);
        OnUpdate onUpdateAnnotation = annotations.getAnnotation(OnUpdate.class);
        Transient transientAnnotation = annotations.getAnnotation(Transient.class);
        if (mutatorAnnotation != null) {
            this.invokeSetter((RawEntity)proxy, mutatorAnnotation.value(), args[0], polyFieldName);
            return Void.TYPE;
        }
        if (accessorAnnotation != null) {
            return this.invokeGetter((RawEntity)proxy, this.getKey(), tableName, accessorAnnotation.value(), polyFieldName, method.getReturnType(), onUpdateAnnotation == null && transientAnnotation == null);
        }
        if (oneToOneAnnotation != null && Common.interfaceInheritsFrom(method.getReturnType(), RawEntity.class)) {
            Class<?> type = method.getReturnType();
            RawEntity[] back = this.retrieveRelations((RawEntity)proxy, new String[0], new String[]{Common.getPrimaryKeyField(type, this.getFieldNameConverter())}, type, Common.where(oneToOneAnnotation, this.getFieldNameConverter()), Common.getPolymorphicFieldNames(this.getFieldNameConverter(), type, this.type));
            return back.length == 0 ? null : back[0];
        }
        if (oneToManyAnnotation != null && method.getReturnType().isArray() && Common.interfaceInheritsFrom(method.getReturnType().getComponentType(), RawEntity.class)) {
            Class<?> type = method.getReturnType().getComponentType();
            return this.retrieveRelations((RawEntity)proxy, new String[0], new String[]{Common.getPrimaryKeyField(type, this.getFieldNameConverter())}, type, Common.where(oneToManyAnnotation, this.getFieldNameConverter()), Common.getPolymorphicFieldNames(this.getFieldNameConverter(), type, this.type));
        }
        if (manyToManyAnnotation != null && method.getReturnType().isArray() && Common.interfaceInheritsFrom(method.getReturnType().getComponentType(), RawEntity.class)) {
            Class<? extends RawEntity<?>> throughType = manyToManyAnnotation.value();
            Class<?> type = method.getReturnType().getComponentType();
            return this.retrieveRelations((RawEntity)proxy, null, Common.getMappingFields(this.getFieldNameConverter(), throughType, type), throughType, type, Common.where(manyToManyAnnotation, this.getFieldNameConverter()), Common.getPolymorphicFieldNames(this.getFieldNameConverter(), throughType, this.type), Common.getPolymorphicFieldNames(this.getFieldNameConverter(), throughType, type));
        }
        if (Common.isAccessor(method)) {
            return this.invokeGetter((RawEntity)proxy, this.getKey(), tableName, this.getFieldNameConverter().getName(method), polyFieldName, method.getReturnType(), onUpdateAnnotation == null && transientAnnotation == null);
        }
        if (Common.isMutator(method)) {
            this.invokeSetter((RawEntity)proxy, this.getFieldNameConverter().getName(method), args[0], polyFieldName);
            return Void.TYPE;
        }
        throw new RuntimeException("Cannot handle method with signature: " + method.toString());
    }

    private TableNameConverter getTableNameConverter() {
        return this.manager.getNameConverters().getTableNameConverter();
    }

    public K getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RawEntity entity) throws SQLException {
        CacheLayer cacheLayer = this.getCacheLayer(entity);
        String[] dirtyFields = cacheLayer.getDirtyFields();
        if (dirtyFields.length == 0) {
            return;
        }
        String table = this.getTableNameConverter().getName(this.type);
        TypeManager manager = TypeManager.getInstance();
        DatabaseProvider provider = this.manager.getProvider();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = provider.getConnection();
            StringBuilder sql = new StringBuilder("UPDATE " + provider.withSchema(table) + " SET ");
            for (String field : dirtyFields) {
                sql.append(provider.processID(field));
                if (cacheLayer.contains(field)) {
                    sql.append(" = ?,");
                    continue;
                }
                sql.append(" = NULL,");
            }
            if (sql.charAt(sql.length() - 1) == ',') {
                sql.setLength(sql.length() - 1);
            }
            sql.append(" WHERE ").append(provider.processID(this.pkFieldName)).append(" = ?");
            stmt = provider.preparedStatement(conn, sql);
            LinkedList<PropertyChangeEvent> events = new LinkedList<PropertyChangeEvent>();
            int index = 1;
            for (String field : dirtyFields) {
                if (!cacheLayer.contains(field)) continue;
                Object value = cacheLayer.get(field);
                events.add(new PropertyChangeEvent(entity, field, null, value));
                if (value == null) {
                    this.manager.getProvider().putNull(stmt, index++);
                    continue;
                }
                Class<Object> javaType = value.getClass();
                if (value instanceof RawEntity) {
                    javaType = ((RawEntity)value).getEntityType();
                }
                DatabaseType<?> dbType = manager.getType(javaType);
                dbType.putToDatabase(this.manager, stmt, index++, value);
                if (dbType.shouldCache(javaType)) continue;
                cacheLayer.remove(field);
            }
            Common.getPrimaryKeyType(this.type).putToDatabase(this.manager, stmt, index++, this.key);
            this.manager.getRelationsCache().remove(cacheLayer.getToFlush());
            cacheLayer.clearFlush();
            this.manager.getRelationsCache().remove(entity, dirtyFields);
            stmt.executeUpdate();
            for (PropertyChangeListener l : this.listeners) {
                for (PropertyChangeEvent evt : events) {
                    l.propertyChange(evt);
                }
            }
            cacheLayer.clearDirty();
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(stmt);
            SqlUtils.closeQuietly(conn);
            throw throwable;
        }
        SqlUtils.closeQuietly(stmt);
        SqlUtils.closeQuietly(conn);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public int hashCodeImpl() {
        return (this.key.hashCode() + this.type.hashCode()) % 65536;
    }

    public boolean equalsImpl(RawEntity<K> proxy, Object obj) {
        if (proxy == obj) {
            return true;
        }
        if (obj instanceof RawEntity) {
            RawEntity entity = (RawEntity)obj;
            String ourTableName = this.getTableNameConverter().getName(proxy.getEntityType());
            String theirTableName = this.getTableNameConverter().getName(entity.getEntityType());
            return Common.getPrimaryKeyValue(entity).equals(this.key) && theirTableName.equals(ourTableName);
        }
        return false;
    }

    public String toStringImpl() {
        return this.getTableNameConverter().getName(this.type) + " {" + this.pkFieldName + " = " + this.key.toString() + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EntityProxy) {
            EntityProxy proxy = (EntityProxy)obj;
            if (proxy.type.equals(this.type) && proxy.key.equals(this.key)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCodeImpl();
    }

    CacheLayer getCacheLayer(RawEntity<?> entity) {
        if (this.layer == null) {
            this.layer = this.manager.getCache().createCacheLayer(entity);
        }
        return this.layer;
    }

    Class<T> getType() {
        return this.type;
    }

    void flushCache(RawEntity<?> entity) {
        this.getCacheLayer(entity).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadWriteLock getLock(String field) {
        this.locksLock.writeLock().lock();
        try {
            if (this.locks.containsKey(field)) {
                ReadWriteLock readWriteLock = this.locks.get(field);
                return readWriteLock;
            }
            ReentrantReadWriteLock back = new ReentrantReadWriteLock();
            this.locks.put(field, back);
            ReentrantReadWriteLock reentrantReadWriteLock = back;
            return reentrantReadWriteLock;
        }
        finally {
            this.locksLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V invokeGetter(RawEntity<?> entity, K key, String table, String name, String polyName, Class<V> type, boolean shouldCache) throws Throwable {
        V back = null;
        CacheLayer cacheLayer = this.getCacheLayer(entity);
        shouldCache = shouldCache && TypeManager.getInstance().getType(type).shouldCache(type);
        this.getLock(name).writeLock().lock();
        try {
            if (!shouldCache && cacheLayer.dirtyContains(name)) {
                V v = this.handleNullReturn(null, type);
                return v;
            }
            if (shouldCache && cacheLayer.contains(name)) {
                Object value = cacheLayer.get(name);
                if (this.instanceOf(value, type)) {
                    Object object = this.handleNullReturn(value, type);
                    return (V)object;
                }
                if (this.isBigDecimal(value, type)) {
                    Object object = this.handleBigDecimal(value, type);
                    return (V)object;
                }
                if (Common.interfaceInheritsFrom(type, RawEntity.class) && this.instanceOf(value, Common.getPrimaryKeyClassType(type))) {
                    value = this.manager.peer(type, value);
                    cacheLayer.put(name, value);
                    Object object = this.handleNullReturn(value, type);
                    return (V)object;
                }
                cacheLayer.remove(name);
            }
            DatabaseProvider provider = this.manager.getProvider();
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet res = null;
            try {
                conn = provider.getConnection();
                StringBuilder sql = new StringBuilder("SELECT ");
                sql.append(provider.processID(name));
                if (polyName != null) {
                    sql.append(',').append(provider.processID(polyName));
                }
                sql.append(" FROM ").append(provider.withSchema(table)).append(" WHERE ");
                sql.append(provider.processID(this.pkFieldName)).append(" = ?");
                stmt = provider.preparedStatement(conn, sql);
                Common.getPrimaryKeyType(this.type).putToDatabase(this.manager, stmt, 1, key);
                res = stmt.executeQuery();
                if (res.next()) {
                    back = this.convertValue(res, name, polyName, type);
                }
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(res, stmt, conn);
                throw throwable;
            }
            SqlUtils.closeQuietly(res, stmt, conn);
            if (shouldCache) {
                cacheLayer.put(name, back);
            }
            V v = this.handleNullReturn(back, type);
            return v;
        }
        finally {
            this.getLock(name).writeLock().unlock();
        }
    }

    private <V> V handleNullReturn(V back, Class<V> type) {
        if (back != null) {
            return back;
        }
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                return (V)new Boolean(false);
            }
            if (type.equals(Character.TYPE)) {
                return (V)new Character(' ');
            }
            if (type.equals(Integer.TYPE)) {
                return (V)new Integer(0);
            }
            if (type.equals(Short.TYPE)) {
                return (V)new Short("0");
            }
            if (type.equals(Long.TYPE)) {
                return (V)new Long("0");
            }
            if (type.equals(Float.TYPE)) {
                return (V)new Float("0");
            }
            if (type.equals(Double.TYPE)) {
                return (V)new Double("0");
            }
            if (type.equals(Byte.TYPE)) {
                return (V)new Byte("0");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSetter(T entity, String name, Object value, String polyName) throws Throwable {
        CacheLayer cacheLayer = this.getCacheLayer((RawEntity<?>)entity);
        this.getLock(name).writeLock().lock();
        try {
            if (value instanceof RawEntity) {
                cacheLayer.markToFlush(((RawEntity)value).getEntityType());
                cacheLayer.markToFlush(entity.getEntityType());
            }
            cacheLayer.markDirty(name);
            cacheLayer.put(name, value);
            if (polyName != null) {
                String strValue = null;
                if (value != null) {
                    strValue = this.manager.getPolymorphicTypeMapper().convert(((RawEntity)value).getEntityType());
                }
                cacheLayer.markDirty(polyName);
                cacheLayer.put(polyName, strValue);
            }
        }
        finally {
            this.getLock(name).writeLock().unlock();
        }
    }

    private <V extends RawEntity<K>> V[] retrieveRelations(RawEntity<K> entity, String[] inMapFields, String[] outMapFields, Class<V> type, String where, String[] thisPolyNames) throws SQLException {
        return this.retrieveRelations(entity, inMapFields, outMapFields, type, type, where, thisPolyNames, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends RawEntity<K>> V[] retrieveRelations(RawEntity<K> entity, String[] inMapFields, String[] outMapFields, Class<? extends RawEntity<?>> type, Class<V> finalType, String where, String[] thisPolyNames, String[] thatPolyNames) throws SQLException {
        if (inMapFields == null || inMapFields.length == 0) {
            inMapFields = Common.getMappingFields(this.getFieldNameConverter(), type, this.type);
        }
        String[] fields = this.getFields(Common.getPrimaryKeyField(finalType, this.getFieldNameConverter()), inMapFields, outMapFields, where);
        RawEntity[] cached = this.manager.getRelationsCache().get(entity, finalType, type, fields);
        if (cached != null) {
            return cached;
        }
        ArrayList<V> back = new ArrayList<V>();
        ArrayList throughValues = new ArrayList();
        ArrayList<String> resPolyNames = new ArrayList<String>(thatPolyNames == null ? 0 : thatPolyNames.length);
        String table = this.getTableNameConverter().getName(type);
        boolean oneToMany = type.equals(finalType);
        Preload preloadAnnotation = finalType.getAnnotation(Preload.class);
        DatabaseProvider provider = this.manager.getProvider();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            int index;
            String returnField;
            conn = provider.getConnection();
            StringBuilder sql = new StringBuilder();
            String throughField = null;
            int numParams = 0;
            LinkedHashSet<String> selectFields = new LinkedHashSet<String>();
            if (oneToMany && inMapFields.length == 1 && outMapFields.length == 1 && preloadAnnotation != null && !ignorePreload) {
                sql.append("SELECT ");
                selectFields.add(outMapFields[0]);
                selectFields.addAll(Common.preloadValue(preloadAnnotation, this.getFieldNameConverter()));
                if (selectFields.contains("*")) {
                    sql.append("*");
                } else {
                    for (String field : selectFields) {
                        sql.append(provider.processID(field)).append(',');
                    }
                    sql.setLength(sql.length() - 1);
                }
                sql.append(" FROM ").append(provider.withSchema(table));
                sql.append(" WHERE ").append(provider.processID(inMapFields[0])).append(" = ?");
                if (!where.trim().equals("")) {
                    sql.append(" AND (").append(this.manager.getProvider().processWhereClause(where)).append(")");
                }
                if (thisPolyNames != null) {
                    for (String name : thisPolyNames) {
                        sql.append(" AND ").append(provider.processID(name)).append(" = ?");
                    }
                }
                ++numParams;
                returnField = outMapFields[0];
            } else if (!oneToMany && inMapFields.length == 1 && outMapFields.length == 1 && preloadAnnotation != null && !ignorePreload) {
                String finalTable = this.getTableNameConverter().getName(finalType);
                returnField = this.manager.getProvider().shorten(finalTable + "__aointernal__id");
                throughField = this.manager.getProvider().shorten(table + "__aointernal__id");
                sql.append("SELECT ");
                String finalPKField = Common.getPrimaryKeyField(finalType, this.getFieldNameConverter());
                selectFields.add(finalPKField);
                selectFields.addAll(Common.preloadValue(preloadAnnotation, this.getFieldNameConverter()));
                if (selectFields.contains("*")) {
                    selectFields.remove("*");
                    selectFields.addAll(Common.getValueFieldsNames(finalType, this.getFieldNameConverter()));
                }
                sql.append(provider.withSchema(finalTable)).append('.').append(provider.processID(finalPKField));
                sql.append(" AS ").append(provider.quote(returnField)).append(',');
                selectFields.remove(finalPKField);
                sql.append(provider.withSchema(table)).append('.').append(provider.processID(Common.getPrimaryKeyField(type, this.getFieldNameConverter())));
                sql.append(" AS ").append(provider.quote(throughField)).append(',');
                for (String field : selectFields) {
                    sql.append(provider.withSchema(finalTable)).append('.').append(provider.processID(field)).append(',');
                }
                sql.setLength(sql.length() - 1);
                if (thatPolyNames != null) {
                    for (String name : thatPolyNames) {
                        String toAppend = table + '.' + name;
                        resPolyNames.add(toAppend);
                        sql.append(',').append(provider.processID(toAppend));
                    }
                }
                sql.append(" FROM ").append(provider.withSchema(table)).append(" INNER JOIN ");
                sql.append(provider.withSchema(finalTable)).append(" ON ");
                sql.append(provider.withSchema(table)).append('.').append(provider.processID(outMapFields[0]));
                sql.append(" = ").append(provider.withSchema(finalTable)).append('.').append(provider.processID(finalPKField));
                sql.append(" WHERE ").append(provider.withSchema(table)).append('.').append(provider.processID(inMapFields[0])).append(" = ?");
                if (!where.trim().equals("")) {
                    sql.append(" AND (").append(this.manager.getProvider().processWhereClause(where)).append(")");
                }
                if (thisPolyNames != null) {
                    for (String name : thisPolyNames) {
                        sql.append(" AND ").append(provider.processID(name)).append(" = ?");
                    }
                }
                ++numParams;
            } else if (inMapFields.length == 1 && outMapFields.length == 1) {
                sql.append("SELECT ").append(provider.processID(outMapFields[0]));
                selectFields.add(outMapFields[0]);
                if (!oneToMany) {
                    throughField = Common.getPrimaryKeyField(type, this.getFieldNameConverter());
                    sql.append(',').append(provider.processID(throughField));
                    selectFields.add(throughField);
                }
                if (thatPolyNames != null) {
                    for (String name : thatPolyNames) {
                        resPolyNames.add(name);
                        sql.append(',').append(provider.processID(name));
                        selectFields.add(name);
                    }
                }
                sql.append(" FROM ").append(provider.withSchema(table));
                sql.append(" WHERE ").append(provider.processID(inMapFields[0])).append(" = ?");
                if (!where.trim().equals("")) {
                    sql.append(" AND (").append(this.manager.getProvider().processWhereClause(where)).append(")");
                }
                if (thisPolyNames != null) {
                    for (String name : thisPolyNames) {
                        sql.append(" AND ").append(provider.processID(name)).append(" = ?");
                    }
                }
                ++numParams;
                returnField = outMapFields[0];
            } else {
                sql.append("SELECT DISTINCT a.outMap AS outMap");
                selectFields.add("outMap");
                if (thatPolyNames != null) {
                    for (String name : thatPolyNames) {
                        resPolyNames.add(name);
                        sql.append(',').append("a.").append(provider.processID(name)).append(" AS ").append(provider.processID(name));
                        selectFields.add(name);
                    }
                }
                sql.append(" FROM (");
                returnField = "outMap";
                for (String outMap : outMapFields) {
                    for (String inMap : inMapFields) {
                        sql.append("SELECT ");
                        sql.append(provider.processID(outMap));
                        sql.append(" AS outMap,");
                        sql.append(provider.processID(inMap));
                        sql.append(" AS inMap");
                        if (thatPolyNames != null) {
                            for (String name : thatPolyNames) {
                                sql.append(',').append(provider.processID(name));
                            }
                        }
                        if (thisPolyNames != null) {
                            for (String name : thisPolyNames) {
                                sql.append(',').append(provider.processID(name));
                            }
                        }
                        sql.append(" FROM ").append(provider.withSchema(table));
                        sql.append(" WHERE ");
                        sql.append(provider.processID(inMap)).append(" = ?");
                        if (!where.trim().equals("")) {
                            sql.append(" AND (").append(this.manager.getProvider().processWhereClause(where)).append(")");
                        }
                        sql.append(" UNION ");
                        ++numParams;
                    }
                }
                sql.setLength(sql.length() - " UNION ".length());
                sql.append(") a");
                if (thatPolyNames != null) {
                    if (thatPolyNames.length > 0) {
                        sql.append(" WHERE (");
                    }
                    for (String name : thatPolyNames) {
                        sql.append("a.").append(provider.processID(name)).append(" = ?").append(" OR ");
                    }
                    if (thatPolyNames.length > 0) {
                        sql.setLength(sql.length() - " OR ".length());
                        sql.append(')');
                    }
                }
                if (thisPolyNames != null) {
                    if (thisPolyNames.length > 0) {
                        if (thatPolyNames == null) {
                            sql.append(" WHERE (");
                        } else {
                            sql.append(" AND (");
                        }
                    }
                    for (String name : thisPolyNames) {
                        sql.append("a.").append(provider.processID(name)).append(" = ?").append(" OR ");
                    }
                    if (thisPolyNames.length > 0) {
                        sql.setLength(sql.length() - " OR ".length());
                        sql.append(')');
                    }
                }
            }
            stmt = provider.preparedStatement(conn, sql);
            DatabaseType<K> dbType = TypeManager.getInstance().getType(EntityProxy.getClass(this.key));
            for (index = 0; index < numParams; ++index) {
                dbType.putToDatabase(this.manager, stmt, index + 1, this.key);
            }
            int newLength = numParams + (thisPolyNames == null ? 0 : thisPolyNames.length);
            String typeValue = this.manager.getPolymorphicTypeMapper().convert(this.type);
            while (index < newLength) {
                stmt.setString(index + 1, typeValue);
                ++index;
            }
            dbType = Common.getPrimaryKeyType(finalType);
            DatabaseType throughDBType = Common.getPrimaryKeyType(type);
            res = stmt.executeQuery();
            while (res.next()) {
                RawEntity<?> returnValue = dbType.pullFromDatabase(this.manager, res, type, returnField);
                Class<Object> backType = finalType;
                for (String polyName : resPolyNames) {
                    typeValue = res.getString(polyName);
                    if (typeValue == null) continue;
                    backType = this.manager.getPolymorphicTypeMapper().invert(finalType, typeValue);
                    break;
                }
                if (backType.equals(this.type) && returnValue.equals(this.key)) continue;
                if (throughField != null) {
                    throughValues.add(this.manager.peer(type, throughDBType.pullFromDatabase(this.manager, res, type, throughField)));
                }
                V returnValueEntity = this.manager.peer(backType, returnValue);
                CacheLayer returnLayer = this.manager.getProxyForEntity(returnValueEntity).getCacheLayer((RawEntity<?>)returnValueEntity);
                if (selectFields.contains("*")) {
                    selectFields.remove("*");
                    selectFields.addAll(Common.getValueFieldsNames(finalType, this.getFieldNameConverter()));
                }
                for (String field : selectFields) {
                    if (resPolyNames.contains(field)) continue;
                    returnLayer.put(field, res.getObject(field));
                }
                back.add(returnValueEntity);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(res, stmt, conn);
            throw throwable;
        }
        SqlUtils.closeQuietly(res, stmt, conn);
        cached = back.toArray((RawEntity[])Array.newInstance(finalType, back.size()));
        this.manager.getRelationsCache().put(entity, throughValues.size() > 0 ? throughValues.toArray(new RawEntity[throughValues.size()]) : cached, type, cached, finalType, fields);
        return cached;
    }

    private static <O> Class<O> getClass(O object) {
        return object.getClass();
    }

    private String[] getFields(String pkField, String[] inMapFields, String[] outMapFields, String where) {
        ArrayList<String> back = new ArrayList<String>();
        back.addAll(Arrays.asList(outMapFields));
        if (inMapFields != null && inMapFields.length > 0 && !inMapFields[0].trim().equalsIgnoreCase(pkField)) {
            back.addAll(Arrays.asList(inMapFields));
        }
        Matcher matcher = SqlUtils.WHERE_CLAUSE.matcher(where);
        while (matcher.find()) {
            back.add(matcher.group(1));
        }
        return back.toArray(new String[back.size()]);
    }

    private <V> V convertValue(ResultSet res, String field, String polyName, Class<V> type) throws SQLException {
        TypeManager manager;
        DatabaseType<V> databaseType;
        if (this.isNull(res, field)) {
            return null;
        }
        if (polyName != null) {
            Class<Object> entityType = type;
            type = entityType = this.manager.getPolymorphicTypeMapper().invert(entityType, res.getString(polyName));
        }
        if ((databaseType = (manager = TypeManager.getInstance()).getType(type)) == null) {
            throw new RuntimeException("UnrecognizedType: " + type.toString());
        }
        return databaseType.pullFromDatabase(this.manager, res, type, field);
    }

    private boolean isNull(ResultSet res, String field) throws SQLException {
        res.getObject(field);
        return res.wasNull();
    }

    private boolean instanceOf(Object value, Class<?> type) {
        if (value == null) {
            return true;
        }
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                return this.instanceOf(value, Boolean.class);
            }
            if (type.equals(Character.TYPE)) {
                return this.instanceOf(value, Character.class);
            }
            if (type.equals(Byte.TYPE)) {
                return this.instanceOf(value, Byte.class);
            }
            if (type.equals(Short.TYPE)) {
                return this.instanceOf(value, Short.class);
            }
            if (type.equals(Integer.TYPE)) {
                return this.instanceOf(value, Integer.class);
            }
            if (type.equals(Long.TYPE)) {
                return this.instanceOf(value, Long.class);
            }
            if (type.equals(Float.TYPE)) {
                return this.instanceOf(value, Float.class);
            }
            if (type.equals(Double.TYPE)) {
                return this.instanceOf(value, Double.class);
            }
        } else {
            return type.isInstance(value);
        }
        return false;
    }

    private boolean isBigDecimal(Object value, Class<?> type) {
        if (!(value instanceof BigDecimal)) {
            return false;
        }
        return type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Float.TYPE) || type.equals(Double.TYPE);
    }

    private Object handleBigDecimal(Object value, Class<?> type) {
        BigDecimal bd = (BigDecimal)value;
        if (type.equals(Integer.TYPE)) {
            return bd.intValue();
        }
        if (type.equals(Long.TYPE)) {
            return bd.longValue();
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(bd.floatValue());
        }
        if (type.equals(Double.TYPE)) {
            return bd.doubleValue();
        }
        throw new RuntimeException("Could not resolve actual type for object :" + value + ", expected type is " + type);
    }

    private void checkConstraints(Method method, Object[] args) {
        AnnotationDelegate annotations = Common.getAnnotationDelegate(this.getFieldNameConverter(), method);
        NotNull notNullAnnotation = annotations.getAnnotation(NotNull.class);
        if (notNullAnnotation != null && args != null && args.length > 0 && args[0] == null) {
            String name = this.getFieldNameConverter().getName(method);
            throw new IllegalArgumentException("Field '" + name + "' does not accept null values");
        }
    }
}

