/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.ao.EntityManager;
import net.java.ao.types.DatabaseType;

class EnumType
extends DatabaseType<Enum<?>> {
    protected EnumType() {
        super(4, 4, Enum.class);
    }

    @Override
    public Enum<?> pullFromDatabase(EntityManager manager, ResultSet res, Class<? extends Enum<?>> type, String field) throws SQLException {
        Enum[] values = null;
        int dbValue = res.getInt(field);
        try {
            values = (Enum[])type.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        assert (values != null);
        for (Enum value : values) {
            if (dbValue != value.ordinal()) continue;
            return value;
        }
        return null;
    }

    @Override
    public void putToDatabase(EntityManager manager, PreparedStatement stmt, int index, Enum<?> value) throws SQLException {
        stmt.setInt(index, value.ordinal());
    }

    @Override
    public Object defaultParseValue(String value) {
        return Integer.parseInt(value);
    }

    @Override
    public String getDefaultName() {
        return "INTEGER";
    }
}

