/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema.ddl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.ao.Common;
import net.java.ao.DatabaseProvider;
import net.java.ao.SchemaConfiguration;
import net.java.ao.schema.NameConverters;
import net.java.ao.schema.ddl.DDLAction;
import net.java.ao.schema.ddl.DDLActionType;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLForeignKey;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.schema.helper.DatabaseMetaDataReader;
import net.java.ao.schema.helper.DatabaseMetaDataReaderImpl;
import net.java.ao.schema.helper.Field;
import net.java.ao.schema.helper.ForeignKey;
import net.java.ao.schema.helper.Index;
import net.java.ao.sql.SqlUtils;
import net.java.ao.types.TypeManager;

public final class SchemaReader {
    private static final long DEFAULT_MYSQL_TIME;

    public static DDLTable[] readSchema(DatabaseProvider provider, NameConverters nameConverters, SchemaConfiguration schemaConfiguration) throws SQLException {
        return SchemaReader.readSchema(provider, nameConverters, schemaConfiguration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDLTable[] readSchema(DatabaseProvider provider, NameConverters nameConverters, SchemaConfiguration schemaConfiguration, boolean includeForeignKeys) throws SQLException {
        Connection connection = null;
        try {
            connection = provider.getConnection();
            DDLTable[] dDLTableArray = SchemaReader.readSchema(connection, provider, nameConverters, schemaConfiguration, includeForeignKeys);
            return dDLTableArray;
        }
        finally {
            SqlUtils.closeQuietly(connection);
        }
    }

    public static DDLTable[] readSchema(Connection connection, DatabaseProvider provider, NameConverters nameConverters, SchemaConfiguration schemaConfiguration, final boolean includeForeignKeys) throws SQLException {
        final DatabaseMetaDataReaderImpl databaseMetaDataReader = new DatabaseMetaDataReaderImpl(provider, nameConverters, schemaConfiguration);
        final DatabaseMetaData databaseMetaData = connection.getMetaData();
        ArrayList tables = Lists.newArrayList((Iterable)Iterables.transform(databaseMetaDataReader.getTableNames(databaseMetaData), (Function)new Function<String, DDLTable>(){

            public DDLTable apply(String tableName) {
                return SchemaReader.readTable(databaseMetaDataReader, databaseMetaData, tableName, includeForeignKeys);
            }
        }));
        return tables.toArray(new DDLTable[tables.size()]);
    }

    private static DDLTable readTable(DatabaseMetaDataReader databaseMetaDataReader, DatabaseMetaData databaseMetaData, String tableName, boolean includeForeignKeys) {
        DDLTable table = new DDLTable();
        table.setName(tableName);
        List<DDLField> fields = SchemaReader.readFields(databaseMetaDataReader, databaseMetaData, tableName);
        table.setFields(fields.toArray(new DDLField[fields.size()]));
        if (includeForeignKeys) {
            List<DDLForeignKey> foreignKeys = SchemaReader.readForeignKeys(databaseMetaDataReader, databaseMetaData, tableName);
            table.setForeignKeys(foreignKeys.toArray(new DDLForeignKey[foreignKeys.size()]));
        }
        List<DDLIndex> indexes = SchemaReader.readIndexes(databaseMetaDataReader, databaseMetaData, tableName);
        table.setIndexes(indexes.toArray(new DDLIndex[indexes.size()]));
        return table;
    }

    private static List<DDLField> readFields(DatabaseMetaDataReader databaseMetaDataReader, DatabaseMetaData databaseMetaData, String tableName) {
        return Lists.newArrayList((Iterable)Iterables.transform(databaseMetaDataReader.getFields(databaseMetaData, tableName), (Function)new Function<Field, DDLField>(){

            public DDLField apply(Field from) {
                DDLField field = new DDLField();
                field.setAutoIncrement(from.isAutoIncrement());
                field.setDefaultValue(from.getDefaultValue());
                field.setName(from.getName());
                field.setNotNull(from.isNotNull());
                field.setPrimaryKey(from.isPrimaryKey());
                field.setType(from.getDatabaseType());
                field.setJdbcType(from.getJdbcType());
                field.setUnique(from.isUnique());
                return field;
            }
        }));
    }

    private static List<DDLForeignKey> readForeignKeys(DatabaseMetaDataReader databaseMetaDataReader, DatabaseMetaData databaseMetaData, String tableName) {
        return Lists.newArrayList((Iterable)Iterables.transform(databaseMetaDataReader.getForeignKeys(databaseMetaData, tableName), (Function)new Function<ForeignKey, DDLForeignKey>(){

            public DDLForeignKey apply(ForeignKey from) {
                DDLForeignKey key = new DDLForeignKey();
                key.setForeignField(from.getForeignFieldName());
                key.setField(from.getLocalFieldName());
                key.setTable(from.getForeignTableName());
                key.setDomesticTable(from.getLocalTableName());
                return key;
            }
        }));
    }

    private static List<DDLIndex> readIndexes(DatabaseMetaDataReader databaseMetaDataReader, DatabaseMetaData databaseMetaData, final String tableName) {
        return Lists.newArrayList((Iterable)Iterables.transform(databaseMetaDataReader.getIndexes(databaseMetaData, tableName), (Function)new Function<Index, DDLIndex>(){

            public DDLIndex apply(Index index) {
                DDLIndex ddl = new DDLIndex();
                ddl.setTable(tableName);
                ddl.setField(index.getFieldName());
                return ddl;
            }
        }));
    }

    public static DDLAction[] diffSchema(TypeManager typeManager, DDLTable[] fromArray, DDLTable[] ontoArray, boolean caseSensetive) {
        DDLAction action;
        String tableName;
        HashSet<DDLAction> actions = new HashSet<DDLAction>();
        ArrayList<DDLTable> createTables = new ArrayList<DDLTable>();
        ArrayList<DDLTable> dropTables = new ArrayList<DDLTable>();
        ArrayList<DDLTable> alterTables = new ArrayList<DDLTable>();
        HashMap<String, DDLTable> from = new HashMap<String, DDLTable>();
        HashMap<String, DDLTable> onto = new HashMap<String, DDLTable>();
        for (DDLTable table : fromArray) {
            tableName = table.getName();
            if (!caseSensetive) {
                tableName = tableName.toLowerCase();
            }
            from.put(tableName, table);
        }
        for (DDLTable table : ontoArray) {
            tableName = table.getName();
            if (!caseSensetive) {
                tableName = tableName.toLowerCase();
            }
            onto.put(tableName, table);
        }
        for (DDLTable table : fromArray) {
            tableName = SchemaReader.transform(table.getName(), caseSensetive);
            if (onto.containsKey(tableName)) {
                alterTables.add(table);
                continue;
            }
            createTables.add(table);
        }
        for (DDLTable table : ontoArray) {
            tableName = SchemaReader.transform(table.getName(), caseSensetive);
            if (from.containsKey(tableName)) continue;
            dropTables.add(table);
        }
        for (DDLTable table : createTables) {
            DDLAction action2 = new DDLAction(DDLActionType.CREATE);
            action2.setTable(table);
            actions.add(action2);
        }
        ArrayList<DDLForeignKey> dropKeys = new ArrayList<DDLForeignKey>();
        for (DDLTable table : dropTables) {
            action = new DDLAction(DDLActionType.DROP);
            action.setTable(table);
            actions.add(action);
            dropKeys.addAll(Arrays.asList(table.getForeignKeys()));
            for (DDLTable alterTable : alterTables) {
                for (DDLForeignKey fKey : alterTable.getForeignKeys()) {
                    if (!SchemaReader.equals(fKey.getTable(), table.getName(), caseSensetive)) continue;
                    dropKeys.add(fKey);
                }
            }
        }
        for (DDLTable fromTable : alterTables) {
            boolean found;
            String fieldName;
            String s = fromTable.getName();
            tableName = SchemaReader.transform(s, caseSensetive);
            DDLTable ontoTable = (DDLTable)onto.get(tableName);
            ArrayList<DDLField> createFields = new ArrayList<DDLField>();
            ArrayList<DDLField> dropFields = new ArrayList<DDLField>();
            ArrayList<DDLField> alterFields = new ArrayList<DDLField>();
            HashMap<String, DDLField> fromFields = new HashMap<String, DDLField>();
            HashMap<String, DDLField> ontoFields = new HashMap<String, DDLField>();
            for (DDLField field : fromTable.getFields()) {
                fieldName = SchemaReader.transform(field.getName(), caseSensetive);
                fromFields.put(fieldName, field);
            }
            for (DDLField field : ontoTable.getFields()) {
                fieldName = SchemaReader.transform(field.getName(), caseSensetive);
                ontoFields.put(fieldName, field);
            }
            for (DDLField field : fromTable.getFields()) {
                fieldName = SchemaReader.transform(field.getName(), caseSensetive);
                if (ontoFields.containsKey(fieldName)) {
                    alterFields.add(field);
                    continue;
                }
                createFields.add(field);
            }
            for (DDLField field : ontoTable.getFields()) {
                fieldName = SchemaReader.transform(field.getName(), caseSensetive);
                if (fromFields.containsKey(fieldName)) continue;
                dropFields.add(field);
            }
            for (DDLField field : createFields) {
                DDLAction action3 = new DDLAction(DDLActionType.ALTER_ADD_COLUMN);
                action3.setTable(fromTable);
                action3.setField(field);
                actions.add(action3);
            }
            for (DDLField field : dropFields) {
                DDLAction action4 = new DDLAction(DDLActionType.ALTER_DROP_COLUMN);
                action4.setTable(fromTable);
                action4.setField(field);
                actions.add(action4);
            }
            for (DDLField fromField : alterFields) {
                String fieldName2 = SchemaReader.transform(fromField.getName(), caseSensetive);
                DDLField ontoField = (DDLField)ontoFields.get(fieldName2);
                if (fromField.getDefaultValue() == null && ontoField.getDefaultValue() != null) {
                    actions.add(SchemaReader.createColumnAlterAction(fromTable, ontoField, fromField));
                    continue;
                }
                if (fromField.getDefaultValue() != null && !Common.fuzzyCompare(typeManager, fromField.getDefaultValue(), ontoField.getDefaultValue())) {
                    actions.add(SchemaReader.createColumnAlterAction(fromTable, ontoField, fromField));
                    continue;
                }
                if (!Common.fuzzyTypeCompare(fromField.getJdbcType(), ontoField.getJdbcType())) {
                    actions.add(SchemaReader.createColumnAlterAction(fromTable, ontoField, fromField));
                    continue;
                }
                if (fromField.isNotNull() != ontoField.isNotNull()) {
                    actions.add(SchemaReader.createColumnAlterAction(fromTable, ontoField, fromField));
                    continue;
                }
                if (fromField.isPrimaryKey() || fromField.isUnique() == ontoField.isUnique()) continue;
                actions.add(SchemaReader.createColumnAlterAction(fromTable, ontoField, fromField));
            }
            ArrayList<DDLForeignKey> addKeys = new ArrayList<DDLForeignKey>();
            for (DDLForeignKey fromKey : fromTable.getForeignKeys()) {
                for (DDLForeignKey ontoKey : ontoTable.getForeignKeys()) {
                    if (fromKey.getTable().equalsIgnoreCase(ontoKey.getTable()) && fromKey.getForeignField().equalsIgnoreCase(ontoKey.getForeignField()) || !fromKey.getField().equalsIgnoreCase(ontoKey.getField()) || !fromKey.getDomesticTable().equalsIgnoreCase(ontoKey.getDomesticTable())) continue;
                    addKeys.add(fromKey);
                }
            }
            for (DDLForeignKey ontoKey : ontoTable.getForeignKeys()) {
                for (DDLForeignKey fromKey : fromTable.getForeignKeys()) {
                    if (ontoKey.getTable().equalsIgnoreCase(fromKey.getTable()) && ontoKey.getForeignField().equalsIgnoreCase(fromKey.getForeignField()) || !ontoKey.getField().equalsIgnoreCase(fromKey.getField()) || !ontoKey.getDomesticTable().equalsIgnoreCase(fromKey.getDomesticTable())) continue;
                    dropKeys.add(ontoKey);
                }
            }
            for (DDLForeignKey key : addKeys) {
                DDLAction action5 = new DDLAction(DDLActionType.ALTER_ADD_KEY);
                action5.setKey(key);
                actions.add(action5);
            }
            ArrayList<DDLIndex> addIndexes = new ArrayList<DDLIndex>();
            ArrayList<DDLIndex> dropIndexes = new ArrayList<DDLIndex>();
            for (DDLIndex fromIndex : fromTable.getIndexes()) {
                found = false;
                for (DDLIndex ontoIndex : ontoTable.getIndexes()) {
                    if (!fromIndex.getTable().equalsIgnoreCase(ontoIndex.getTable()) || !fromIndex.getField().equalsIgnoreCase(ontoIndex.getField())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                addIndexes.add(fromIndex);
            }
            for (DDLIndex ontoIndex : ontoTable.getIndexes()) {
                found = false;
                for (DDLIndex fromIndex : fromTable.getIndexes()) {
                    if (!ontoIndex.getTable().equalsIgnoreCase(fromIndex.getTable()) || !ontoIndex.getField().equalsIgnoreCase(fromIndex.getField())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                dropIndexes.add(ontoIndex);
            }
            for (DDLIndex index : addIndexes) {
                DDLAction action6 = new DDLAction(DDLActionType.CREATE_INDEX);
                action6.setIndex(index);
                actions.add(action6);
            }
            for (DDLIndex index : dropIndexes) {
                DDLAction action7 = new DDLAction(DDLActionType.DROP_INDEX);
                action7.setIndex(index);
                actions.add(action7);
            }
        }
        for (DDLForeignKey key : dropKeys) {
            action = new DDLAction(DDLActionType.ALTER_DROP_KEY);
            action.setKey(key);
            actions.add(action);
        }
        return actions.toArray(new DDLAction[actions.size()]);
    }

    private static boolean equals(String s, String s1, boolean caseSensitive) {
        return SchemaReader.transform(s, caseSensitive).equals(SchemaReader.transform(s1, caseSensitive));
    }

    private static String transform(String s, boolean caseSensitive) {
        String tableName = s;
        if (!caseSensitive) {
            tableName = tableName.toLowerCase();
        }
        return tableName;
    }

    public static DDLAction[] sortTopologically(DDLAction[] actions) {
        LinkedList<DDLAction> back = new LinkedList<DDLAction>();
        HashMap<DDLAction, Set<DDLAction>> deps = new HashMap<DDLAction, Set<DDLAction>>();
        LinkedList<DDLAction> roots = new LinkedList<DDLAction>();
        HashSet<DDLAction> covered = new HashSet<DDLAction>();
        SchemaReader.performSort(actions, deps, roots);
        while (!roots.isEmpty()) {
            DDLAction[] rootsArray = roots.toArray(new DDLAction[roots.size()]);
            roots.remove(rootsArray[0]);
            if (covered.contains(rootsArray[0])) {
                throw new RuntimeException("Circular dependency detected in or below " + rootsArray[0].getTable().getName());
            }
            covered.add(rootsArray[0]);
            back.add(rootsArray[0]);
            LinkedList<DDLAction> toRemove = new LinkedList<DDLAction>();
            for (DDLAction depAction : deps.keySet()) {
                Set individualDeps = (Set)deps.get(depAction);
                individualDeps.remove(rootsArray[0]);
                if (!individualDeps.isEmpty()) continue;
                roots.add(depAction);
                toRemove.add(depAction);
            }
            for (DDLAction action : toRemove) {
                deps.remove(action);
            }
        }
        return back.toArray(new DDLAction[back.size()]);
    }

    private static void performSort(DDLAction[] actions, Map<DDLAction, Set<DDLAction>> deps, List<DDLAction> roots) {
        DDLForeignKey key;
        LinkedList<DDLAction> dropKeys = new LinkedList<DDLAction>();
        LinkedList<DDLAction> dropIndexes = new LinkedList<DDLAction>();
        LinkedList<DDLAction> dropColumns = new LinkedList<DDLAction>();
        LinkedList<DDLAction> changeColumns = new LinkedList<DDLAction>();
        LinkedList<DDLAction> drops = new LinkedList<DDLAction>();
        LinkedList<DDLAction> creates = new LinkedList<DDLAction>();
        LinkedList<DDLAction> addColumns = new LinkedList<DDLAction>();
        LinkedList<DDLAction> addKeys = new LinkedList<DDLAction>();
        LinkedList<DDLAction> createIndexes = new LinkedList<DDLAction>();
        block11: for (DDLAction action : actions) {
            switch (action.getActionType()) {
                case ALTER_DROP_KEY: {
                    dropKeys.add(action);
                    continue block11;
                }
                case DROP_INDEX: {
                    dropIndexes.add(action);
                    continue block11;
                }
                case ALTER_DROP_COLUMN: {
                    dropColumns.add(action);
                    continue block11;
                }
                case ALTER_CHANGE_COLUMN: {
                    changeColumns.add(action);
                    continue block11;
                }
                case DROP: {
                    drops.add(action);
                    continue block11;
                }
                case CREATE: {
                    creates.add(action);
                    continue block11;
                }
                case ALTER_ADD_COLUMN: {
                    addColumns.add(action);
                    continue block11;
                }
                case ALTER_ADD_KEY: {
                    addKeys.add(action);
                    continue block11;
                }
                case CREATE_INDEX: {
                    createIndexes.add(action);
                }
            }
        }
        roots.addAll(dropKeys);
        roots.addAll(dropIndexes);
        for (DDLAction action : dropColumns) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            for (DDLAction depAction : dropKeys) {
                key = depAction.getKey();
                if ((!key.getTable().equals(action.getTable().getName()) || !key.getForeignField().equals(action.getField().getName())) && (!key.getDomesticTable().equals(action.getTable().getName()) || !key.getField().equals(action.getField().getName()))) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : changeColumns) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            for (DDLAction depAction : dropKeys) {
                key = depAction.getKey();
                if ((!key.getTable().equals(action.getTable().getName()) || !key.getForeignField().equals(action.getField().getName())) && (!key.getDomesticTable().equals(action.getTable().getName()) || !key.getField().equals(action.getField().getName()))) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : dropColumns) {
                if ((!depAction.getTable().equals(action.getTable()) || !depAction.getField().equals(action.getField())) && (!depAction.getTable().equals(action.getTable()) || !depAction.getField().equals(action.getOldField()))) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : drops) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            for (DDLAction depAction : dropKeys) {
                key = depAction.getKey();
                if (!key.getTable().equals(action.getTable().getName()) && !key.getDomesticTable().equals(action.getTable().getName())) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : dropColumns) {
                if (!depAction.getTable().equals(action.getTable())) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : changeColumns) {
                if (!depAction.getTable().equals(action.getTable())) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : creates) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            for (DDLForeignKey key2 : action.getTable().getForeignKeys()) {
                for (DDLAction depAction : creates) {
                    if (depAction == action || !depAction.getTable().getName().equals(key2.getTable())) continue;
                    dependencies.add(depAction);
                }
                for (DDLAction depAction : addColumns) {
                    if (!depAction.getTable().getName().equals(key2.getTable()) || !depAction.getField().getName().equals(key2.getForeignField())) continue;
                    dependencies.add(depAction);
                }
                for (DDLAction depAction : changeColumns) {
                    if (!depAction.getTable().getName().equals(key2.getTable()) || !depAction.getField().getName().equals(key2.getForeignField())) continue;
                    dependencies.add(depAction);
                }
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : addColumns) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            for (DDLAction depAction : creates) {
                if (!depAction.getTable().equals(action.getTable())) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : addKeys) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            DDLForeignKey key3 = action.getKey();
            for (DDLAction depAction : creates) {
                if (!depAction.getTable().getName().equals(key3.getTable()) && !depAction.getTable().getName().equals(key3.getDomesticTable())) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : addColumns) {
                if ((!depAction.getTable().getName().equals(key3.getTable()) || !depAction.getField().getName().equals(key3.getForeignField())) && (!depAction.getTable().getName().equals(key3.getDomesticTable()) || !depAction.getField().getName().equals(key3.getField()))) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : changeColumns) {
                if ((!depAction.getTable().getName().equals(key3.getTable()) || !depAction.getField().getName().equals(key3.getForeignField())) && (!depAction.getTable().getName().equals(key3.getDomesticTable()) || !depAction.getField().getName().equals(key3.getField()))) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : createIndexes) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            DDLIndex index = action.getIndex();
            for (DDLAction depAction : creates) {
                if (!depAction.getTable().getName().equals(index.getTable())) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : addColumns) {
                if (!depAction.getTable().getName().equals(index.getTable()) && !depAction.getField().getName().equals(index.getField())) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : changeColumns) {
                if (!depAction.getTable().getName().equals(index.getTable()) && !depAction.getField().getName().equals(index.getField())) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
    }

    private static DDLAction createColumnAlterAction(DDLTable table, DDLField oldField, DDLField field) {
        DDLAction action = new DDLAction(DDLActionType.ALTER_CHANGE_COLUMN);
        action.setTable(table);
        action.setField(field);
        action.setOldField(oldField);
        return action;
    }

    static {
        try {
            DEFAULT_MYSQL_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("0000-00-00 00:00:00").getTime();
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }
}

