/*
 * Copyright 2007 Daniel Spiewak
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.java.ao.schema;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import net.java.ao.Accessor;
import net.java.ao.Entity;
import net.java.ao.EntityManager;
import net.java.ao.Mutator;

/**
 * <p>Marks a method such that the corresponding database field will be
 * the primary key for the table in question.  Using this annotation, it
 * is possible to specify arbitrary primary key field names and types.</p>
 * 
 * <p>The logic in both migrations and entity invocation handling assumes
 * that there is only a single primary key per entity type.  If the entity
 * type does not contain exactly one field (may be more than one method)
 * as a primary key, odd errors will ensue.  Primary keys need not be
 * defined within the entity type itself.  For example, most entities
 * inherit from the {@link Entity} interface, which defines the
 * <code>id</code> field as the primary key.  Such entities would not
 * have to (in fact, should not at all) explicitly define a primary key
 * field.</p>
 * 
 * @author Daniel Spiewak
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface PrimaryKey {
	
	/**
	 * Specifies a name for the underlying field.  Should be used to
	 * override the field name in much the same way as the
	 * {@link Accessor} and {@link Mutator} annotations.  Unless specified,
	 * the underlying field name will be generated by the field name
	 * converter for the {@link EntityManager} in use. 
	 */
	String value() default "";
}
