/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.ao.DatabaseProvider;
import net.java.ao.Query;
import net.java.ao.SchemaConfiguration;
import net.java.ao.schema.NameConverters;
import net.java.ao.schema.helper.DatabaseMetaDataReader;
import net.java.ao.schema.helper.Field;
import net.java.ao.schema.helper.ForeignKey;
import net.java.ao.schema.helper.Index;
import net.java.ao.sql.AbstractCloseableResultSetMetaData;
import net.java.ao.sql.CloseableResultSetMetaData;
import net.java.ao.sql.SqlUtils;
import net.java.ao.types.TypeInfo;
import net.java.ao.types.TypeManager;
import net.java.ao.types.TypeQualifiers;
import net.java.ao.util.StringUtils;

public class DatabaseMetaDataReaderImpl
implements DatabaseMetaDataReader {
    private static final Pattern STRING_VALUE = Pattern.compile("\"(.*)\"");
    private final DatabaseProvider databaseProvider;
    private final NameConverters nameConverters;
    private final SchemaConfiguration schemaConfiguration;

    public DatabaseMetaDataReaderImpl(DatabaseProvider databaseProvider, NameConverters nameConverters, SchemaConfiguration schemaConfiguration) {
        this.databaseProvider = databaseProvider;
        this.nameConverters = nameConverters;
        this.schemaConfiguration = schemaConfiguration;
    }

    @Override
    public Iterable<String> getTableNames(DatabaseMetaData metaData) {
        LinkedList linkedList;
        ResultSet rs = null;
        try {
            rs = this.databaseProvider.getTables(metaData.getConnection());
            LinkedList tableNames = Lists.newLinkedList();
            while (rs.next()) {
                String tableName = this.parseStringValue(rs, "TABLE_NAME");
                if (!this.schemaConfiguration.shouldManageTable(tableName, this.databaseProvider.isCaseSensitive())) continue;
                tableNames.add(tableName);
            }
            linkedList = tableNames;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        SqlUtils.closeQuietly(rs);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<? extends Field> getFields(DatabaseMetaData databaseMetaData, String tableName) {
        TypeManager manager = this.databaseProvider.getTypeManager();
        List<String> sequenceNames = this.getSequenceNames(databaseMetaData);
        Set<String> uniqueFields = this.getUniqueFields(databaseMetaData, tableName);
        HashMap fields = Maps.newHashMap();
        CloseableResultSetMetaData rsmd = null;
        try {
            String fieldName;
            rsmd = this.getResultSetMetaData(databaseMetaData, tableName);
            for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
                fieldName = rsmd.getColumnName(i);
                TypeQualifiers qualifiers = this.getTypeQualifiers(rsmd, i);
                int jdbcType = rsmd.getColumnType(i);
                TypeInfo<?> databaseType = manager.getTypeFromSchema(jdbcType, qualifiers);
                if (databaseType == null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("TABLE: " + tableName + ": ");
                    for (int j = 1; j <= rsmd.getColumnCount(); ++j) {
                        buf.append(rsmd.getColumnName(j)).append(" - ");
                    }
                    buf.append("can't find type " + jdbcType + " " + qualifiers + " in field " + fieldName);
                    throw new IllegalStateException(buf.toString());
                }
                boolean autoIncrement = this.isAutoIncrement(rsmd, i, sequenceNames, tableName, fieldName);
                boolean notNull = this.isNotNull(rsmd, i);
                boolean isUnique = this.isUnique(uniqueFields, fieldName);
                fields.put(fieldName, this.newField(fieldName, databaseType, jdbcType, autoIncrement, notNull, isUnique));
            }
            ResultSet rs = null;
            try {
                rs = databaseMetaData.getColumns(null, null, tableName, null);
                while (rs.next()) {
                    String columnName = this.parseStringValue(rs, "COLUMN_NAME");
                    FieldImpl current = (FieldImpl)fields.get(columnName);
                    if (current == null) {
                        throw new IllegalStateException("Could not find column '" + columnName + "' in previously parsed query!");
                    }
                    current.setDefaultValue(this.databaseProvider.parseValue(current.getJdbcType(), this.parseStringValue(rs, "COLUMN_DEF")));
                    current.setNotNull(current.isNotNull() || this.parseStringValue(rs, "IS_NULLABLE").equals("NO"));
                }
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(rs);
                throw throwable;
            }
            SqlUtils.closeQuietly(rs);
            try {
                rs = databaseMetaData.getPrimaryKeys(null, this.databaseProvider.getSchema(), tableName);
                while (rs.next()) {
                    fieldName = this.parseStringValue(rs, "COLUMN_NAME");
                    FieldImpl field = (FieldImpl)fields.get(fieldName);
                    field.setPrimaryKey(true);
                    field.setUnique(false);
                }
            }
            finally {
                SqlUtils.closeQuietly(rs);
            }
            Collection collection = fields.values();
            return collection;
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not read fields for table " + tableName, e);
        }
        finally {
            if (rsmd != null) {
                rsmd.close();
            }
        }
    }

    @Override
    public Iterable<? extends Index> getIndexes(DatabaseMetaData databaseMetaData, String tableName) {
        LinkedList linkedList;
        ResultSet resultSet = null;
        try {
            LinkedList indexes = Lists.newLinkedList();
            resultSet = this.databaseProvider.getIndexes(databaseMetaData.getConnection(), tableName);
            while (resultSet.next()) {
                boolean nonUnique = resultSet.getBoolean("NON_UNIQUE");
                if (!nonUnique) continue;
                indexes.add(this.newIndex(resultSet, tableName));
            }
            linkedList = indexes;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(resultSet);
                throw throwable;
            }
        }
        SqlUtils.closeQuietly(resultSet);
        return linkedList;
    }

    private Set<String> getUniqueFields(DatabaseMetaData metaData, String tableName) {
        HashSet hashSet;
        ResultSet rs = null;
        try {
            rs = this.databaseProvider.getIndexes(metaData.getConnection(), tableName);
            HashSet fields = Sets.newHashSet();
            while (rs.next()) {
                boolean nonUnique = rs.getBoolean("NON_UNIQUE");
                if (nonUnique) continue;
                fields.add(this.parseStringValue(rs, "COLUMN_NAME"));
            }
            hashSet = fields;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Could not get unique fields for table '" + tableName + "'", e);
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        SqlUtils.closeQuietly(rs);
        return hashSet;
    }

    private List<String> getSequenceNames(DatabaseMetaData metaData) {
        LinkedList linkedList;
        ResultSet rs = null;
        try {
            rs = this.databaseProvider.getSequences(metaData.getConnection());
            LinkedList sequenceNames = Lists.newLinkedList();
            while (rs.next()) {
                sequenceNames.add(this.databaseProvider.processID(this.parseStringValue(rs, "TABLE_NAME")));
            }
            linkedList = sequenceNames;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        SqlUtils.closeQuietly(rs);
        return linkedList;
    }

    private boolean isAutoIncrement(ResultSetMetaData rsmd, int i, List<String> sequenceNames, String tableName, String fieldName) throws SQLException {
        boolean autoIncrement = rsmd.isAutoIncrement(i);
        if (!autoIncrement) {
            autoIncrement = this.isUsingSequence(sequenceNames, tableName, fieldName);
        }
        return autoIncrement;
    }

    private boolean isUsingSequence(List<String> sequenceNames, String tableName, String fieldName) {
        return sequenceNames.contains(this.databaseProvider.processID(this.nameConverters.getSequenceNameConverter().getName(tableName, fieldName)));
    }

    private boolean isUnique(Set<String> uniqueFields, String fieldName) throws SQLException {
        return uniqueFields.contains(fieldName);
    }

    private FieldImpl newField(String fieldName, TypeInfo<?> databaseType, int jdbcType, boolean autoIncrement, boolean notNull, boolean isUnique) {
        return new FieldImpl(fieldName, databaseType, jdbcType, autoIncrement, notNull, isUnique);
    }

    private boolean isNotNull(ResultSetMetaData resultSetMetaData, int fieldIndex) throws SQLException {
        return resultSetMetaData.isNullable(fieldIndex) == 0;
    }

    private TypeQualifiers getTypeQualifiers(ResultSetMetaData rsmd, int fieldIndex) throws SQLException {
        TypeQualifiers ret = TypeQualifiers.qualifiers();
        if (rsmd.getColumnType(fieldIndex) == 12) {
            int length = rsmd.getColumnDisplaySize(fieldIndex);
            if (length > 0) {
                ret = ret.stringLength(length);
            }
        } else {
            int precision = rsmd.getPrecision(fieldIndex);
            int scale = rsmd.getScale(fieldIndex);
            if (precision > 0) {
                ret = ret.precision(precision);
            }
            if (scale > 0) {
                ret = ret.scale(scale);
            }
        }
        return ret;
    }

    private CloseableResultSetMetaData getResultSetMetaData(DatabaseMetaData metaData, String tableName) throws SQLException {
        Query query = Query.select("*").from(tableName).limit(1);
        final PreparedStatement stmt = metaData.getConnection().prepareStatement(this.databaseProvider.renderQuery(query, null, false));
        this.databaseProvider.setQueryStatementProperties(stmt, query);
        final ResultSet rs = stmt.executeQuery();
        return new AbstractCloseableResultSetMetaData(rs.getMetaData()){

            @Override
            public void close() {
                SqlUtils.closeQuietly(rs);
                SqlUtils.closeQuietly(stmt);
            }
        };
    }

    public Iterable<ForeignKey> getForeignKeys(DatabaseMetaData metaData, String tableName) {
        LinkedList linkedList;
        ResultSet resultSet = null;
        try {
            LinkedList keys = Lists.newLinkedList();
            resultSet = this.getImportedKeys(metaData, tableName);
            while (resultSet.next()) {
                keys.add(this.newForeignKey(resultSet, tableName));
            }
            linkedList = keys;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.closeQuietly(resultSet);
                throw throwable;
            }
        }
        SqlUtils.closeQuietly(resultSet);
        return linkedList;
    }

    private ResultSet getImportedKeys(DatabaseMetaData metaData, String tableName) throws SQLException {
        return this.databaseProvider.getImportedKeys(metaData.getConnection(), tableName);
    }

    private ForeignKey newForeignKey(ResultSet rs, String localTableName) throws SQLException {
        String localFieldName = this.parseStringValue(rs, "FKCOLUMN_NAME");
        String foreignFieldName = this.parseStringValue(rs, "PKCOLUMN_NAME");
        String foreignTableName = this.parseStringValue(rs, "PKTABLE_NAME");
        return new ForeignKeyImpl(localTableName, localFieldName, foreignTableName, foreignFieldName);
    }

    private Index newIndex(ResultSet rs, String tableName) throws SQLException {
        return new IndexImpl(tableName, this.parseStringValue(rs, "COLUMN_NAME"), this.parseStringValue(rs, "INDEX_NAME"));
    }

    private String parseStringValue(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        if (StringUtils.isBlank(value)) {
            return value;
        }
        Matcher m = STRING_VALUE.matcher(value);
        return m.find() ? m.group(1) : value;
    }

    private static final class IndexImpl
    implements Index {
        private final String tableName;
        private final String fieldName;
        private final String indexName;

        public IndexImpl(String tableName, String fieldName, String indexName) {
            this.tableName = tableName;
            this.fieldName = fieldName;
            this.indexName = indexName;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public String getIndexName() {
            return this.indexName;
        }
    }

    private static final class ForeignKeyImpl
    implements ForeignKey {
        private final String localTableName;
        private final String localFieldName;
        private final String foreignTableName;
        private final String foreignFieldName;

        public ForeignKeyImpl(String localTableName, String localFieldName, String foreignTableName, String foreignFieldName) {
            this.localTableName = localTableName;
            this.localFieldName = localFieldName;
            this.foreignTableName = foreignTableName;
            this.foreignFieldName = foreignFieldName;
        }

        @Override
        public String getLocalTableName() {
            return this.localTableName;
        }

        @Override
        public String getLocalFieldName() {
            return this.localFieldName;
        }

        @Override
        public String getForeignTableName() {
            return this.foreignTableName;
        }

        @Override
        public String getForeignFieldName() {
            return this.foreignFieldName;
        }
    }

    private static final class FieldImpl
    implements Field {
        private final String name;
        private final TypeInfo<?> databaseType;
        private final int jdbcType;
        private final boolean autoIncrement;
        private boolean notNull;
        private Object defaultValue;
        private boolean primaryKey;
        private boolean isUnique;

        public FieldImpl(String name, TypeInfo<?> databaseType, int jdbcType, boolean autoIncrement, boolean notNull, boolean isUnique) {
            this.name = name;
            this.databaseType = databaseType;
            this.jdbcType = jdbcType;
            this.autoIncrement = autoIncrement;
            this.notNull = notNull;
            this.isUnique = isUnique;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeInfo<?> getDatabaseType() {
            return this.databaseType;
        }

        @Override
        public int getJdbcType() {
            return this.jdbcType;
        }

        @Override
        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        @Override
        public boolean isNotNull() {
            return this.notNull;
        }

        public void setNotNull(boolean notNull) {
            this.notNull = notNull;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public void setPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
        }

        @Override
        public boolean isUnique() {
            return this.isUnique;
        }

        public void setUnique(boolean unique) {
            this.isUnique = unique;
        }
    }
}

