/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.java.ao.ActiveObjectsException;
import net.java.ao.Common;
import net.java.ao.DBParam;
import net.java.ao.DelegateConnection;
import net.java.ao.DelegateConnectionHandler;
import net.java.ao.DisposableDataSource;
import net.java.ao.EntityManager;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.IndexNameConverter;
import net.java.ao.schema.NameConverters;
import net.java.ao.schema.SequenceNameConverter;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.schema.TriggerNameConverter;
import net.java.ao.schema.UniqueNameConverter;
import net.java.ao.schema.ddl.DDLAction;
import net.java.ao.schema.ddl.DDLActionType;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLForeignKey;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.schema.ddl.DDLValue;
import net.java.ao.sql.SqlUtils;
import net.java.ao.types.TypeInfo;
import net.java.ao.types.TypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Logger sqlLogger = LoggerFactory.getLogger((String)"net.java.ao.sql");
    private final Set<SqlListener> sqlListeners;
    private final ThreadLocal<Connection> transactionThreadLocal = new ThreadLocal();
    private final DisposableDataSource dataSource;
    protected final TypeManager typeManager;
    private final String schema;
    private String quote;

    protected DatabaseProvider(DisposableDataSource dataSource, String schema, TypeManager typeManager) {
        this.dataSource = (DisposableDataSource)Preconditions.checkNotNull((Object)dataSource);
        this.typeManager = typeManager;
        this.schema = DatabaseProvider.isBlank(schema) ? null : schema;
        this.sqlListeners = new CopyOnWriteArraySet<SqlListener>();
        this.sqlListeners.add(new LoggingSqlListener(this.sqlLogger));
        this.loadQuoteString();
    }

    protected DatabaseProvider(DisposableDataSource dataSource, String schema) {
        this(dataSource, schema, new TypeManager.Builder().build());
    }

    public final TypeManager getTypeManager() {
        return this.typeManager;
    }

    public String getSchema() {
        return this.schema;
    }

    private synchronized void loadQuoteString() {
        if (this.quote != null) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (conn == null) {
                throw new IllegalStateException("Could not get connection to load quote String");
            }
            this.quote = conn.getMetaData().getIdentifierQuoteString().trim();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to query the database", e);
        }
        finally {
            Common.closeQuietly(conn);
        }
    }

    protected String renderAutoIncrement() {
        return "AUTO_INCREMENT";
    }

    public final String[] renderAction(NameConverters nameConverters, DDLAction action) {
        ArrayList<String> back = new ArrayList<String>();
        switch (action.getActionType()) {
            case CREATE: {
                back.add(this.renderTable(nameConverters, action.getTable()));
                back.addAll(this.renderFunctions(nameConverters.getTriggerNameConverter(), action.getTable()));
                back.addAll(this.renderSequences(nameConverters.getSequenceNameConverter(), action.getTable()));
                back.addAll(this.renderTriggers(nameConverters.getTriggerNameConverter(), nameConverters.getSequenceNameConverter(), action.getTable()));
                for (DDLIndex index : action.getTable().getIndexes()) {
                    DDLAction newAction = new DDLAction(DDLActionType.CREATE_INDEX);
                    newAction.setIndex(index);
                    back.addAll(Arrays.asList(this.renderAction(nameConverters, newAction)));
                }
                break;
            }
            case DROP: {
                for (DDLIndex index : action.getTable().getIndexes()) {
                    back.add(this.renderDropIndex(nameConverters.getIndexNameConverter(), index));
                }
                back.addAll(this.renderDropTriggers(nameConverters.getTriggerNameConverter(), action.getTable()));
                back.addAll(this.renderDropSequences(nameConverters.getSequenceNameConverter(), action.getTable()));
                back.addAll(Arrays.asList(this.renderDropFunctions(nameConverters.getTriggerNameConverter(), action.getTable())));
                back.add(this.renderDropTable(action.getTable()));
                break;
            }
            case ALTER_ADD_COLUMN: {
                back.addAll(this.renderAlterTableAddColumn(nameConverters, action.getTable(), action.getField()));
                for (DDLIndex index : action.getTable().getIndexes()) {
                    if (!index.getField().equals(action.getField().getName())) continue;
                    DDLAction newAction = new DDLAction(DDLActionType.CREATE_INDEX);
                    newAction.setIndex(index);
                    back.addAll(Arrays.asList(this.renderAction(nameConverters, newAction)));
                }
                break;
            }
            case ALTER_CHANGE_COLUMN: {
                back.addAll(this.renderAlterTableChangeColumn(nameConverters, action.getTable(), action.getOldField(), action.getField()));
                break;
            }
            case ALTER_DROP_COLUMN: {
                for (DDLIndex index : action.getTable().getIndexes()) {
                    if (!index.getField().equals(action.getField().getName())) continue;
                    DDLAction newAction = new DDLAction(DDLActionType.DROP_INDEX);
                    newAction.setIndex(index);
                    back.addAll(Arrays.asList(this.renderAction(nameConverters, newAction)));
                }
                back.addAll(Arrays.asList(this.renderAlterTableDropColumn(nameConverters.getTriggerNameConverter(), action.getTable(), action.getField())));
                break;
            }
            case ALTER_ADD_KEY: {
                back.add(this.renderAlterTableAddKey(action.getKey()));
                break;
            }
            case ALTER_DROP_KEY: {
                back.add(this.renderAlterTableDropKey(action.getKey()));
                break;
            }
            case CREATE_INDEX: {
                back.add(this.renderCreateIndex(nameConverters.getIndexNameConverter(), action.getIndex()));
                break;
            }
            case DROP_INDEX: {
                back.add(this.renderDropIndex(nameConverters.getIndexNameConverter(), action.getIndex()));
                break;
            }
            case INSERT: {
                back.add(this.renderInsert(action.getTable(), action.getValues()));
            }
        }
        return back.toArray(new String[back.size()]);
    }

    public String renderQuery(Query query, TableNameConverter converter, boolean count) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.renderQuerySelect(query, converter, count));
        sql.append(this.renderQueryJoins(query, converter));
        sql.append(this.renderQueryWhere(query));
        sql.append(this.renderQueryGroupBy(query));
        sql.append(this.renderQueryOrderBy(query));
        sql.append(this.renderQueryLimit(query));
        return sql.toString();
    }

    public Object parseValue(int type, String value) {
        if (value == null || value.equals("NULL")) {
            return null;
        }
        try {
            switch (type) {
                case -5: {
                    return Long.parseLong(value);
                }
                case -7: {
                    return Byte.parseByte(value);
                }
                case 16: {
                    int intValue = -1;
                    try {
                        intValue = Integer.parseInt(value);
                    }
                    catch (Throwable t) {
                        return Boolean.parseBoolean(value);
                    }
                    return intValue == 0;
                }
                case 1: {
                    value.charAt(0);
                    break;
                }
                case 91: {
                    try {
                        Calendar back = Calendar.getInstance();
                        back.setTime(new SimpleDateFormat(this.getDateFormat()).parse(value));
                        return back;
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case 3: {
                    return Double.parseDouble(value);
                }
                case 8: {
                    return Double.parseDouble(value);
                }
                case 6: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case 4: {
                    return Integer.parseInt(value);
                }
                case 2: {
                    return Integer.parseInt(value);
                }
                case 7: {
                    return Double.parseDouble(value);
                }
                case 5: {
                    return Short.parseShort(value);
                }
                case 93: {
                    try {
                        Calendar back = Calendar.getInstance();
                        back.setTime(new SimpleDateFormat(this.getDateFormat()).parse(value));
                        return back;
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case -6: {
                    return Short.parseShort(value);
                }
                case 12: {
                    return value;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void setQueryStatementProperties(Statement stmt, Query query) throws SQLException {
    }

    public void setQueryResultSetProperties(ResultSet res, Query query) throws SQLException {
    }

    public ResultSet getTables(Connection conn) throws SQLException {
        return conn.getMetaData().getTables(null, this.schema, "", new String[]{"TABLE"});
    }

    public ResultSet getSequences(Connection conn) throws SQLException {
        return conn.getMetaData().getTables(null, this.schema, "", new String[]{"SEQUENCE"});
    }

    public ResultSet getIndexes(Connection conn, String tableName) throws SQLException {
        return conn.getMetaData().getIndexInfo(null, this.schema, tableName, false, false);
    }

    public ResultSet getImportedKeys(Connection connection, String tableName) throws SQLException {
        return connection.getMetaData().getImportedKeys(null, this.schema, tableName);
    }

    protected String renderQuerySelect(Query query, TableNameConverter converter, boolean count) {
        StringBuilder sql = new StringBuilder();
        String tableName = query.getTable();
        if (tableName == null) {
            tableName = converter.getName(query.getTableType());
        }
        switch (query.getType()) {
            case SELECT: {
                sql.append("SELECT ");
                if (query.isDistinct()) {
                    sql.append("DISTINCT ");
                }
                if (count) {
                    sql.append("COUNT(*)");
                } else {
                    StringBuilder fields = new StringBuilder();
                    for (String field : query.getFields()) {
                        fields.append(this.processID(field)).append(',');
                    }
                    if (query.getFields().length > 0) {
                        fields.setLength(fields.length() - 1);
                    }
                    sql.append((CharSequence)fields);
                }
                sql.append(" FROM ");
                sql.append(this.withSchema(tableName));
            }
        }
        return sql.toString();
    }

    protected String renderQueryJoins(Query query, TableNameConverter converter) {
        StringBuilder sql = new StringBuilder();
        for (Map.Entry<Class<RawEntity<?>>, String> joinEntry : query.getJoins().entrySet()) {
            sql.append(" JOIN ").append(this.withSchema(converter.getName(joinEntry.getKey())));
            if (joinEntry.getValue() == null) continue;
            sql.append(" ON ").append(this.processOnClause(joinEntry.getValue()));
        }
        return sql.toString();
    }

    protected String renderQueryWhere(Query query) {
        StringBuilder sql = new StringBuilder();
        String whereClause = query.getWhereClause();
        if (whereClause != null) {
            sql.append(" WHERE ");
            sql.append(this.processWhereClause(whereClause));
        }
        return sql.toString();
    }

    protected String renderQueryGroupBy(Query query) {
        StringBuilder sql = new StringBuilder();
        String groupClause = query.getGroupClause();
        if (groupClause != null) {
            sql.append(" GROUP BY ");
            sql.append(this.processGroupByClause(groupClause));
        }
        return sql.toString();
    }

    private String processGroupByClause(String groupBy) {
        return SqlUtils.GROUP_BY_CLAUSE.matcher(groupBy).replaceAll(this.processID("$1"));
    }

    protected String renderQueryOrderBy(Query query) {
        StringBuilder sql = new StringBuilder();
        String orderClause = query.getOrderClause();
        if (orderClause != null) {
            sql.append(" ORDER BY ");
            sql.append(this.processOrderClause(orderClause));
        }
        return sql.toString();
    }

    private String processOrderClause(String order) {
        return SqlUtils.ORDER_CLAUSE.matcher(order).replaceFirst(this.processID("$1"));
    }

    protected String renderQueryLimit(Query query) {
        int offset;
        StringBuilder sql = new StringBuilder();
        int limit = query.getLimit();
        if (limit >= 0) {
            sql.append(" LIMIT ");
            sql.append(limit);
        }
        if ((offset = query.getOffset()) > 0) {
            sql.append(" OFFSET ").append(offset);
        }
        return sql.toString();
    }

    public final Connection getConnection() throws SQLException {
        Connection connectionImpl;
        Connection c = this.transactionThreadLocal.get();
        if (c != null) {
            if (!c.isClosed()) {
                return c;
            }
            this.transactionThreadLocal.remove();
        }
        if ((connectionImpl = this.dataSource.getConnection()) == null) {
            throw new SQLException("Unable to create connection");
        }
        c = DelegateConnectionHandler.newInstance(connectionImpl);
        this.setPostConnectionProperties(c);
        return c;
    }

    public final Connection startTransaction() throws SQLException {
        Connection c = this.getConnection();
        this.setCloseable(c, false);
        c.setTransactionIsolation(8);
        c.setAutoCommit(false);
        this.transactionThreadLocal.set(c);
        return c;
    }

    public final Connection commitTransaction(Connection c) throws SQLException {
        Preconditions.checkState((c == this.transactionThreadLocal.get() ? 1 : 0) != 0, (Object)"There are two concurrently open transactions!");
        Preconditions.checkState((c != null ? 1 : 0) != 0, (Object)"Tried to commit a transaction that is not started!");
        c.commit();
        this.transactionThreadLocal.remove();
        return c;
    }

    public final void rollbackTransaction(Connection c) throws SQLException {
        Preconditions.checkState((c == this.transactionThreadLocal.get() ? 1 : 0) != 0, (Object)"There are two concurrently open transactions!");
        Preconditions.checkState((c != null ? 1 : 0) != 0, (Object)"Tried to rollback a transaction that is not started!");
        c.rollback();
    }

    void setCloseable(Connection connection, boolean closeable) {
        if (connection != null && connection instanceof DelegateConnection) {
            ((DelegateConnection)connection).setCloseable(closeable);
        }
    }

    public void dispose() {
        this.dataSource.dispose();
    }

    protected void setPostConnectionProperties(Connection conn) throws SQLException {
    }

    protected String renderConstraintsForTable(UniqueNameConverter uniqueNameConverter, DDLTable table) {
        StringBuilder back = new StringBuilder();
        for (DDLForeignKey key : table.getForeignKeys()) {
            back.append("    ").append(this.renderForeignKey(key)).append(",\n");
        }
        return back.toString();
    }

    protected String renderForeignKey(DDLForeignKey key) {
        StringBuilder back = new StringBuilder();
        back.append("CONSTRAINT ").append(this.processID(key.getFKName()));
        back.append(" FOREIGN KEY (").append(this.processID(key.getField())).append(") REFERENCES ");
        back.append(this.withSchema(key.getTable())).append('(').append(this.processID(key.getForeignField())).append(")");
        return back.toString();
    }

    protected String convertTypeToString(TypeInfo<?> type) {
        return type.getSqlTypeIdentifier();
    }

    protected String renderTable(NameConverters nameConverters, DDLTable table) {
        StringBuilder back = new StringBuilder("CREATE TABLE ");
        back.append(this.withSchema(table.getName()));
        back.append(" (\n");
        LinkedList<String> primaryKeys = new LinkedList<String>();
        StringBuilder append = new StringBuilder();
        for (DDLField field : table.getFields()) {
            back.append("    ").append(this.renderField(nameConverters, table, field, new RenderFieldOptions(true, true))).append(",\n");
            if (!field.isPrimaryKey()) continue;
            primaryKeys.add(field.getName());
        }
        append.append(this.renderConstraintsForTable(nameConverters.getUniqueNameConverter(), table));
        back.append((CharSequence)append);
        if (primaryKeys.size() > 1) {
            throw new RuntimeException("Entities may only have one primary key");
        }
        if (primaryKeys.size() > 0) {
            back.append("    PRIMARY KEY(");
            back.append(this.processID((String)primaryKeys.get(0)));
            back.append(")\n");
        }
        back.append(")");
        String tailAppend = this.renderAppend();
        if (tailAppend != null) {
            back.append(' ');
            back.append(tailAppend);
        }
        return back.toString();
    }

    protected String renderInsert(DDLTable ddlTable, DDLValue[] ddlValues) {
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (DDLValue v : ddlValues) {
            columns.append(this.processID(v.getField().getName())).append(",");
            values.append(this.renderValue(v.getValue())).append(",");
        }
        columns.deleteCharAt(columns.length() - 1);
        values.deleteCharAt(values.length() - 1);
        return "INSERT INTO " + this.withSchema(ddlTable.getName()) + "(" + columns + ")" + " VALUES (" + values + ")";
    }

    protected String renderDropTable(DDLTable table) {
        return "DROP TABLE " + this.withSchema(table.getName());
    }

    protected String[] renderDropFunctions(TriggerNameConverter triggerNameConverter, DDLTable table) {
        return new String[0];
    }

    protected List<String> renderDropTriggers(TriggerNameConverter triggerNameConverter, DDLTable table) {
        return ImmutableList.of();
    }

    protected List<String> renderDropSequences(SequenceNameConverter sequenceNameConverter, DDLTable table) {
        return ImmutableList.of();
    }

    protected List<String> renderFunctions(final TriggerNameConverter triggerNameConverter, final DDLTable table) {
        return this.renderFields(table, (Predicate<DDLField>)Predicates.alwaysTrue(), new Function<DDLField, String>(){

            public String apply(DDLField field) {
                return DatabaseProvider.this.renderFunctionForField(triggerNameConverter, table, field);
            }
        });
    }

    protected final List<String> renderFields(DDLTable table, Predicate<DDLField> filter, Function<DDLField, String> render) {
        ArrayList fields = Lists.newArrayList((Object[])table.getFields());
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)fields, filter), render), (Predicate)Predicates.notNull()));
    }

    protected List<String> renderTriggers(final TriggerNameConverter triggerNameConverter, final SequenceNameConverter sequenceNameConverter, final DDLTable table) {
        return this.renderFields(table, (Predicate<DDLField>)Predicates.alwaysTrue(), new Function<DDLField, String>(){

            public String apply(DDLField field) {
                return DatabaseProvider.this.renderTriggerForField(triggerNameConverter, sequenceNameConverter, table, field);
            }
        });
    }

    protected List<String> renderSequences(SequenceNameConverter sequenceNameConverter, DDLTable table) {
        return ImmutableList.of();
    }

    protected List<String> renderAlterTableAddColumn(NameConverters nameConverters, DDLTable table, DDLField field) {
        String trigger;
        ArrayList<String> back = new ArrayList<String>();
        back.add("ALTER TABLE " + this.withSchema(table.getName()) + " ADD COLUMN " + this.renderField(nameConverters, table, field, new RenderFieldOptions(true, true)));
        for (DDLForeignKey foreignKey : this.findForeignKeysForField(table, field)) {
            back.add(this.renderAlterTableAddKey(foreignKey));
        }
        String function = this.renderFunctionForField(nameConverters.getTriggerNameConverter(), table, field);
        if (function != null) {
            back.add(function);
        }
        if ((trigger = this.renderTriggerForField(nameConverters.getTriggerNameConverter(), nameConverters.getSequenceNameConverter(), table, field)) != null) {
            back.add(trigger);
        }
        return back;
    }

    protected List<String> renderAlterTableChangeColumn(NameConverters nameConverters, DDLTable table, DDLField oldField, DDLField field) {
        String toRenderTrigger;
        String function;
        ArrayList<String> back = new ArrayList<String>();
        String trigger = this.getTriggerNameForField(nameConverters.getTriggerNameConverter(), table, oldField);
        if (trigger != null) {
            back.add("DROP TRIGGER " + this.processID(trigger));
        }
        if ((function = this.getFunctionNameForField(nameConverters.getTriggerNameConverter(), table, oldField)) != null) {
            back.add("DROP FUNCTION " + this.processID(function));
        }
        back.add(this.renderAlterTableChangeColumnStatement(nameConverters, table, oldField, field, this.renderFieldOptionsInAlterColumn()));
        String toRenderFunction = this.renderFunctionForField(nameConverters.getTriggerNameConverter(), table, field);
        if (toRenderFunction != null) {
            back.add(toRenderFunction);
        }
        if ((toRenderTrigger = this.renderTriggerForField(nameConverters.getTriggerNameConverter(), nameConverters.getSequenceNameConverter(), table, field)) != null) {
            back.add(toRenderTrigger);
        }
        return back;
    }

    protected RenderFieldOptions renderFieldOptionsInAlterColumn() {
        return new RenderFieldOptions(true, true, true);
    }

    protected String renderAlterTableChangeColumnStatement(NameConverters nameConverters, DDLTable table, DDLField oldField, DDLField field, RenderFieldOptions options) {
        StringBuilder current = new StringBuilder();
        current.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" CHANGE COLUMN ");
        current.append(this.processID(oldField.getName())).append(' ');
        current.append(this.renderField(nameConverters, table, field, options));
        return current.toString();
    }

    protected String[] renderAlterTableDropColumn(TriggerNameConverter triggerNameConverter, DDLTable table, DDLField field) {
        String function;
        ArrayList<String> back = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (DDLForeignKey foreignKey : this.findForeignKeysForField(table, field)) {
            back.add(this.renderAlterTableDropKey(foreignKey));
        }
        String trigger = this.getTriggerNameForField(triggerNameConverter, table, field);
        if (trigger != null) {
            current.setLength(0);
            current.append("DROP TRIGGER ").append(this.processID(trigger));
            back.add(current.toString());
        }
        if ((function = this.getFunctionNameForField(triggerNameConverter, table, field)) != null) {
            current.setLength(0);
            current.append("DROP FUNCTION ").append(this.processID(function));
            back.add(current.toString());
        }
        current.setLength(0);
        current.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" DROP COLUMN ").append(this.processID(field.getName()));
        back.add(current.toString());
        return back.toArray(new String[back.size()]);
    }

    protected String renderAlterTableAddKey(DDLForeignKey key) {
        StringBuilder back = new StringBuilder();
        back.append("ALTER TABLE ").append(this.withSchema(key.getDomesticTable())).append(" ADD ");
        back.append(this.renderForeignKey(key));
        return back.toString();
    }

    protected String renderAlterTableDropKey(DDLForeignKey key) {
        return "ALTER TABLE " + this.withSchema(key.getDomesticTable()) + " DROP FOREIGN KEY " + this.processID(key.getFKName());
    }

    protected String renderCreateIndex(IndexNameConverter indexNameConverter, DDLIndex index) {
        StringBuilder back = new StringBuilder();
        back.append("CREATE INDEX ").append(this.withSchema(indexNameConverter.getName(this.shorten(index.getTable()), this.shorten(index.getField()))));
        back.append(" ON ").append(this.withSchema(index.getTable())).append('(').append(this.processID(index.getField())).append(')');
        return back.toString();
    }

    protected String renderDropIndex(IndexNameConverter indexNameConverter, DDLIndex index) {
        String indexName = indexNameConverter.getName(this.shorten(index.getTable()), this.shorten(index.getField()));
        if (this.hasIndex(indexNameConverter, index)) {
            return "DROP INDEX " + this.withSchema(indexName) + " ON " + this.withSchema(index.getTable());
        }
        return "";
    }

    protected boolean hasIndex(IndexNameConverter indexNameConverter, DDLIndex index) {
        String indexName = indexNameConverter.getName(this.shorten(index.getTable()), this.shorten(index.getField()));
        Connection connection = null;
        try {
            connection = this.getConnection();
            ResultSet indexes = this.getIndexes(connection, index.getTable());
            while (indexes.next()) {
                if (!indexName.equalsIgnoreCase(indexes.getString("INDEX_NAME"))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new ActiveObjectsException(e);
        }
        finally {
            Common.closeQuietly(connection);
        }
    }

    protected String renderAppend() {
        return null;
    }

    protected String renderField(NameConverters nameConverters, DDLTable table, DDLField field, RenderFieldOptions options) {
        String renderUniqueString;
        StringBuilder back = new StringBuilder();
        back.append(this.processID(field.getName()));
        back.append(" ");
        back.append(this.renderFieldType(field));
        if (field.isAutoIncrement()) {
            String autoIncrementValue = this.renderAutoIncrement();
            if (!autoIncrementValue.trim().equals("")) {
                back.append(' ').append(autoIncrementValue);
            }
        } else if (options.forceNull && !field.isNotNull() && !field.isUnique() && !field.isPrimaryKey() || options.renderDefault && field.getDefaultValue() != null) {
            back.append(this.renderFieldDefault(table, field));
        }
        if (options.renderUnique && field.isUnique() && !(renderUniqueString = this.renderUnique(nameConverters.getUniqueNameConverter(), table, field)).trim().equals("")) {
            back.append(' ').append(renderUniqueString);
        }
        if (field.isNotNull() || field.isUnique()) {
            back.append(" NOT NULL");
        }
        return back.toString();
    }

    protected String renderFieldDefault(DDLTable table, DDLField field) {
        return " DEFAULT " + this.renderValue(field.getDefaultValue());
    }

    protected String renderValue(Object value) {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof Date) {
            return "'" + this.renderDate((Date)value) + "'";
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : "0";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return "'" + value.toString() + "'";
    }

    protected String renderDate(Date date) {
        return new SimpleDateFormat(this.getDateFormat()).format(date);
    }

    protected String renderUnique(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        return "UNIQUE";
    }

    protected String getDateFormat() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    protected String renderFieldType(DDLField field) {
        return this.convertTypeToString(field.getType());
    }

    public Object handleBlob(ResultSet res, Class<?> type, String field) throws SQLException {
        Blob blob = res.getBlob(field);
        if (type.equals(InputStream.class)) {
            return blob.getBinaryStream();
        }
        if (type.equals(byte[].class)) {
            return blob.getBytes(1L, (int)blob.length());
        }
        return null;
    }

    protected String getTriggerNameForField(TriggerNameConverter triggerNameConverter, DDLTable table, DDLField field) {
        return null;
    }

    protected String renderTriggerForField(TriggerNameConverter triggerNameConverter, SequenceNameConverter sequenceNameConverter, DDLTable table, DDLField field) {
        return null;
    }

    protected String getFunctionNameForField(TriggerNameConverter triggerNameConverter, DDLTable table, DDLField field) {
        String triggerName = this.getTriggerNameForField(triggerNameConverter, table, field);
        return triggerName != null ? triggerName + "()" : null;
    }

    protected String renderFunctionForField(TriggerNameConverter triggerNameConverter, DDLTable table, DDLField field) {
        return null;
    }

    public <T extends RawEntity<K>, K> K insertReturningKey(EntityManager manager, Connection conn, Class<T> entityType, Class<K> pkType, String pkField, boolean pkIdentity, String table, DBParam ... params) throws SQLException {
        StringBuilder sql = new StringBuilder("INSERT INTO " + this.withSchema(table) + " (");
        for (DBParam param : params) {
            sql.append(this.processID(param.getField()));
            sql.append(',');
        }
        if (params.length > 0) {
            sql.setLength(sql.length() - 1);
        } else {
            sql.append(this.processID(pkField));
        }
        sql.append(") VALUES (");
        for (DBParam param : params) {
            sql.append("?,");
        }
        if (params.length > 0) {
            sql.setLength(sql.length() - 1);
        } else {
            sql.append("DEFAULT");
        }
        sql.append(")");
        return this.executeInsertReturningKey(manager, conn, entityType, pkType, pkField, sql.toString(), params);
    }

    protected <T extends RawEntity<K>, K> K executeInsertReturningKey(EntityManager manager, Connection conn, Class<T> entityType, Class<K> pkType, String pkField, String sql, DBParam ... params) throws SQLException {
        Object back = null;
        PreparedStatement stmt = this.preparedStatement(conn, sql, 1);
        for (int i = 0; i < params.length; ++i) {
            Object value = params[i].getValue();
            if (value instanceof RawEntity) {
                value = Common.getPrimaryKeyValue((RawEntity)value);
            }
            if (params[i].getField().equalsIgnoreCase(pkField)) {
                back = value;
            }
            if (value == null) {
                this.putNull(stmt, i + 1);
                continue;
            }
            TypeInfo<?> type = this.typeManager.getType(value.getClass());
            type.getLogicalType().putToDatabase(manager, stmt, i + 1, value, type.getJdbcWriteType());
        }
        stmt.executeUpdate();
        if (back == null) {
            ResultSet res = stmt.getGeneratedKeys();
            if (res.next()) {
                back = this.typeManager.getType(pkType).getLogicalType().pullFromDatabase(null, res, pkType, 1);
            }
            res.close();
        }
        stmt.close();
        return (K)back;
    }

    public void putNull(PreparedStatement stmt, int index) throws SQLException {
        stmt.setNull(index, stmt.getParameterMetaData().getParameterType(index));
    }

    public void putBoolean(PreparedStatement stmt, int index, boolean value) throws SQLException {
        stmt.setBoolean(index, value);
    }

    protected boolean isNumericType(int type) {
        switch (type) {
            case -5: {
                return true;
            }
            case -7: {
                return true;
            }
            case 3: {
                return true;
            }
            case 8: {
                return true;
            }
            case 6: {
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
            case 7: {
                return true;
            }
            case 5: {
                return true;
            }
            case -6: {
                return true;
            }
        }
        return false;
    }

    protected String processOnClause(String on) {
        return SqlUtils.ON_CLAUSE.matcher(on).replaceAll("$1" + this.processID("$2") + " = " + "$3" + this.processID("$4"));
    }

    public final String processWhereClause(String where) {
        return SqlUtils.processWhereClause(where, new Function<String, String>(){

            public String apply(String id) {
                return DatabaseProvider.this.processID(id);
            }
        });
    }

    public final String processID(String id) {
        return this.quote(this.shorten(id));
    }

    public final String withSchema(String tableName) {
        String processedTableName = this.processID(tableName);
        return this.isSchemaNotEmpty() ? this.schema + "." + processedTableName : processedTableName;
    }

    protected final boolean isSchemaNotEmpty() {
        return this.schema != null && this.schema.length() > 0;
    }

    public final String shorten(String id) {
        return Common.shorten(id, this.getMaxIDLength());
    }

    public final String quote(String id) {
        if (this.shouldQuoteID(id)) {
            this.loadQuoteString();
            return this.quote + id + this.quote;
        }
        return id;
    }

    protected boolean shouldQuoteID(String id) {
        return this.getReservedWords().contains(id.toUpperCase());
    }

    protected int getMaxIDLength() {
        return Integer.MAX_VALUE;
    }

    protected abstract Set<String> getReservedWords();

    public boolean isCaseSensetive() {
        return true;
    }

    public void handleUpdateError(String sql, SQLException e) throws SQLException {
        this.sqlLogger.error("Exception executing SQL update <" + sql + ">", (Throwable)e);
        throw e;
    }

    public final PreparedStatement preparedStatement(Connection c, CharSequence sql) throws SQLException {
        String sqlString = ((Object)sql).toString();
        this.onSql(sqlString);
        return c.prepareStatement(sqlString);
    }

    public final PreparedStatement preparedStatement(Connection c, CharSequence sql, int autoGeneratedKeys) throws SQLException {
        String sqlString = ((Object)sql).toString();
        this.onSql(sqlString);
        return c.prepareStatement(sqlString, autoGeneratedKeys);
    }

    public final PreparedStatement preparedStatement(Connection c, CharSequence sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String sqlString = ((Object)sql).toString();
        this.onSql(sqlString);
        return c.prepareStatement(sqlString, resultSetType, resultSetConcurrency);
    }

    public final void executeUpdate(Statement stmt, CharSequence sql) throws SQLException {
        String sqlString = ((Object)sql).toString();
        try {
            this.onSql(sqlString);
            ((Statement)Preconditions.checkNotNull((Object)stmt)).executeUpdate(sqlString);
        }
        catch (SQLException e) {
            this.handleUpdateError(sqlString, e);
        }
    }

    public final void addSqlListener(SqlListener l) {
        this.sqlListeners.add(l);
    }

    public final void removeSqlListener(SqlListener l) {
        this.sqlListeners.remove(l);
    }

    protected final void onSql(String sql) {
        for (SqlListener sqlListener : this.sqlListeners) {
            sqlListener.onSql(sql);
        }
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected Iterable<DDLForeignKey> findForeignKeysForField(DDLTable table, final DDLField field) {
        return Iterables.filter((Iterable)Lists.newArrayList((Object[])table.getForeignKeys()), (Predicate)new Predicate<DDLForeignKey>(){

            public boolean apply(DDLForeignKey fk) {
                return fk.getField().equals(field.getName());
            }
        });
    }

    private static final class LoggingSqlListener
    implements SqlListener {
        private final Logger logger;

        public LoggingSqlListener(Logger logger) {
            this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
        }

        @Override
        public void onSql(String sql) {
            this.logger.debug(sql);
        }
    }

    public static interface SqlListener {
        public void onSql(String var1);
    }

    protected static class RenderFieldOptions {
        public final boolean renderUnique;
        public final boolean renderDefault;
        public final boolean forceNull;

        public RenderFieldOptions(boolean renderUnique, boolean renderDefault) {
            this(renderUnique, renderDefault, false);
        }

        public RenderFieldOptions(boolean renderUnique, boolean renderDefault, boolean forceNull) {
            this.renderUnique = renderUnique;
            this.renderDefault = renderDefault;
            this.forceNull = forceNull;
        }
    }
}

