/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.ao.Common;
import net.java.ao.DBParam;
import net.java.ao.DatabaseProvider;
import net.java.ao.DisposableDataSource;
import net.java.ao.EntityManager;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.IndexNameConverter;
import net.java.ao.schema.NameConverters;
import net.java.ao.schema.SequenceNameConverter;
import net.java.ao.schema.TriggerNameConverter;
import net.java.ao.schema.UniqueNameConverter;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLForeignKey;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.sql.SqlUtils;
import net.java.ao.types.TypeInfo;
import net.java.ao.types.TypeManager;

public final class OracleDatabaseProvider
extends DatabaseProvider {
    private static final int ORA_04080_TRIGGER_DOES_NOT_EXIST = 4080;
    private static final int ORA_02289_SEQUENCE_DOES_NOT_EXIST = 2289;
    public static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object[])new String[]{"ACCESS", "ACCOUNT", "ACTIVATE", "ADD", "ADMIN", "ADVISE", "AFTER", "ALL", "ALL_ROWS", "ALLOCATE", "ALTER", "ANALYZE", "AND", "ANY", "ARCHIVE", "ARCHIVELOG", "ARRAY", "AS", "ASC", "AT", "AUDIT", "AUTHENTICATED", "AUTHORIZATION", "AUTOEXTEND", "AUTOMATIC", "BACKUP", "BECOME", "BEFORE", "BEGIN", "BETWEEN", "BFILE", "BITMAP", "BLOB", "BLOCK", "BODY", "BY", "CACHE", "CACHE_INSTANCES", "CANCEL", "CASCADE", "CAST", "CFILE", "CHAINED", "CHANGE", "CHAR", "CHAR_CS", "CHARACTER", "CHECK", "CHECKPOINT", "CHOOSE", "CHUNK", "CLEAR", "CLOB", "CLONE", "CLOSE", "CLOSE_CACHED_OPEN_CURSORS", "CLUSTER", "COALESCE", "COLUMN", "COLUMNS", "COMMENT", "COMMIT", "COMMITTED", "COMPATIBILITY", "COMPILE", "COMPLETE", "COMPOSITE_LIMIT", "COMPRESS", "COMPUTE", "CONNECT", "CONNECT_TIME", "CONSTRAINT", "CONSTRAINTS", "CONTENTS", "CONTINUE", "CONTROLFILE", "CONVERT", "COST", "CPU_PER_CALL", "CPU_PER_SESSION", "CREATE", "CURRENT", "CURRENT_SCHEMA", "CURREN_USER", "CURSOR", "CYCLE", "DANGLING", "DATABASE", "DATAFILE", "DATAFILES", "DATAOBJNO", "DATE", "DBA", "DBHIGH", "DBLOW", "DBMAC", "DEALLOCATE", "DEBUG", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DEGREE", "DELETE", "DEREF", "DESC", "DIRECTORY", "DISABLE", "DISCONNECT", "DISMOUNT", "DISTINCT", "DISTRIBUTED", "DML", "DOUBLE", "DROP", "DUMP", "EACH", "ELSE", "ENABLE", "END", "ENFORCE", "ENTRY", "ESCAPE", "EXCEPT", "EXCEPTIONS", "EXCHANGE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS", "EXPIRE", "EXPLAIN", "EXTENT", "EXTENTS", "EXTERNALLY", "FAILED_LOGIN_ATTEMPTS", "FALSE", "FAST", "FILE", "FIRST_ROWS", "FLAGGER", "FLOAT", "FLOB", "FLUSH", "FOR", "FORCE", "FOREIGN", "FREELIST", "FREELISTS", "FROM", "FULL", "FUNCTION", "GLOBAL", "GLOBALLY", "GLOBAL_NAME", "GRANT", "GROUP", "GROUPS", "HASH", "HASHKEYS", "HAVING", "HEADER", "HEAP", "IDENTIFIED", "IDGENERATORS", "IDLE_TIME", "IF", "IMMEDIATE", "IN", "INCLUDING", "INCREMENT", "INDEX", "INDEXED", "INDEXES", "INDICATOR", "IND_PARTITION", "INITIAL", "INITIALLY", "INITRANS", "INSERT", "INSTANCE", "INSTANCES", "INSTEAD", "INT", "INTEGER", "INTERMEDIATE", "INTERSECT", "INTO", "IS", "ISOLATION", "ISOLATION_LEVEL", "KEEP", "KEY", "KILL", "LABEL", "LAYER", "LESS", "LEVEL", "LIBRARY", "LIKE", "LIMIT", "LINK", "LIST", "LOB", "LOCAL", "LOCK", "LOCKED", "LOG", "LOGFILE", "LOGGING", "LOGICAL_READS_PER_CALL", "LOGICAL_READS_PER_SESSION", "LONG", "MANAGE", "MASTER", "MAX", "MAXARCHLOGS", "MAXDATAFILES", "MAXEXTENTS", "MAXINSTANCES", "MAXLOGFILES", "MAXLOGHISTORY", "MAXLOGMEMBERS", "MAXSIZE", "MAXTRANS", "MAXVALUE", "MIN", "MEMBER", "MINIMUM", "MINEXTENTS", "MINUS", "MINVALUE", "MLSLABEL", "MLS_LABEL_FORMAT", "MODE", "MODIFY", "MOUNT", "MOVE", "MTS_DISPATCHERS", "MULTISET", "NATIONAL", "NCHAR", "NCHAR_CS", "NCLOB", "NEEDED", "NESTED", "NETWORK", "NEW", "NEXT", "NOARCHIVELOG", "NOAUDIT", "NOCACHE", "NOCOMPRESS", "NOCYCLE", "NOFORCE", "NOLOGGING", "NOMAXVALUE", "NOMINVALUE", "NONE", "NOORDER", "NOOVERRIDE", "NOPARALLEL", "NOPARALLEL", "NOREVERSE", "NORMAL", "NOSORT", "NOT", "NOTHING", "NOWAIT", "NULL", "NUMBER", "NUMERIC", "NVARCHAR2", "OBJECT", "OBJNO", "OBJNO_REUSE", "OF", "OFF", "OFFLINE", "OID", "OIDINDEX", "OLD", "ON", "ONLINE", "ONLY", "OPCODE", "OPEN", "OPTIMAL", "OPTIMIZER_GOAL", "OPTION", "OR", "ORDER", "ORGANIZATION", "OSLABEL", "OVERFLOW", "OWN", "PACKAGE", "PARALLEL", "PARTITION", "PASSWORD", "PASSWORD_GRACE_TIME", "PASSWORD_LIFE_TIME", "PASSWORD_LOCK_TIME", "PASSWORD_REUSE_MAX", "PASSWORD_REUSE_TIME", "PASSWORD_VERIFY_FUNCTION", "PCTFREE", "PCTINCREASE", "PCTTHRESHOLD", "PCTUSED", "PCTVERSION", "PERCENT", "PERMANENT", "PLAN", "PLSQL_DEBUG", "POST_TRANSACTION", "PRECISION", "PRESERVE", "PRIMARY", "PRIOR", "PRIVATE", "PRIVATE_SGA", "PRIVILEGE", "PRIVILEGES", "PROCEDURE", "PROFILE", "PUBLIC", "PURGE", "QUEUE", "QUOTA", "RANGE", "RAW", "RBA", "READ", "READUP", "REAL", "REBUILD", "RECOVER", "RECOVERABLE", "RECOVERY", "REF", "REFERENCES", "REFERENCING", "REFRESH", "RENAME", "REPLACE", "RESET", "RESETLOGS", "RESIZE", "RESOURCE", "RESTRICTED", "RETURN", "RETURNING", "REUSE", "REVERSE", "REVOKE", "ROLE", "ROLES", "ROLLBACK", "ROW", "ROWID", "ROWNUM", "ROWS", "RULE", "SAMPLE", "SAVEPOINT", "SB4", "SCAN_INSTANCES", "SCHEMA", "SCN", "SCOPE", "SD_ALL", "SD_INHIBIT", "SD_SHOW", "SEGMENT", "SEG_BLOCK", "SEG_FILE", "SELECT", "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_CACHED_CURSORS", "SESSIONS_PER_USER", "SET", "SHARE", "SHARED", "SHARED_POOL", "SHRINK", "SIZE", "SKIP", "SKIP_UNUSABLE_INDEXES", "SMALLINT", "SNAPSHOT", "SOME", "SORT", "SPECIFICATION", "SPLIT", "SQL_TRACE", "STANDBY", "START", "STATEMENT_ID", "STATISTICS", "STOP", "STORAGE", "STORE", "STRUCTURE", "SUCCESSFUL", "SWITCH", "SYS_OP_ENFORCE_NOT_NULL$", "SYS_OP_NTCIMG$", "SYNONYM", "SYSDATE", "SYSDBA", "SYSOPER", "SYSTEM", "TABLE", "TABLES", "TABLESPACE", "TABLESPACE_NO", "TABNO", "TEMPORARY", "THAN", "THE", "THEN", "THREAD", "TIMESTAMP", "TIME", "TO", "TOPLEVEL", "TRACE", "TRACING", "TRANSACTION", "TRANSITIONAL", "TRIGGER", "TRIGGERS", "TRUE", "TRUNCATE", "TX", "TYPE", "UB2", "UBA", "UID", "UNARCHIVED", "UNDO", "UNION", "UNIQUE", "UNLIMITED", "UNLOCK", "UNRECOVERABLE", "UNTIL", "UNUSABLE", "UNUSED", "UPDATABLE", "UPDATE", "USAGE", "USE", "USER", "USING", "VALIDATE", "VALIDATION", "VALUE", "VALUES", "VARCHAR", "VARCHAR2", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "WRITEDOWN", "WRITEUP", "XID", "YEAR", "ZONE"});

    public OracleDatabaseProvider(DisposableDataSource dataSource) {
        this(dataSource, null);
    }

    public OracleDatabaseProvider(DisposableDataSource dataSource, String schema) {
        super(dataSource, schema, TypeManager.oracle());
    }

    @Override
    public String getSchema() {
        return this.isSchemaNotEmpty() ? super.getSchema().toUpperCase() : null;
    }

    @Override
    public void setQueryStatementProperties(Statement stmt, Query query) throws SQLException {
        int limit = query.getLimit();
        if (limit >= 0) {
            stmt.setFetchSize(query.getOffset() + limit);
            stmt.setMaxRows(query.getOffset() + limit);
        }
    }

    @Override
    public void setQueryResultSetProperties(ResultSet res, Query query) throws SQLException {
        if (query.getOffset() > 0) {
            res.absolute(query.getOffset());
        }
    }

    @Override
    public ResultSet getTables(Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        String schemaPattern = this.isSchemaNotEmpty() ? this.getSchema() : metaData.getUserName();
        return metaData.getTables(null, schemaPattern, "%", new String[]{"TABLE"});
    }

    @Override
    public ResultSet getSequences(Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        String schemaPattern = this.isSchemaNotEmpty() ? this.getSchema() : metaData.getUserName();
        return metaData.getTables(null, schemaPattern, "%", new String[]{"SEQUENCE"});
    }

    @Override
    public ResultSet getIndexes(Connection conn, String tableName) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        String schemaPattern = this.isSchemaNotEmpty() ? this.getSchema() : metaData.getUserName();
        return conn.getMetaData().getIndexInfo(null, schemaPattern, tableName, false, true);
    }

    @Override
    public ResultSet getImportedKeys(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String schemaPattern = this.isSchemaNotEmpty() ? this.getSchema() : metaData.getUserName();
        return metaData.getImportedKeys(null, schemaPattern, tableName);
    }

    @Override
    protected String renderQueryLimit(Query query) {
        return "";
    }

    @Override
    protected String renderAutoIncrement() {
        return "";
    }

    @Override
    public Object parseValue(int type, String value) {
        if (value == null || value.equals("") || value.equals("NULL")) {
            return null;
        }
        switch (type) {
            case 12: {
                Matcher matcher = Pattern.compile("'(.*)'.*").matcher(value);
                if (!matcher.find()) break;
                value = matcher.group(1);
            }
        }
        return super.parseValue(type, value);
    }

    @Override
    protected String renderUnique(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        return "CONSTRAINT " + uniqueNameConverter.getName(table.getName(), field.getName()) + " UNIQUE";
    }

    @Override
    protected String getDateFormat() {
        return "dd-MMM-yy hh:mm:ss.SSS a";
    }

    @Override
    protected String renderTriggerForField(TriggerNameConverter triggerNameConverter, SequenceNameConverter sequenceNameConverter, DDLTable table, DDLField field) {
        if (field.isAutoIncrement()) {
            StringBuilder back = new StringBuilder();
            back.append("CREATE TRIGGER ").append(this.withSchema(triggerNameConverter.autoIncrementName(table.getName(), field.getName())) + '\n');
            back.append("BEFORE INSERT\n").append("    ON ").append(this.withSchema(table.getName())).append("   FOR EACH ROW\n");
            back.append("BEGIN\n");
            back.append("    SELECT ").append(this.withSchema(sequenceNameConverter.getName(this.shorten(table.getName()), this.shorten(field.getName()))) + ".NEXTVAL");
            back.append(" INTO :NEW.").append(this.processID(field.getName())).append(" FROM DUAL;\nEND;");
            return back.toString();
        }
        return super.renderTriggerForField(triggerNameConverter, sequenceNameConverter, table, field);
    }

    @Override
    protected List<String> renderAlterTableAddColumn(NameConverters nameConverters, DDLTable table, DDLField field) {
        String trigger;
        ArrayList<String> back = new ArrayList<String>();
        back.add("ALTER TABLE " + this.withSchema(table.getName()) + " ADD (" + this.renderField(nameConverters, table, field, new DatabaseProvider.RenderFieldOptions(true, true)) + ")");
        for (DDLForeignKey foreignKey : this.findForeignKeysForField(table, field)) {
            back.add(this.renderAlterTableAddKey(foreignKey));
        }
        String function = this.renderFunctionForField(nameConverters.getTriggerNameConverter(), table, field);
        if (function != null) {
            back.add(function);
        }
        if ((trigger = this.renderTriggerForField(nameConverters.getTriggerNameConverter(), nameConverters.getSequenceNameConverter(), table, field)) != null) {
            back.add(trigger);
        }
        return back;
    }

    @Override
    protected List<String> renderAlterTableChangeColumn(NameConverters nameConverters, DDLTable table, DDLField oldField, DDLField field) {
        String toRenderTrigger;
        String toRenderFunction;
        String function;
        UniqueNameConverter uniqueNameConverter = nameConverters.getUniqueNameConverter();
        TriggerNameConverter triggerNameConverter = nameConverters.getTriggerNameConverter();
        SequenceNameConverter sequenceNameConverter = nameConverters.getSequenceNameConverter();
        ArrayList<String> back = new ArrayList<String>();
        String trigger = this.getTriggerNameForField(triggerNameConverter, table, oldField);
        if (trigger != null) {
            back.add("DROP TRIGGER " + this.processID(trigger));
        }
        if ((function = this.getFunctionNameForField(triggerNameConverter, table, oldField)) != null) {
            back.add("DROP FUNCTION " + this.processID(function));
        }
        if ((toRenderFunction = this.renderFunctionForField(triggerNameConverter, table, field)) != null) {
            back.add(toRenderFunction);
        }
        if ((toRenderTrigger = this.renderTriggerForField(triggerNameConverter, sequenceNameConverter, table, field)) != null) {
            back.add(toRenderTrigger);
        }
        if (oldField.isNotNull() && !field.isNotNull()) {
            back.add("ALTER TABLE " + this.withSchema(table.getName()) + " MODIFY (" + this.processID(field.getName()) + " NULL)");
        }
        if (!oldField.isNotNull() && field.isNotNull()) {
            back.add("ALTER TABLE " + this.withSchema(table.getName()) + " MODIFY (" + this.processID(field.getName()) + " NOT NULL)");
        }
        if (!Objects.equal((Object)oldField.getDefaultValue(), (Object)field.getDefaultValue())) {
            back.add("ALTER TABLE " + this.withSchema(table.getName()) + " MODIFY (" + this.processID(field.getName()) + " DEFAULT " + this.renderValue(field.getDefaultValue()) + ")");
        }
        if (oldField.isUnique() && !field.isUnique()) {
            back.add("ALTER TABLE " + this.withSchema(table.getName()) + " DROP CONSTRAINT " + uniqueNameConverter.getName(table.getName(), field.getName()));
        }
        if (!oldField.isUnique() && field.isUnique()) {
            back.add("ALTER TABLE " + this.withSchema(table.getName()) + " ADD CONSTRAINT " + uniqueNameConverter.getName(table.getName(), field.getName()) + " UNIQUE (" + this.processID(field.getName()) + ")");
        }
        return back;
    }

    @Override
    protected String renderAlterTableDropKey(DDLForeignKey key) {
        StringBuilder back = new StringBuilder("ALTER TABLE ");
        back.append(this.withSchema(key.getDomesticTable())).append(" DROP CONSTRAINT ").append(this.processID(key.getFKName()));
        return back.toString();
    }

    @Override
    protected String renderDropIndex(IndexNameConverter indexNameConverter, DDLIndex index) {
        return "DROP INDEX " + this.withSchema(indexNameConverter.getName(this.shorten(index.getTable()), this.shorten(index.getField())));
    }

    @Override
    protected String renderDropTable(DDLTable table) {
        return "DROP TABLE " + this.withSchema(table.getName()) + " PURGE";
    }

    @Override
    public void handleUpdateError(String sql, SQLException e) throws SQLException {
        if (this.isDropTrigger(sql, e) || this.isDropSequence(sql, e)) {
            this.logger.debug("Ignoring non-existant trigger for SQL <" + sql + ">", (Throwable)e);
            return;
        }
        super.handleUpdateError(sql, e);
    }

    private boolean isDropTrigger(String sql, SQLException e) {
        return e.getErrorCode() == 4080 && sql.startsWith("DROP");
    }

    private boolean isDropSequence(String sql, SQLException e) {
        return e.getErrorCode() == 2289 && sql.startsWith("DROP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends RawEntity<K>, K> K executeInsertReturningKey(EntityManager manager, Connection conn, Class<T> entityType, Class<K> pkType, String pkField, String sql, DBParam ... params) throws SQLException {
        Object object;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            this.onSql(sql);
            stmt = conn.prepareStatement(sql, new String[]{pkField});
            Object back = this.setParameters(manager, stmt, params, pkField);
            stmt.executeUpdate();
            if (back == null && (res = stmt.getGeneratedKeys()).next()) {
                back = this.typeManager.getType(pkType).getLogicalType().pullFromDatabase(null, res, pkType, 1);
            }
            object = back;
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(res);
            SqlUtils.closeQuietly(stmt);
            throw throwable;
        }
        SqlUtils.closeQuietly(res);
        SqlUtils.closeQuietly(stmt);
        return (K)object;
    }

    private Object setParameters(EntityManager manager, PreparedStatement stmt, DBParam[] params, String pkField) throws SQLException {
        Object back = null;
        for (int i = 0; i < params.length; ++i) {
            Object value = params[i].getValue();
            if (value instanceof RawEntity) {
                value = Common.getPrimaryKeyValue((RawEntity)value);
            }
            if (params[i].getField().equalsIgnoreCase(pkField)) {
                back = value;
            }
            if (value == null) {
                this.putNull(stmt, i + 1);
                continue;
            }
            TypeInfo<?> type = this.getTypeManager().getType(value.getClass());
            type.getLogicalType().putToDatabase(manager, stmt, i + 1, value, type.getJdbcWriteType());
        }
        return back;
    }

    @Override
    protected List<String> renderDropTriggers(final TriggerNameConverter triggerNameConverter, final DDLTable table) {
        return this.renderFields(table, new IsAutoIncrementFieldPredicate(), new Function<DDLField, String>(){

            public String apply(DDLField field) {
                return OracleDatabaseProvider.this.renderDropTrigger(triggerNameConverter, table, field);
            }
        });
    }

    private String renderDropTrigger(TriggerNameConverter triggerNameConverter, DDLTable table, DDLField field) {
        return "DROP TRIGGER " + this.withSchema(triggerNameConverter.autoIncrementName(table.getName(), field.getName()));
    }

    @Override
    protected List<String> renderDropSequences(final SequenceNameConverter sequenceNameConverter, final DDLTable table) {
        return this.renderFields(table, new IsAutoIncrementFieldPredicate(), new Function<DDLField, String>(){

            public String apply(DDLField field) {
                return OracleDatabaseProvider.this.renderDropSequence(sequenceNameConverter, table, field);
            }
        });
    }

    private String renderDropSequence(SequenceNameConverter sequenceNameConverter, DDLTable table, DDLField field) {
        return "DROP SEQUENCE " + this.withSchema(sequenceNameConverter.getName(this.shorten(table.getName()), this.shorten(field.getName())));
    }

    @Override
    protected List<String> renderSequences(final SequenceNameConverter sequenceNameConverter, final DDLTable table) {
        return this.renderFields(table, new IsAutoIncrementFieldPredicate(), new Function<DDLField, String>(){

            public String apply(DDLField field) {
                return OracleDatabaseProvider.this.renderSequence(sequenceNameConverter, table, field);
            }
        });
    }

    private String renderSequence(SequenceNameConverter sequenceNameConverter, DDLTable table, DDLField field) {
        String sequenceName = sequenceNameConverter.getName(this.shorten(table.getName()), this.shorten(field.getName()));
        return "CREATE SEQUENCE " + this.withSchema(sequenceName) + " INCREMENT BY 1 START WITH 1 NOMAXVALUE MINVALUE 1";
    }

    @Override
    protected boolean shouldQuoteID(String id) {
        return !"*".equals(id);
    }

    @Override
    protected int getMaxIDLength() {
        return 30;
    }

    @Override
    protected Set<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    public void putNull(PreparedStatement stmt, int index) throws SQLException {
        stmt.setString(index, null);
    }

    @Override
    public void putBoolean(PreparedStatement stmt, int index, boolean value) throws SQLException {
        stmt.setInt(index, value ? 1 : 0);
    }

    private static class IsAutoIncrementFieldPredicate
    implements Predicate<DDLField> {
        private IsAutoIncrementFieldPredicate() {
        }

        public boolean apply(DDLField field) {
            return field.isAutoIncrement();
        }
    }
}

