/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.ActiveObjectsException;
import net.java.ao.Common;
import net.java.ao.DBParam;
import net.java.ao.DatabaseProvider;
import net.java.ao.DefaultPolymorphicTypeMapper;
import net.java.ao.EntityManagerConfiguration;
import net.java.ao.EntityProxy;
import net.java.ao.EntityProxyAccessor;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Generator;
import net.java.ao.LRUMap;
import net.java.ao.MethodFinder;
import net.java.ao.PolymorphicTypeMapper;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.ReadOnlyEntityProxy;
import net.java.ao.ReadOnlyEntityProxyFactory;
import net.java.ao.SchemaConfiguration;
import net.java.ao.ValueGenerator;
import net.java.ao.cache.Cache;
import net.java.ao.cache.CacheLayer;
import net.java.ao.cache.RAMCache;
import net.java.ao.cache.RAMRelationsCache;
import net.java.ao.cache.RelationsCache;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.CachingNameConverters;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.NameConverters;
import net.java.ao.schema.SchemaGenerator;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.sql.SqlUtils;
import net.java.ao.types.TypeInfo;
import net.java.ao.types.TypeManager;
import net.java.ao.util.StringUtils;

public class EntityManager {
    private final DatabaseProvider provider;
    private final EntityManagerConfiguration configuration;
    private final SchemaConfiguration schemaConfiguration;
    private final NameConverters nameConverters;
    private Map<RawEntity<?>, EntityProxy<? extends RawEntity<?>, ?>> proxies;
    private final ReadWriteLock proxyLock = new ReentrantReadWriteLock(true);
    private Map<CacheKey<?>, Reference<RawEntity<?>>> entityCache;
    private final ReadWriteLock entityCacheLock = new ReentrantReadWriteLock(true);
    private Cache cache;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private PolymorphicTypeMapper typeMapper;
    private final ReadWriteLock typeMapperLock = new ReentrantReadWriteLock(true);
    private Map<Class<? extends ValueGenerator<?>>, ValueGenerator<?>> valGenCache;
    private final ReadWriteLock valGenCacheLock = new ReentrantReadWriteLock(true);
    private final RelationsCache relationsCache = new RAMRelationsCache();

    public EntityManager(DatabaseProvider provider, EntityManagerConfiguration configuration) {
        this.provider = (DatabaseProvider)Preconditions.checkNotNull((Object)provider);
        this.configuration = (EntityManagerConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.proxies = configuration.useWeakCache() ? new MapMaker().weakKeys().makeMap() : new MapMaker().softKeys().makeMap();
        this.entityCache = new LRUMap(500);
        this.cache = new RAMCache();
        this.valGenCache = new HashMap();
        this.nameConverters = new CachingNameConverters(configuration.getNameConverters());
        this.schemaConfiguration = (SchemaConfiguration)Preconditions.checkNotNull((Object)configuration.getSchemaConfiguration());
        this.typeMapper = new DefaultPolymorphicTypeMapper(new HashMap());
    }

    public void migrate(Class<? extends RawEntity<?>> ... entities) throws SQLException {
        SchemaGenerator.migrate(this.provider, this.schemaConfiguration, this.nameConverters, entities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        LinkedList toFlush = new LinkedList();
        this.proxyLock.readLock().lock();
        try {
            for (Map.Entry<RawEntity<?>, EntityProxy<? extends RawEntity<?>, ?>> entry : this.proxies.entrySet()) {
                toFlush.add(entry);
            }
        }
        finally {
            this.proxyLock.readLock().unlock();
        }
        for (Map.Entry<RawEntity<Object>, EntityProxy<RawEntity<Object>, Object>> entry : toFlush) {
            entry.getValue().flushCache(entry.getKey());
        }
        this.entityCacheLock.writeLock().lock();
        try {
            this.entityCache.clear();
            this.relationsCache.flush();
        }
        finally {
            this.entityCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(RawEntity<?> ... entities) {
        ArrayList types = new ArrayList(entities.length);
        HashMap toFlush = new HashMap();
        this.proxyLock.readLock().lock();
        try {
            for (RawEntity<?> entity : entities) {
                this.verify(entity);
                types.add(entity.getEntityType());
                toFlush.put(entity, this.proxies.get(entity));
            }
        }
        finally {
            this.proxyLock.readLock().unlock();
        }
        for (Map.Entry entry : toFlush.entrySet()) {
            ((EntityProxy)entry.getValue()).flushCache((RawEntity)entry.getKey());
        }
        this.relationsCache.remove(types.toArray(new Class[types.size()]));
    }

    public final <T extends RawEntity<K>, K> T[] get(Class<T> type, K ... keys) throws SQLException {
        String primaryKeyField = Common.getPrimaryKeyField(type, this.getFieldNameConverter());
        return this.getFromCache(type, this.findByPrimaryKey(type, primaryKeyField), keys);
    }

    private <T extends RawEntity<K>, K> Function<T, K> findByPrimaryKey(final Class<T> type, final String primaryKeyField) {
        return new Function<T, K>(){

            @Override
            public T invoke(K k) throws SQLException {
                RawEntity[] ts = EntityManager.this.find(type, primaryKeyField + " = ?", new Object[]{k});
                if (ts.length == 1) {
                    return ts[0];
                }
                if (ts.length == 0) {
                    return null;
                }
                throw new ActiveObjectsException("Found more that one object of type '" + type.getName() + "' for key '" + k + "'");
            }
        };
    }

    protected <T extends RawEntity<K>, K> T[] peer(final Class<T> type, K ... keys) throws SQLException {
        return this.getFromCache(type, new Function<T, K>(){

            @Override
            public T invoke(K key) {
                return EntityManager.this.getAndInstantiate(type, key);
            }
        }, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends RawEntity<K>, K> T[] getFromCache(Class<T> type, Function<T, K> create, K ... keys) throws SQLException {
        RawEntity[] back = (RawEntity[])Array.newInstance(type, keys.length);
        int index = 0;
        for (K key : keys) {
            this.entityCacheLock.writeLock().lock();
            try {
                RawEntity<?> entity;
                Reference<RawEntity<?>> reference;
                Reference<RawEntity<?>> ref = reference = this.entityCache.get(new CacheKey<K>(key, type));
                RawEntity<?> rawEntity = entity = ref == null ? null : ref.get();
                if (entity != null) {
                    back[index++] = entity;
                    continue;
                }
                back[index++] = (RawEntity)create.invoke(key);
            }
            finally {
                this.entityCacheLock.writeLock().unlock();
            }
        }
        return back;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends RawEntity<K>, K> T getAndInstantiate(Class<T> type, K key) {
        EntityProxy<T, K> proxy = new EntityProxy<T, K>(this, type, key);
        RawEntity entity = (RawEntity)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type, EntityProxyAccessor.class}, proxy));
        this.proxyLock.writeLock().lock();
        try {
            this.proxies.put(entity, proxy);
        }
        finally {
            this.proxyLock.writeLock().unlock();
        }
        this.entityCache.put(new CacheKey<K>(key, type), this.createRef(entity));
        return (T)entity;
    }

    public <T extends RawEntity<K>, K> T get(Class<T> type, K key) throws SQLException {
        return this.get(type, (K)EntityManager.toArray(key))[0];
    }

    protected <T extends RawEntity<K>, K> T peer(Class<T> type, K key) throws SQLException {
        return this.peer(type, (K)EntityManager.toArray(key))[0];
    }

    private static <K> K[] toArray(K key) {
        return new Object[]{key};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends RawEntity<K>, K> T create(Class<T> type, DBParam ... params) throws SQLException {
        RawEntity back = null;
        String table = this.nameConverters.getTableNameConverter().getName(type);
        HashSet<DBParam> listParams = new HashSet<DBParam>();
        listParams.addAll(Arrays.asList(params));
        for (Method method : MethodFinder.getInstance().findAnnotatedMethods(Generator.class, type)) {
            ValueGenerator<?> generator;
            Generator genAnno = method.getAnnotation(Generator.class);
            String field = this.nameConverters.getFieldNameConverter().getName(method);
            this.valGenCacheLock.writeLock().lock();
            try {
                if (this.valGenCache.containsKey(genAnno.value())) {
                    generator = this.valGenCache.get(genAnno.value());
                } else {
                    generator = genAnno.value().newInstance();
                    this.valGenCache.put(genAnno.value(), generator);
                }
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            finally {
                this.valGenCacheLock.writeLock().unlock();
                continue;
            }
            listParams.add(new DBParam(field, generator.generateValue(this)));
        }
        Method pkMethod = Common.getPrimaryKeyMethod(type);
        String pkField = Common.getPrimaryKeyField(type, this.getFieldNameConverter());
        Set<String> nonNullFields = Common.getNonNullFields(type, this.nameConverters.getFieldNameConverter());
        Set<String> fieldsThatShouldBeSet = Common.getNonNullFieldsWithNoDefaultAndNotGenerated(type, this.nameConverters.getFieldNameConverter());
        Map<String, TypeInfo> valueFields = Common.getValueFields(this.provider.getTypeManager(), this.nameConverters.getFieldNameConverter(), type);
        for (DBParam param : params) {
            if (param.getField().equals(pkField)) {
                Common.validatePrimaryKey(this.provider.getTypeManager(), type, param.getValue());
            } else {
                if (nonNullFields.contains(param.getField()) && param.getValue() == null) {
                    throw new IllegalArgumentException("Cannot set non-null field " + param.getField() + " to null");
                }
                if (nonNullFields.contains(param.getField()) && param.getValue() instanceof String && StringUtils.isBlank((String)param.getValue())) {
                    throw new IllegalArgumentException("Cannot set non-null String field " + param.getField() + " to ''");
                }
            }
            fieldsThatShouldBeSet.remove(param.getField());
            TypeInfo dbType = valueFields.get(param.getField());
            if (dbType == null || param.getValue() == null) continue;
            dbType.getLogicalType().validate(param.getValue());
        }
        if (!fieldsThatShouldBeSet.isEmpty()) {
            throw new IllegalArgumentException("There are some non-null fields that weren't set when trying to create entity '" + type.getName() + "', those fields are: " + nonNullFields);
        }
        Connection connection = null;
        try {
            connection = this.provider.getConnection();
            back = (RawEntity)this.peer(type, (K)this.provider.insertReturningKey(this, connection, type, Common.getPrimaryKeyClassType(type), Common.getPrimaryKeyField(type, this.getFieldNameConverter()), pkMethod.getAnnotation(AutoIncrement.class) != null, table, listParams.toArray(new DBParam[listParams.size()])));
        }
        finally {
            SqlUtils.closeQuietly(connection);
        }
        this.relationsCache.remove(type);
        back.init();
        return (T)back;
    }

    public <T extends RawEntity<K>, K> T create(Class<T> type, Map<String, Object> params) throws SQLException {
        DBParam[] arrParams = new DBParam[params.size()];
        int i = 0;
        for (String key : params.keySet()) {
            arrParams[i++] = new DBParam(key, params.get(key));
        }
        return this.create(type, arrParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RawEntity<?> ... entities) throws SQLException {
        if (entities.length == 0) {
            return;
        }
        HashMap organizedEntities = new HashMap();
        for (RawEntity<?> entity : entities) {
            this.verify(entity);
            Class<RawEntity<?>> type = this.getProxyForEntity(entity).getType();
            if (!organizedEntities.containsKey(type)) {
                organizedEntities.put(type, new LinkedList());
            }
            ((List)organizedEntities.get(type)).add(entity);
        }
        this.entityCacheLock.writeLock().lock();
        try {
            Connection conn = null;
            PreparedStatement stmt = null;
            try {
                conn = this.provider.getConnection();
                for (Class type : organizedEntities.keySet()) {
                    List entityList = (List)organizedEntities.get(type);
                    StringBuilder sql = new StringBuilder("DELETE FROM ");
                    sql.append(this.provider.withSchema(this.nameConverters.getTableNameConverter().getName(type)));
                    sql.append(" WHERE ").append(this.provider.processID(Common.getPrimaryKeyField(type, this.getFieldNameConverter()))).append(" IN (?");
                    for (int i = 1; i < entityList.size(); ++i) {
                        sql.append(",?");
                    }
                    sql.append(')');
                    stmt = this.provider.preparedStatement(conn, sql);
                    int index = 1;
                    for (RawEntity entity : entityList) {
                        TypeInfo typeInfo = this.provider.getTypeManager().getType(entity.getEntityType());
                        typeInfo.getLogicalType().putToDatabase(this, stmt, index++, entity, typeInfo.getJdbcWriteType());
                    }
                    this.relationsCache.remove(type);
                    stmt.executeUpdate();
                }
            }
            finally {
                SqlUtils.closeQuietly(stmt);
                SqlUtils.closeQuietly(conn);
            }
            for (RawEntity<?> entity : entities) {
                this.entityCache.remove(new CacheKey(Common.getPrimaryKeyValue(entity), entity.getEntityType()));
            }
            this.proxyLock.writeLock().lock();
            try {
                for (RawEntity<?> entity : entities) {
                    this.proxies.remove(entity);
                }
            }
            finally {
                this.proxyLock.writeLock().unlock();
            }
        }
        finally {
            this.entityCacheLock.writeLock().unlock();
        }
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> type) throws SQLException {
        return this.find(type, Query.select());
    }

    public final <T extends RawEntity<K>, K> T[] find(Class<T> type, String criteria, Object ... parameters) throws SQLException {
        return this.find(type, Query.select().where(criteria, parameters));
    }

    public final <T extends RawEntity<K>, K> T[] find(Class<T> type, Query query) throws SQLException {
        String selectField = Common.getPrimaryKeyField(type, this.getFieldNameConverter());
        query.resolveFields(type, this.getFieldNameConverter());
        Iterable<String> fields = query.getFields();
        if (Iterables.size(fields) == 1) {
            selectField = (String)Iterables.get(fields, (int)0);
        }
        return this.find(type, selectField, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends RawEntity<K>, K> T[] find(Class<T> type, String field, Query query) throws SQLException {
        ArrayList<T> back = new ArrayList<T>();
        query.resolveFields(type, this.getFieldNameConverter());
        Preload preloadAnnotation = type.getAnnotation(Preload.class);
        if (preloadAnnotation != null && !((String)Iterables.get(query.getFields(), (int)0)).equals("*") && query.getJoins().isEmpty()) {
            Iterable<String> oldFields = query.getFields();
            ArrayList<Object> newFields = new ArrayList<Object>();
            for (String newField : Common.preloadValue(preloadAnnotation, this.nameConverters.getFieldNameConverter())) {
                newField = newField.trim();
                int fieldLoc = -1;
                for (int i = 0; i < Iterables.size(oldFields); ++i) {
                    if (!((String)Iterables.get(oldFields, (int)i)).equals(newField)) continue;
                    fieldLoc = i;
                    break;
                }
                if (fieldLoc < 0) {
                    newFields.add(newField);
                    continue;
                }
                newFields.add(Iterables.get(oldFields, (int)fieldLoc));
            }
            if (!newFields.contains("*")) {
                for (String oldField : oldFields) {
                    if (newFields.contains(oldField)) continue;
                    newFields.add(oldField);
                }
            }
            query.setFields(newFields.toArray(new String[newFields.size()]));
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.provider.getConnection();
            String sql = query.toSQL(type, this.provider, this.getTableNameConverter(), this.getFieldNameConverter(), false);
            stmt = this.provider.preparedStatement(conn, sql, 1004, 1007);
            this.provider.setQueryStatementProperties(stmt, query);
            query.setParameters(this, stmt);
            res = stmt.executeQuery();
            this.provider.setQueryResultSetProperties(res, query);
            TypeInfo primaryKeyType = Common.getPrimaryKeyType(this.provider.getTypeManager(), type);
            Class primaryKeyClassType = Common.getPrimaryKeyClassType(type);
            String[] canonicalFields = query.getCanonicalFields(this.provider, this.getFieldNameConverter(), type);
            while (res.next()) {
                T entity = this.peer(type, (K)primaryKeyType.getLogicalType().pullFromDatabase(this, res, primaryKeyClassType, field));
                CacheLayer cacheLayer = this.getProxyForEntity(entity).getCacheLayer((RawEntity<?>)entity);
                for (String cacheField : canonicalFields) {
                    cacheLayer.put(cacheField, res.getObject(cacheField));
                }
                back.add(entity);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(res, stmt, conn);
            throw throwable;
        }
        SqlUtils.closeQuietly(res, stmt, conn);
        return back.toArray((RawEntity[])Array.newInstance(type, back.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> T[] findWithSQL(Class<T> type, String keyField, String sql, Object ... parameters) throws SQLException {
        ArrayList<T> back = new ArrayList<T>();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            connection = this.provider.getConnection();
            stmt = this.provider.preparedStatement(connection, sql);
            TypeManager manager = this.provider.getTypeManager();
            for (int i = 0; i < parameters.length; ++i) {
                Class<Object> javaType = parameters[i].getClass();
                if (parameters[i] instanceof RawEntity) {
                    javaType = ((RawEntity)parameters[i]).getEntityType();
                }
                TypeInfo<?> typeInfo = manager.getType(javaType);
                typeInfo.getLogicalType().putToDatabase(this, stmt, i + 1, parameters[i], typeInfo.getJdbcWriteType());
            }
            res = stmt.executeQuery();
            while (res.next()) {
                back.add(this.peer(type, (K)Common.getPrimaryKeyType(this.provider.getTypeManager(), type).getLogicalType().pullFromDatabase(this, res, type, keyField)));
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(res);
            SqlUtils.closeQuietly(stmt);
            SqlUtils.closeQuietly(connection);
            throw throwable;
        }
        SqlUtils.closeQuietly(res);
        SqlUtils.closeQuietly(stmt);
        SqlUtils.closeQuietly(connection);
        return back.toArray((RawEntity[])Array.newInstance(type, back.size()));
    }

    public <T extends RawEntity<K>, K> void stream(Class<T> type, EntityStreamCallback<T, K> streamCallback) throws SQLException {
        this.stream(type, Query.select("*"), streamCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> void stream(Class<T> type, Query query, EntityStreamCallback<T, K> streamCallback) throws SQLException {
        TypeInfo primaryKeyType = Common.getPrimaryKeyType(this.provider.getTypeManager(), type);
        Class primaryKeyClassType = Common.getPrimaryKeyClassType(type);
        String[] canonicalFields = query.getCanonicalFields(this.provider, this.getFieldNameConverter(), type);
        String field = Common.getPrimaryKeyField(type, this.getFieldNameConverter());
        ReadOnlyEntityProxyFactory proxyFactory = new ReadOnlyEntityProxyFactory(this, type);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.provider.getConnection();
            String sql = query.toSQL(type, this.provider, this.getTableNameConverter(), this.getFieldNameConverter(), false);
            stmt = this.provider.preparedStatement(conn, sql, 1003, 1007);
            this.provider.setQueryStatementProperties(stmt, query);
            query.setParameters(this, stmt);
            res = stmt.executeQuery();
            this.provider.setQueryResultSetProperties(res, query);
            while (res.next()) {
                Object primaryKey = primaryKeyType.getLogicalType().pullFromDatabase(this, res, primaryKeyClassType, field);
                ReadOnlyEntityProxy proxy = proxyFactory.build(primaryKey);
                RawEntity entity = (RawEntity)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type, EntityProxyAccessor.class}, proxy));
                for (String fieldName : canonicalFields) {
                    proxy.addValue(fieldName, res);
                }
                streamCallback.onRowRead(entity);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(res, stmt, conn);
            throw throwable;
        }
        SqlUtils.closeQuietly(res, stmt, conn);
    }

    public <K> int count(Class<? extends RawEntity<K>> type) throws SQLException {
        return this.count(type, Query.select());
    }

    public <K> int count(Class<? extends RawEntity<K>> type, String criteria, Object ... parameters) throws SQLException {
        return this.count(type, Query.select().where(criteria, parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> int count(Class<? extends RawEntity<K>> type, Query query) throws SQLException {
        int n;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            connection = this.provider.getConnection();
            String sql = query.toSQL(type, this.provider, this.getTableNameConverter(), this.getFieldNameConverter(), true);
            stmt = this.provider.preparedStatement(connection, sql);
            this.provider.setQueryStatementProperties(stmt, query);
            query.setParameters(this, stmt);
            res = stmt.executeQuery();
            n = res.next() ? res.getInt(1) : -1;
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(res);
            SqlUtils.closeQuietly(stmt);
            SqlUtils.closeQuietly(connection);
            throw throwable;
        }
        SqlUtils.closeQuietly(res);
        SqlUtils.closeQuietly(stmt);
        SqlUtils.closeQuietly(connection);
        return n;
    }

    public NameConverters getNameConverters() {
        return this.nameConverters;
    }

    public TableNameConverter getTableNameConverter() {
        return this.nameConverters.getTableNameConverter();
    }

    public FieldNameConverter getFieldNameConverter() {
        return this.nameConverters.getFieldNameConverter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolymorphicTypeMapper(PolymorphicTypeMapper typeMapper) {
        this.typeMapperLock.writeLock().lock();
        try {
            this.typeMapper = typeMapper;
            if (typeMapper instanceof DefaultPolymorphicTypeMapper) {
                ((DefaultPolymorphicTypeMapper)typeMapper).resolveMappings(this.getTableNameConverter());
            }
        }
        finally {
            this.typeMapperLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolymorphicTypeMapper getPolymorphicTypeMapper() {
        this.typeMapperLock.readLock().lock();
        try {
            if (this.typeMapper == null) {
                throw new RuntimeException("No polymorphic type mapper was specified");
            }
            PolymorphicTypeMapper polymorphicTypeMapper = this.typeMapper;
            return polymorphicTypeMapper;
        }
        finally {
            this.typeMapperLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(Cache cache) {
        this.cacheLock.writeLock().lock();
        try {
            if (!this.cache.equals(cache)) {
                this.cache.dispose();
                this.cache = cache;
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache() {
        this.cacheLock.readLock().lock();
        try {
            Cache cache = this.cache;
            return cache;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public DatabaseProvider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends RawEntity<K>, K> EntityProxy<T, K> getProxyForEntity(T entity) {
        this.proxyLock.readLock().lock();
        try {
            EntityProxy entityProxy = ((EntityProxyAccessor)((Object)entity)).getEntityProxy();
            return entityProxy;
        }
        finally {
            this.proxyLock.readLock().unlock();
        }
    }

    RelationsCache getRelationsCache() {
        return this.relationsCache;
    }

    private Reference<RawEntity<?>> createRef(RawEntity<?> entity) {
        if (this.configuration.useWeakCache()) {
            return new WeakReference(entity);
        }
        return new SoftReference(entity);
    }

    private void verify(RawEntity<?> entity) {
        if (entity.getEntityManager() != this) {
            throw new RuntimeException("Entities can only be used with a single EntityManager instance");
        }
    }

    private static class CacheKey<T> {
        private T key;
        private Class<? extends RawEntity<?>> type;

        public CacheKey(T key, Class<? extends RawEntity<T>> type) {
            this.key = key;
            this.type = type;
        }

        public int hashCode() {
            return (this.type.hashCode() + this.key.hashCode()) % 65536;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey keyObj = (CacheKey)obj;
                if (this.key.equals(keyObj.key) && this.type.equals(keyObj.type)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static interface Function<R, F> {
        public R invoke(F var1) throws SQLException;
    }
}

