/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.ao.DatabaseProvider;
import net.java.ao.DisposableDataSource;
import net.java.ao.Query;
import net.java.ao.schema.IndexNameConverter;
import net.java.ao.schema.NameConverters;
import net.java.ao.schema.UniqueNameConverter;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLForeignKey;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.schema.ddl.SQLAction;
import net.java.ao.types.TypeManager;

public class H2DatabaseProvider
extends DatabaseProvider {
    private static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object)"CROSS", (Object)"CURRENT_DATE", (Object)"CURRENT_TIME", (Object)"CURRENT_TIMESTAMP", (Object)"DISTINCT", (Object)"EXCEPT", (Object[])new String[]{"EXISTS", "FALSE", "FOR", "FROM", "FULL", "GROUP", "HAVING", "INNER", "INTERSECT", "IS", "JOIN", "LIKE", "LIMIT", "MINUS", "NATURAL", "NOT", "NULL", "ON", "ORDER", "PRIMARY", "ROWNUM", "SELECT", "SYSDATE", "SYSTIME", "SYSTIMESTAMP", "TODAY", "TRUE", "UNION", "UNIQUE", "WHERE"});

    public H2DatabaseProvider(DisposableDataSource dataSource) {
        this(dataSource, "PUBLIC");
    }

    public H2DatabaseProvider(DisposableDataSource dataSource, String schema) {
        super(dataSource, schema, TypeManager.h2());
    }

    @Override
    protected String renderQueryLimit(Query query) {
        StringBuilder sql = new StringBuilder();
        if (query.getLimit() < 0 && query.getOffset() > 0) {
            sql.append(" LIMIT -1");
        }
        sql.append(super.renderQueryLimit(query));
        return sql.toString();
    }

    @Override
    protected Iterable<SQLAction> renderAlterTableAddColumn(NameConverters nameConverters, DDLTable table, DDLField field) {
        Iterable<SQLAction> back = super.renderAlterTableAddColumn(nameConverters, table, field);
        if (field.isUnique()) {
            return Iterables.concat(back, (Iterable)ImmutableList.of((Object)this.renderAddUniqueConstraint(nameConverters.getUniqueNameConverter(), table, field)));
        }
        return back;
    }

    @Override
    protected Iterable<SQLAction> renderAlterTableChangeColumn(NameConverters nameConverters, DDLTable table, DDLField oldField, DDLField field) {
        ImmutableList.Builder back = ImmutableList.builder();
        back.addAll(super.renderAlterTableChangeColumn(nameConverters, table, oldField, field));
        if (!field.isPrimaryKey()) {
            if (oldField.isUnique() && !field.isUnique()) {
                back.add((Object)this.renderDropUniqueConstraint(nameConverters.getUniqueNameConverter(), table, field));
            } else if (!oldField.isUnique() && field.isUnique()) {
                back.add((Object)this.renderAddUniqueConstraint(nameConverters.getUniqueNameConverter(), table, field));
            }
        }
        return back.build();
    }

    @Override
    protected SQLAction renderAlterTableChangeColumnStatement(NameConverters nameConverters, DDLTable table, DDLField oldField, DDLField field, DatabaseProvider.RenderFieldOptions options) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(this.withSchema(table.getName()));
        sql.append(" ALTER COLUMN ");
        sql.append(this.renderField(nameConverters, table, field, options));
        if (oldField.isNotNull() && !field.isNotNull()) {
            sql.append(" NULL ");
        }
        return SQLAction.of(sql);
    }

    @Override
    protected String renderFieldDefault(DDLTable table, DDLField field) {
        StringBuilder sql = new StringBuilder();
        if (field.getDefaultValue() != null) {
            sql.append(" DEFAULT ").append(this.renderValue(field.getDefaultValue()));
        }
        return sql.toString();
    }

    @Override
    protected SQLAction renderAlterTableDropKey(DDLForeignKey key) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(this.withSchema(key.getDomesticTable()));
        sql.append(" DROP CONSTRAINT ");
        sql.append(this.processID(key.getFKName()));
        return SQLAction.of(sql);
    }

    @Override
    protected SQLAction renderDropIndex(IndexNameConverter indexNameConverter, DDLIndex index) {
        return SQLAction.of(new StringBuilder().append("DROP INDEX IF EXISTS ").append(this.withSchema(index.getIndexName())));
    }

    @Override
    protected String renderConstraintsForTable(UniqueNameConverter uniqueNameConverter, DDLTable table) {
        StringBuilder sql = new StringBuilder(super.renderConstraintsForTable(uniqueNameConverter, table));
        for (DDLField field : table.getFields()) {
            if (!field.isUnique()) continue;
            sql.append("   ");
            sql.append(this.renderUniqueConstraint(uniqueNameConverter, table, field));
            sql.append(",\n");
        }
        return sql.toString();
    }

    @Override
    protected String renderUnique(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        return "";
    }

    @Override
    public Object parseValue(int type, String value) {
        if (value == null || value.equals("") || value.equals("NULL")) {
            return null;
        }
        switch (type) {
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                Matcher matcher = Pattern.compile("'(.*)'.*").matcher(value);
                if (!matcher.find()) break;
                value = matcher.group(1);
            }
        }
        return super.parseValue(type, value);
    }

    @Override
    protected Set<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    private SQLAction renderAddUniqueConstraint(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(this.withSchema(table.getName()));
        sql.append(" ADD ");
        sql.append(this.renderUniqueConstraint(uniqueNameConverter, table, field));
        return SQLAction.of(sql);
    }

    private SQLAction renderDropUniqueConstraint(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(this.withSchema(table.getName()));
        sql.append(" DROP CONSTRAINT ");
        sql.append(uniqueNameConverter.getName(table.getName(), field.getName()));
        return SQLAction.of(sql);
    }

    private String renderUniqueConstraint(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        StringBuilder sql = new StringBuilder();
        sql.append(" CONSTRAINT ");
        sql.append(uniqueNameConverter.getName(table.getName(), field.getName()));
        sql.append(" UNIQUE(");
        sql.append(this.processID(field.getName()));
        sql.append(")");
        return sql.toString();
    }
}

