/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.java.ao.Common;
import net.java.ao.DBParam;
import net.java.ao.DatabaseProvider;
import net.java.ao.DisposableDataSource;
import net.java.ao.EntityManager;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.IndexNameConverter;
import net.java.ao.schema.NameConverters;
import net.java.ao.schema.UniqueNameConverter;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLForeignKey;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.schema.ddl.SQLAction;
import net.java.ao.types.TypeInfo;
import net.java.ao.types.TypeManager;
import org.apache.commons.lang3.StringUtils;

public class H2TwoDotXDatabaseProvider
extends DatabaseProvider {
    private static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object)"ALL", (Object)"ARRAY", (Object)"CASE", (Object)"CHECK", (Object)"CONSTRAINT", (Object)"CROSS", (Object[])new String[]{"CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DISTINCT", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "IF", "INNER", "INTERSECT", "INTERSECTS", "INTERVAL", "IS", "JOIN", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "MINUS", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "ORDER", "PRIMARY", "QUALIFY", "ROW", "ROWNUM", "SELECT", "SYSDATE", "SYSTIME", "SYSTIMESTAMP", "TABLE", "TODAY", "TRUE", "UNION", "UNIQUE", "VALUES", "WHERE", "WINDOW", "WITH", "AND", "SECOND", "KEY", "VALUE", "SYSTEM_USER", "USER"});
    private String tableName = null;

    public H2TwoDotXDatabaseProvider(DisposableDataSource dataSource) {
        this(dataSource, "PUBLIC");
    }

    public H2TwoDotXDatabaseProvider(DisposableDataSource dataSource, String schema) {
        super(dataSource, schema, TypeManager.h2());
    }

    @Override
    protected String renderQueryLimit(Query query) {
        StringBuilder sql = new StringBuilder();
        sql.append(super.renderQueryLimit(query));
        return sql.toString();
    }

    @Override
    protected Iterable<SQLAction> renderAlterTableAddColumn(NameConverters nameConverters, DDLTable table, DDLField field) {
        Iterable<SQLAction> back = super.renderAlterTableAddColumn(nameConverters, table, field);
        if (field.isUnique()) {
            return Iterables.concat(back, (Iterable)ImmutableList.of((Object)this.renderAddUniqueConstraint(nameConverters.getUniqueNameConverter(), table, field)));
        }
        return back;
    }

    @Override
    protected Iterable<SQLAction> renderAlterTableChangeColumn(NameConverters nameConverters, DDLTable table, DDLField oldField, DDLField field) {
        ImmutableList.Builder back = ImmutableList.builder();
        back.addAll(super.renderAlterTableChangeColumn(nameConverters, table, oldField, field));
        if (!field.isPrimaryKey()) {
            if (oldField.isUnique() && !field.isUnique()) {
                back.add((Object)this.renderDropUniqueConstraint(nameConverters.getUniqueNameConverter(), table, field));
            } else if (!oldField.isUnique() && field.isUnique()) {
                back.add((Object)this.renderAddUniqueConstraint(nameConverters.getUniqueNameConverter(), table, field));
            }
        }
        return back.build();
    }

    @Override
    protected SQLAction renderAlterTableChangeColumnStatement(NameConverters nameConverters, DDLTable table, DDLField oldField, DDLField field, DatabaseProvider.RenderFieldOptions options) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" ALTER COLUMN ");
        if (oldField.isNotNull() && field.isNotNull() && field.isPrimaryKey() && !field.getType().equals(oldField.getType())) {
            sql.append(this.resetAutoIncrementFieldWithChangedType(table, field));
        } else {
            sql.append(this.renderField(nameConverters, table, field, options));
            if (oldField.isNotNull() && !field.isNotNull()) {
                sql.append(" NULL ");
            }
        }
        return SQLAction.of(sql);
    }

    protected String resetAutoIncrementFieldWithChangedType(DDLTable table, DDLField field) {
        StringBuilder back = new StringBuilder();
        back.append(field.getName()).append(" ").append(field.getType().getSchemaProperties().getSqlTypeName()).append(" GENERATED BY DEFAULT AS IDENTITY(RESTART WITH (SELECT MAX(").append(field.getName()).append(") FROM ").append(this.withSchema(table.getName())).append(")+1)");
        return back.toString();
    }

    @Override
    protected String renderConstraints(NameConverters nameConverters, List<String> primaryKeys, DDLTable table) {
        StringBuilder back = new StringBuilder();
        if (primaryKeys.size() > 0) {
            back.append("    PRIMARY KEY(").append(this.processID(primaryKeys.get(0))).append(")");
        }
        back.append(this.renderConstraintsForTable(nameConverters.getUniqueNameConverter(), table));
        return back.toString();
    }

    @Override
    protected String renderFieldDefault(DDLTable table, DDLField field) {
        StringBuilder sql = new StringBuilder();
        if (field.getDefaultValue() != null) {
            sql.append(" DEFAULT ").append(this.renderValue(field.getDefaultValue()));
        }
        return sql.toString();
    }

    @Override
    protected SQLAction renderAlterTableDropKey(DDLForeignKey key) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.withSchema(key.getDomesticTable())).append(" DROP CONSTRAINT ").append(this.processID(key.getFKName()));
        return SQLAction.of(sql);
    }

    @Override
    protected SQLAction renderDropIndex(IndexNameConverter indexNameConverter, DDLIndex index) {
        return SQLAction.of(new StringBuilder().append("DROP INDEX IF EXISTS ").append(this.withSchema(index.getIndexName())));
    }

    @Override
    protected String renderConstraintsForTable(UniqueNameConverter uniqueNameConverter, DDLTable table) {
        StringBuilder sql = new StringBuilder();
        int count = 0;
        boolean uniqueCheck = false;
        int uniqueCount = 0;
        for (DDLField dDLField : table.getFields()) {
            if (!dDLField.isUnique()) continue;
            uniqueCheck = true;
            ++uniqueCount;
        }
        if (table.getForeignKeys().length > 0) {
            sql.append(",\n    ");
            for (DDLForeignKey dDLForeignKey : table.getForeignKeys()) {
                sql.append(this.renderForeignKey(dDLForeignKey));
                if (table.getForeignKeys().length <= ++count) continue;
                sql.append(",\n");
            }
        }
        if (uniqueCheck) {
            count = 0;
            sql.append(",\n   ");
            for (DDLField dDLField : table.getFields()) {
                if (!dDLField.isUnique()) continue;
                sql.append(this.renderUniqueConstraint(uniqueNameConverter, table, dDLField));
                if (uniqueCount <= ++count) continue;
                sql.append(",\n   ");
            }
        }
        sql.append("\n");
        return sql.toString();
    }

    @Override
    protected String renderUnique(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        return "";
    }

    @Override
    public Object parseValue(int type, String value) {
        if (value == null || value.equals("") || value.equals("NULL")) {
            return null;
        }
        switch (type) {
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                Matcher matcher = Pattern.compile("'(.*)'.*").matcher(value);
                if (!matcher.find()) break;
                value = matcher.group(1);
            }
        }
        return super.parseValue(type, value);
    }

    @Override
    protected Set<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    private SQLAction renderAddUniqueConstraint(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" ADD ").append(this.renderUniqueConstraint(uniqueNameConverter, table, field));
        return SQLAction.of(sql);
    }

    private SQLAction renderDropUniqueConstraint(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.withSchema(table.getName())).append(" DROP CONSTRAINT ").append(uniqueNameConverter.getName(table.getName(), field.getName()));
        return SQLAction.of(sql);
    }

    private String renderUniqueConstraint(UniqueNameConverter uniqueNameConverter, DDLTable table, DDLField field) {
        StringBuilder sql = new StringBuilder();
        sql.append(" CONSTRAINT ").append(uniqueNameConverter.getName(table.getName(), field.getName())).append(" UNIQUE(").append(this.processID(field.getName())).append(")");
        return sql.toString();
    }

    @Override
    protected String generateInsertSql(String pkField, String table, String[] fieldNames) {
        this.tableName = table;
        StringBuilder sql = new StringBuilder("INSERT INTO " + this.withSchema(table) + " (");
        if (fieldNames.length == 0) {
            sql.append(this.processID(pkField)).append(") SELECT COALESCE(MAX(").append(this.processID(pkField)).append("), 0) + 1 FROM ").append(this.withSchema(table));
        } else {
            sql.append(Arrays.stream(fieldNames).map(this::processID).collect(Collectors.joining(","))).append(") VALUES (").append(StringUtils.repeat((String)"?", (String)",", (int)fieldNames.length)).append(")");
        }
        return sql.toString();
    }

    @Override
    protected <T extends RawEntity<K>, K> K executeInsertReturningKey(EntityManager manager, Connection conn, Class<T> entityType, Class<K> pkType, String pkField, String sql, DBParam ... params) throws SQLException {
        Object back;
        block31: {
            back = null;
            boolean isAvailable = false;
            for (DBParam fieldname : params) {
                if (!fieldname.getField().equalsIgnoreCase(pkField)) continue;
                isAvailable = true;
                break;
            }
            if (!isAvailable && params.length != 0) {
                this.resetAutoIncrementColumn(this.tableName, pkField, conn);
            }
            try (PreparedStatement stmt = this.preparedStatement(conn, sql, 1);){
                for (int i = 0; i < params.length; ++i) {
                    Object value = params[i].getValue();
                    if (value instanceof RawEntity) {
                        value = Common.getPrimaryKeyValue((RawEntity)value);
                    }
                    if (params[i].getField().equalsIgnoreCase(pkField)) {
                        back = value;
                    }
                    if (value == null) {
                        this.putNull(stmt, i + 1);
                        continue;
                    }
                    TypeInfo<?> type = this.typeManager.getType(value.getClass());
                    type.getLogicalType().putToDatabase(manager, stmt, i + 1, value, type.getJdbcWriteType());
                }
                stmt.executeUpdate();
                if (back != null) break block31;
                try (ResultSet res = stmt.getGeneratedKeys();){
                    if (res.next()) {
                        back = this.typeManager.getType(pkType).getLogicalType().pullFromDatabase(null, res, pkType, 1);
                    }
                }
            }
        }
        return (K)back;
    }

    protected void resetAutoIncrementColumn(String table, String pkField, Connection conn) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.withSchema(table)).append(" ALTER COLUMN ").append(this.processID(pkField)).append(" RESTART WITH (SELECT MAX(").append(this.processID(pkField)).append(") + 1 FROM ").append(this.withSchema(table)).append(")");
        try (PreparedStatement stmt = this.preparedStatement(conn, sql, 2);){
            stmt.execute();
        }
        catch (SQLException ex) {
            this.logger.debug("Could not execute query", (Throwable)ex);
        }
    }

    private void executeInsertBatch(EntityManager manager, Connection conn, String sql, String[] fieldNames, List<Map<String, Object>> rows) throws SQLException {
        try (PreparedStatement stmt = this.preparedStatement(conn, sql, 2);){
            for (Map<String, Object> row : rows) {
                for (int i = 0; i < fieldNames.length; ++i) {
                    Object value = row.get(fieldNames[i]);
                    if (value instanceof RawEntity) {
                        value = Common.getPrimaryKeyValue((RawEntity)value);
                    }
                    if (value == null) {
                        this.putNull(stmt, i + 1);
                        continue;
                    }
                    TypeInfo<?> type = this.typeManager.getType(value.getClass());
                    type.getLogicalType().putToDatabase(manager, stmt, i + 1, value, type.getJdbcWriteType());
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
    }

    @Override
    protected <T extends RawEntity<K>, K> void insertBatch(EntityManager manager, Connection conn, Class<T> entityType, Class<K> pkType, String pkField, boolean pkIdentity, String table, List<Map<String, Object>> rows) throws SQLException {
        Objects.requireNonNull(rows);
        if (rows.isEmpty()) {
            return;
        }
        String[] fieldNames = (String[])rows.stream().flatMap(m -> m.keySet().stream()).distinct().toArray(String[]::new);
        boolean isAvailable = false;
        for (String fieldname : fieldNames) {
            if (!fieldname.equalsIgnoreCase(pkField)) continue;
            isAvailable = true;
            break;
        }
        if (!isAvailable && fieldNames != null) {
            this.resetAutoIncrementColumn(table, pkField, conn);
        }
        String sql = this.generateInsertSql(pkField, table, fieldNames);
        this.executeInsertBatch(manager, conn, sql, fieldNames, rows);
    }
}

