package net.java.ao.util;

import io.atlassian.util.concurrent.LazyReference;
import net.java.ao.DisposableDataSource;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class H2VersionUtil {
    private final static AtomicReference<Boolean> H2_LATEST_2_1_X = new AtomicReference<>();

    public H2VersionUtil(final DisposableDataSource dataSource) {
        if (H2_LATEST_2_1_X.get() == null) {
            H2_LATEST_2_1_X.set(getH2VersionFlag(dataSource));
        }
    }

    private boolean getH2VersionFlag(final DisposableDataSource dataSource) {
        try (Connection connection = dataSource.getConnection()) {
            int majorVersion = connection.getMetaData().getDatabaseMajorVersion();
            return majorVersion >= 2;
        } catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isH2Latest2_1_X() {
        return H2_LATEST_2_1_X.get();
    }
}