/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.converters;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import net.java.ao.RawEntity;
import net.java.ao.schema.CamelCaseTableNameConverter;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.test.ConfigurationProperties;
import net.java.ao.test.converters.SimplePrefix;
import net.java.ao.test.converters.TestTableNameConverter;
import net.java.ao.test.converters.UpperCaseTableNameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicTableNameConverter
implements TableNameConverter {
    private static final Logger logger = LoggerFactory.getLogger(DynamicTableNameConverter.class);
    private final Supplier<TableNameConverter> tncSupplier = Suppliers.memoize((Supplier)new SystemPropertyTableNameConverterSupplier());

    public String getName(Class<? extends RawEntity<?>> clazz) {
        return ((TableNameConverter)this.tncSupplier.get()).getName(clazz);
    }

    private static final class SystemPropertyTableNameConverterSupplier
    implements Supplier<TableNameConverter> {
        public static final String DEFAULT = "prefix";
        private final ImmutableMap<String, TableNameConverter> converters = ImmutableMap.of((Object)"prefix", (Object)new TestTableNameConverter(new SimplePrefix("AO_000000")), (Object)"camelcase", (Object)new CamelCaseTableNameConverter(), (Object)"uppercase", (Object)new UpperCaseTableNameConverter());

        private SystemPropertyTableNameConverterSupplier() {
        }

        public TableNameConverter get() {
            String key = ConfigurationProperties.get("ao.test.tablenameconverter", DEFAULT);
            TableNameConverter tnc = (TableNameConverter)this.converters.get((Object)key);
            logger.debug("Table name converter key is {} and resolved to {}", (Object)key, (Object)tnc.getClass().getName());
            return tnc;
        }
    }
}

