/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.converters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import net.java.ao.RawEntity;
import net.java.ao.atlassian.AtlassianTableNameConverter;
import net.java.ao.atlassian.TablePrefix;
import net.java.ao.schema.CamelCaseTableNameConverter;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.test.ConfigurationProperties;
import net.java.ao.test.converters.UpperCaseTableNameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicTableNameConverter
implements TableNameConverter {
    private static final Logger logger = LoggerFactory.getLogger(DynamicTableNameConverter.class);
    private final Supplier<TableNameConverter> tncSupplier = Suppliers.memoize((Supplier)new SystemPropertyTableNameConverterSupplier());

    public String getName(Class<? extends RawEntity<?>> clazz) {
        return ((TableNameConverter)this.tncSupplier.get()).getName(clazz);
    }

    private static final class TestPrefix
    implements TablePrefix {
        private static final String DEFAULT_SEPARATOR = "_";
        private final String prefix;
        private final String separator;

        public TestPrefix(String prefix) {
            this(prefix, DEFAULT_SEPARATOR);
        }

        public TestPrefix(String prefix, String separator) {
            this.prefix = (String)Preconditions.checkNotNull((Object)prefix);
            this.separator = (String)Preconditions.checkNotNull((Object)separator);
        }

        public String prepend(String string) {
            return this.prefix + this.separator + string;
        }
    }

    private static final class SystemPropertyTableNameConverterSupplier
    implements Supplier<TableNameConverter> {
        public static final String DEFAULT = "atlassian";
        private final ImmutableMap<String, TableNameConverter> converters = ImmutableMap.of((Object)"atlassian", (Object)new AtlassianTableNameConverter((TablePrefix)new TestPrefix("AO_000000")), (Object)"camelcase", (Object)new CamelCaseTableNameConverter(), (Object)"uppercase", (Object)new UpperCaseTableNameConverter());

        private SystemPropertyTableNameConverterSupplier() {
        }

        public TableNameConverter get() {
            String key = ConfigurationProperties.get("ao.test.tablenameconverter", DEFAULT);
            TableNameConverter tnc = (TableNameConverter)this.converters.get((Object)key);
            logger.debug("Table name converter key is {} and resolved to {}", (Object)key, (Object)tnc.getClass().getName());
            return tnc;
        }
    }
}

