/*
 * Decompiled with CFR 0.152.
 */
package org.javax.csv.csvio.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.javax.csv.csvio.GenericCsvWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvWriterImpl
extends GenericCsvWriter {
    private String delimiter;
    private String separator;
    private BufferedWriter bufferedWriter;

    public CsvWriterImpl(Properties properties, Writer writer) {
        super(properties, writer);
    }

    @Override
    protected void init() {
        this.delimiter = super.getProperty("FieldSeparator");
        this.separator = super.getProperty("RecordSeparator");
        int bufferSize = Integer.parseInt(super.getProperty("BufferSize", "4096"));
        this.bufferedWriter = new BufferedWriter(super.getWriter(), bufferSize);
    }

    @Override
    public void write(List<String> line) throws IOException {
        if (line == null) {
            return;
        }
        if (!line.isEmpty()) {
            Iterator<String> lineIt = line.iterator();
            this.bufferedWriter.write(lineIt.next());
            while (lineIt.hasNext()) {
                this.bufferedWriter.write(this.delimiter);
                this.bufferedWriter.write(lineIt.next());
            }
        }
        this.bufferedWriter.write(this.separator);
    }

    @Override
    public void close() throws IOException {
        this.bufferedWriter.close();
    }

    @Override
    public void flush() throws IOException {
        this.bufferedWriter.flush();
    }

    public static interface Property
    extends GenericCsvWriter.Property {
        public static final String BufferSize = "BufferSize";
    }
}

