/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs.model;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import net.raphimc.noteblocklib.format.nbs.NbsParser;
import net.raphimc.noteblocklib.format.nbs.model.NbsHeader;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;

public class NbsLayer {
    private Map<Integer, NbsNote> notesAtTick = new TreeMap<Integer, NbsNote>();
    private String name = "";
    private byte volume = (byte)100;
    private short panning = (short)100;
    private boolean locked = false;

    public NbsLayer(NbsHeader header, LittleEndianDataInputStream dis) throws IOException {
        this.name = NbsParser.readString(dis);
        if (header.getNbsVersion() >= 4) {
            this.locked = dis.readBoolean();
        }
        this.volume = dis.readByte();
        if (header.getNbsVersion() >= 2) {
            this.panning = dis.readByte();
        }
    }

    public NbsLayer(Map<Integer, NbsNote> notesAtTick, String name, byte volume, short panning, boolean locked) {
        this.notesAtTick = notesAtTick;
        this.name = name;
        this.volume = volume;
        this.panning = panning;
        this.locked = locked;
    }

    public NbsLayer() {
    }

    public void write(NbsHeader header, LittleEndianDataOutputStream dos) throws IOException {
        NbsParser.writeString(dos, this.name);
        if (header.getNbsVersion() >= 4) {
            dos.writeBoolean(this.locked);
        }
        dos.writeByte((int)this.volume);
        if (header.getNbsVersion() >= 2) {
            dos.writeByte((int)this.panning);
        }
    }

    public Map<Integer, NbsNote> getNotesAtTick() {
        return this.notesAtTick;
    }

    public void setNotesAtTick(Map<Integer, NbsNote> notesAtTick) {
        this.notesAtTick = notesAtTick;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte getVolume() {
        return this.volume;
    }

    public void setVolume(byte volume) {
        this.volume = volume;
    }

    public short getPanning() {
        return this.panning;
    }

    public void setPanning(short panning) {
        this.panning = panning;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }
}

