/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.javaocr.cluster.Metric;
import net.sourceforge.javaocr.matcher.Match;
import net.sourceforge.javaocr.matcher.MetricContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricMatcher {
    Map<Metric, Character> metrics = new HashMap<Metric, Character>();
    Map<Metric, Double> yellow = new HashMap<Metric, Double>();
    Map<Metric, Double> red = new HashMap<Metric, Double>();

    public void addMetric(Metric metric, Character character, double yellow, double red) {
        this.metrics.put(metric, character);
        this.yellow.put(metric, yellow);
        this.red.put(metric, red);
    }

    public List<Match> classify(double[] features) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Metric metric : this.metrics.keySet()) {
            double weight = metric.distance(features);
            Match match = new Match(this.metrics.get(metric), weight, this.yellow.get(metric), this.red.get(metric));
            matches.add(match);
        }
        Collections.sort(matches);
        return matches;
    }

    public Map<Metric, Character> getMetrics() {
        return this.metrics;
    }

    public Map<Metric, Double> getRed() {
        return this.red;
    }

    public Map<Metric, Double> getYellow() {
        return this.yellow;
    }

    public List<MetricContainer> containers() {
        ArrayList<MetricContainer> values = new ArrayList<MetricContainer>();
        for (Metric metric : this.getMetrics().keySet()) {
            MetricContainer clusterContainer = new MetricContainer();
            clusterContainer.setMetric(metric);
            clusterContainer.setRed(this.getRed().get(metric));
            clusterContainer.setYellow(this.getYellow().get(metric));
            clusterContainer.setCharacter(this.getMetrics().get(metric));
            values.add(clusterContainer);
        }
        return values;
    }

    public void setContainers(Collection<? extends MetricContainer> containers) {
        for (MetricContainer metricContainer : containers) {
            this.addMetric(metricContainer.getMetric(), metricContainer.getCharacter(), metricContainer.getYellow(), metricContainer.getRed());
        }
    }
}

