/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocr;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.ImageShrinker;

public class Shrinker
implements ImageShrinker {
    final int empty;

    public Shrinker(int empty) {
        this.empty = empty;
    }

    public Image shrink(Image source) {
        int borderY;
        int borderX;
        int originY;
        int originX;
        for (originX = 0; originX < source.getWidth(); ++originX) {
            source.iterateV(originX);
            if (!this.spanEmpty(source)) break;
        }
        for (originY = 0; originY < source.getHeight(); ++originY) {
            source.iterateH(originY);
            if (!this.spanEmpty(source)) break;
        }
        for (borderX = source.getWidth() - 1; borderX > originX; --borderX) {
            source.iterateV(borderX);
            if (!this.spanEmpty(source)) break;
        }
        for (borderY = source.getHeight() - 1; borderY > originY; --borderY) {
            source.iterateH(borderY);
            if (!this.spanEmpty(source)) break;
        }
        return source.chisel(originX, originY, borderX + 1 - originX, borderY + 1 - originY);
    }

    private boolean spanEmpty(Image source) {
        boolean spanEmpty = true;
        while (source.hasNext()) {
            if (source.next() == this.empty) continue;
            spanEmpty = false;
            break;
        }
        return spanEmpty;
    }
}

