/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.cluster;

import java.util.List;
import net.sourceforge.javaocr.plugin.cluster.Cluster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseCluster
implements Cluster {
    private double[] sum;
    private double[] mx;
    private int amountSamples;
    private int dimensions;

    public AbstractBaseCluster() {
    }

    protected AbstractBaseCluster(int dimensions) {
        this.dimensions = dimensions;
        this.sum = new double[dimensions];
    }

    protected AbstractBaseCluster(double[] mx) {
        this.mx = mx;
        this.dimensions = mx.length;
    }

    @Override
    public double[] center() {
        if (this.mx == null) {
            this.mx = new double[this.getDimensions()];
            for (int i = 0; i < this.getDimensions(); ++i) {
                this.mx[i] = this.getAmountSamples() == 0 ? 0.0 : this.sum[i] / (double)this.getAmountSamples();
            }
        }
        return this.mx;
    }

    public int getAmountSamples() {
        return this.amountSamples;
    }

    public double[] getMx() {
        return this.mx;
    }

    public void setMx(double[] mx) {
        this.mx = mx;
        if (mx != null) {
            this.setDimensions(mx.length);
        }
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setAmountSamples(int amountSamples) {
        this.amountSamples = amountSamples;
    }

    @Override
    public void train(double[] features) {
        ++this.amountSamples;
        this.mx = null;
        for (int i = 0; i < this.getDimensions(); ++i) {
            int n = i;
            this.sum[n] = this.sum[n] + features[i];
        }
    }

    public double[] getSum() {
        return this.sum;
    }

    public void setSum(double[] sum) {
        this.sum = sum;
    }

    @Override
    public double radius(List<double[]> samples) {
        double max = 0.0;
        for (double[] sample : samples) {
            double dist = this.distance(sample);
            if (!(dist > max)) continue;
            max = dist;
        }
        return max;
    }
}

