/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.fir;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.ImageFilter;

public abstract class AbstractNeighborhoodFilter
implements ImageFilter {
    protected int filterW;
    protected int filterH;
    private int sizeL;
    private int sizeR;
    private int sizeT;
    private int sizeB;
    private Image destImage;

    public AbstractNeighborhoodFilter(int width, int height, Image dest) {
        this.filterW = width > 0 ? width : 1;
        this.filterH = height > 0 ? height : 1;
        this.sizeL = (this.filterW - 1) / 2;
        this.sizeR = this.filterW - 1 - this.sizeL;
        this.sizeT = (this.filterH - 1) / 2;
        this.sizeB = this.filterH - 1 - this.sizeT;
        this.destImage = dest;
    }

    public void process(Image image) {
        int imageW = image.getWidth();
        int imageH = image.getHeight();
        for (int y = this.sizeT; y < imageH - this.sizeB; ++y) {
            for (int x = this.sizeL; x < imageW - this.sizeR; ++x) {
                Image nImage = image.chisel(x - this.sizeL, y - this.sizeT, this.filterW, this.filterH);
                this.destImage.put(x, y, this.processNeighborhood(nImage));
            }
        }
        image.chisel(0, 0, imageW, this.sizeT).copy(this.destImage.chisel(0, 0, imageW, this.sizeT));
        image.chisel(0, imageH - this.sizeB, imageW, this.sizeB).copy(this.destImage.chisel(0, imageH - this.sizeB, imageW, this.sizeB));
        image.chisel(0, 0, this.sizeL, imageH).copy(this.destImage.chisel(0, 0, this.sizeL, imageH));
        image.chisel(imageW - this.sizeR, 0, this.sizeR, imageH).copy(this.destImage.chisel(imageW - this.sizeR, 0, this.sizeR, imageH));
    }

    protected abstract int processNeighborhood(Image var1);
}

