/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.moment;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.ImageFilter;

public abstract class AbstractMomentFilter
implements ImageFilter {
    final int p;
    final int q;
    double moment;
    double[] coeffx;
    double[] coeffy;

    public AbstractMomentFilter(int p, int q) {
        this.p = p;
        this.q = q;
    }

    protected abstract double[] precomputeX(Image var1);

    protected abstract double[] precomputeY(Image var1);

    public void process(Image image) {
        this.coeffx = this.precomputeX(image);
        this.coeffy = this.precomputeY(image);
        for (int y = 0; y < image.getHeight(); ++y) {
            image.iterateH(y);
            int x = 0;
            while (image.hasNext()) {
                this.moment += (double)image.next() * this.coeffx[x++] * this.coeffy[y];
            }
        }
    }

    public double getMoment() {
        return this.moment;
    }
}

