/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.moment;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.plugin.moment.AbstractMomentFilter;

public class CentralMomentFilter
extends AbstractMomentFilter {
    double xMean;
    double yMean;

    public CentralMomentFilter(int p, int q, double xMean, double yMean) {
        super(p, q);
        this.xMean = xMean;
        this.yMean = yMean;
    }

    protected double[] precomputeX(Image image) {
        double[] doubles = new double[image.getWidth()];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = Math.pow((double)i - this.xMean, this.p);
        }
        return doubles;
    }

    protected double[] precomputeY(Image image) {
        double[] doubles = new double[image.getHeight()];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = Math.pow((double)i - this.yMean, this.q);
        }
        return doubles;
    }

    public double normalise(double m00) {
        return this.getMoment() / Math.pow(m00, (this.p + this.q) / 2 + 1);
    }
}

