/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.tools.instrumentation;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.javaflow.spi.ClasspathResourceLoader;
import org.apache.commons.javaflow.spi.InstrumentationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstrumentationAgent {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final Collection<String> BASE_OWN_PACKAGES = Collections.unmodifiableSet(InstrumentationUtils.packagePrefixesOf((Class[])new Class[]{Logger.class, ClasspathResourceLoader.class, AbstractInstrumentationAgent.class}));

    protected AbstractInstrumentationAgent() {
    }

    protected void install(String args, Instrumentation instrumentation) throws Exception {
        Collection<ClassFileTransformer> oneTimeTransformers = this.createOneTimeTransformers(args, instrumentation);
        Collection<ClassFileTransformer> retransformableTransformers = this.createRetransformableTransformers(args, instrumentation);
        AbstractInstrumentationAgent.joinTransformers(oneTimeTransformers, retransformableTransformers).forEach(t -> instrumentation.addTransformer((ClassFileTransformer)t, retransformableTransformers.contains(t)));
        AbstractInstrumentationAgent.joinTransformers(oneTimeTransformers, retransformableTransformers).map(o -> o.getClass().getName()).forEach(p -> System.setProperty(p, "true"));
    }

    private static Stream<ClassFileTransformer> joinTransformers(Collection<ClassFileTransformer> oneTimeTransformers, Collection<ClassFileTransformer> retransformableTransformers) {
        return Stream.of(oneTimeTransformers, retransformableTransformers).filter(Objects::nonNull).flatMap(Collection::stream).distinct();
    }

    protected void attach(String args, Instrumentation instrumentation, Set<String> ownPackages) throws Exception {
        this.log.info("Installing agent...");
        HashSet<String> extendedOwnPackages = null == ownPackages ? new HashSet<String>() : new HashSet<String>(ownPackages);
        extendedOwnPackages.add(InstrumentationUtils.packageNameOf(this.getClass()) + '.');
        Collection<ClassFileTransformer> oneTimeTransformers = this.createOneTimeTransformers(args, instrumentation);
        Collection<ClassFileTransformer> retransformableTransformers = this.createRetransformableTransformers(args, instrumentation);
        AbstractInstrumentationAgent.joinTransformers(oneTimeTransformers, retransformableTransformers).forEach(t -> {
            instrumentation.addTransformer((ClassFileTransformer)t, retransformableTransformers.contains(t));
            extendedOwnPackages.add(InstrumentationUtils.packageNameOf(t.getClass()) + '.');
        });
        if (this.isSkipRetransformOptionSet(args)) {
            if (this.log.isInfoEnabled()) {
                this.log.info("skipping re-transforming classes according to Java Agent argumentds supplied: " + args);
            }
        } else if (!instrumentation.isRetransformClassesSupported()) {
            this.log.info("JVM does not support re-transform, skipping re-transforming classes");
        } else if (retransformableTransformers.isEmpty()) {
            this.log.info("No retransformable transformers registered, skipping re-transforming classes");
        } else {
            this.retransformClasses(instrumentation, extendedOwnPackages);
        }
        AbstractInstrumentationAgent.joinTransformers(oneTimeTransformers, retransformableTransformers).map(o -> o.getClass().getName()).forEach(p -> System.setProperty(p, "true"));
        this.log.info("Agent was installed dynamically");
    }

    protected void retransformClasses(Instrumentation instrumentation, Set<String> ownPackages) {
        this.log.info("Re-transforming existing classes...");
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        for (Class clazz : instrumentation.getAllLoadedClasses()) {
            String className = clazz.getName();
            if (instrumentation.isModifiableClass(clazz)) {
                if (InstrumentationUtils.isClassLoaderParent((ClassLoader)systemClassLoader, (ClassLoader)clazz.getClassLoader())) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("Skip re-transforming boot or extension/platform class: " + className);
                    continue;
                }
                boolean isOwnClass = false;
                for (String ownPackage : ownPackages) {
                    if (!className.startsWith(ownPackage)) continue;
                    isOwnClass = true;
                    break;
                }
                if (isOwnClass) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Skip re-transforming class (agent class): " + className);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Re-transforming class: " + className);
                }
                try {
                    instrumentation.retransformClasses(clazz);
                }
                catch (Throwable e) {
                    this.log.error("Error re-transofrming class " + className, e);
                }
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Non-modifiable class (re-transforming skipped): " + className);
        }
        this.log.info("Existing classes was re-transormed");
    }

    protected boolean isSkipRetransformOptionSet(String args) {
        return "skip-retransform".equals(args);
    }

    protected Collection<ClassFileTransformer> createOneTimeTransformers(String args, Instrumentation instrumentation) {
        return Collections.emptySet();
    }

    protected Collection<ClassFileTransformer> createRetransformableTransformers(String args, Instrumentation instrumentation) {
        return Collections.singleton(this.createRetransformableTransformer(args, instrumentation));
    }

    protected abstract ClassFileTransformer createRetransformableTransformer(String var1, Instrumentation var2);
}

