/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.tools.instrumentation;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.HashSet;
import net.tascalate.async.tools.instrumentation.AbstractInstrumentationAgent;
import net.tascalate.async.tools.instrumentation.AsyncAwaitClassFileTransformer;
import net.tascalate.async.tools.instrumentation.RuntimeBytecodeInjector;
import net.tascalate.instrument.emitter.spi.ClassEmitters;
import org.apache.commons.javaflow.instrumentation.JavaFlowClassTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAwaitInstrumentationAgent
extends AbstractInstrumentationAgent {
    private static final Logger log = LoggerFactory.getLogger(AsyncAwaitClassFileTransformer.class);
    private ClassFileTransformer continuationsTransformer = new JavaFlowClassTransformer();

    public static void premain(String args, Instrumentation instrumentation) throws Exception {
        final AsyncAwaitInstrumentationAgent agent = new AsyncAwaitInstrumentationAgent();
        agent.install(args, instrumentation);
        System.setProperty(JavaFlowClassTransformer.class.getName(), "true");
        System.setProperty(AsyncAwaitInstrumentationAgent.class.getName(), "true");
        int jdkVersion = AsyncAwaitInstrumentationAgent.getJdkVersion();
        if (jdkVersion < 9) {
            if (log.isDebugEnabled()) {
                log.debug("JDK verion " + jdkVersion + " is less than 9, no lambda instrumentation patch required.");
            }
            return;
        }
        try {
            if (!RuntimeBytecodeInjector.isInjectionApplied()) {
                log.debug("Applying lambda post-processing injection...");
                instrumentation.redefineClasses(RuntimeBytecodeInjector.modifyLambdaMetafactory());
                log.debug("Lambda post-processing injection is applied.");
            } else {
                log.warn("Lambda post-processing injection was already applied, probably by some other agent.");
            }
            RuntimeBytecodeInjector.installTransformer(new RuntimeBytecodeInjector.LambdaClassTransformer(){

                @Override
                public byte[] transform(Class<?> lambdaOwningClass, byte[] lambdaClassBytes) throws Throwable {
                    return agent.transformLambdaClass(lambdaOwningClass, lambdaClassBytes);
                }
            });
        }
        catch (Throwable ex) {
            log.warn("Unable to apply lambda instrumentation patch (unsupported JVM)", ex);
        }
    }

    public static void agentmain(String args, Instrumentation instrumentation) throws Exception {
        HashSet<String> ownPackages = new HashSet<String>(BASE_OWN_PACKAGES);
        ownPackages.add("net.tascalate.async.tools.");
        new AsyncAwaitInstrumentationAgent().attach(args, instrumentation, ownPackages);
        System.setProperty(JavaFlowClassTransformer.class.getName(), "true");
        System.setProperty(AsyncAwaitInstrumentationAgent.class.getName(), "true");
    }

    @Override
    protected ClassFileTransformer createRetransformableTransformer(String args, Instrumentation instrumentation) {
        return new AsyncAwaitClassFileTransformer(this.continuationsTransformer, instrumentation);
    }

    byte[] transformLambdaClass(Class<?> lambdaOwningClass, byte[] input) throws Throwable {
        try {
            String className = null;
            if (log.isDebugEnabled()) {
                className = ClassEmitters.classNameOf((byte[])input);
                log.debug("Start transforming lambda class " + className + ", defined in " + lambdaOwningClass.getName());
            }
            byte[] output = this.continuationsTransformer.transform(lambdaOwningClass.getClassLoader(), null, null, lambdaOwningClass.getProtectionDomain(), input);
            if (log.isDebugEnabled()) {
                log.debug("Done transforming lambda class " + className + ", defined in " + lambdaOwningClass.getName() + ", modified = " + (input != output && output != null));
            }
            return output;
        }
        catch (Throwable ex) {
            log.error("Error transforming lambda class defined in " + lambdaOwningClass.getName(), ex);
            throw ex;
        }
    }

    private static int getJdkVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, version.indexOf(46, 2));
        } else {
            int dot = version.indexOf(".");
            if (dot > 0) {
                version = version.substring(0, dot);
            }
        }
        int javaVersion = Integer.parseInt(version);
        return javaVersion;
    }
}

