/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.tools.instrumentation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Documented;
import java.lang.instrument.ClassDefinition;
import net.tascalate.asmx.ClassReader;
import net.tascalate.asmx.ClassVisitor;
import net.tascalate.asmx.ClassWriter;
import net.tascalate.asmx.MethodVisitor;
import net.tascalate.asmx.Type;
import net.tascalate.asmx.commons.LocalVariablesSorter;

class RuntimeBytecodeInjector {
    private static final String CLASS = "java.lang.invoke.InnerClassLambdaMetafactory";

    RuntimeBytecodeInjector() {
    }

    static boolean isInjectionApplied() {
        Class<?> cls;
        try {
            cls = ClassLoader.getSystemClassLoader().loadClass(CLASS);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        Documented anno = cls.getAnnotation(Documented.class);
        return anno != null;
    }

    static ClassDefinition modifyLambdaMetafactory() throws ClassNotFoundException, IOException {
        ClassDefinition original = RuntimeBytecodeInjector.loadClassDefinition(CLASS);
        ClassReader classReader = new ClassReader((InputStream)new ByteArrayInputStream(original.getDefinitionClassFile()));
        ClassWriter classWriter = new ClassWriter(classReader, 0);
        ClassVisitor cv = new ClassVisitor(589824, (ClassVisitor)classWriter){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                Type annoType = Type.getType(Documented.class);
                this.visitAnnotation(annoType.getDescriptor(), true).visitEnd();
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if ("spinInnerClass".equals(name) || "generateInnerClass".equals(name)) {
                    class PatchClassDefinitionMethodVisitor
                    extends LocalVariablesSorter {
                        PatchClassDefinitionMethodVisitor(int access, String desc, MethodVisitor mv) {
                            super(589824, access, desc, mv);
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                            if (opcode == 182 && "toByteArray".equals(name) && owner.contains("ClassWriter")) {
                                Type bytesType = Type.getType(byte[].class);
                                Type classType = Type.getType(Class.class);
                                Type objectType = Type.getType(Object.class);
                                Type objectsType = Type.getType(Object[].class);
                                Type systemType = Type.getType(System.class);
                                Type printStreamType = Type.getType(PrintStream.class);
                                int bytesVar = this.newLocal(bytesType);
                                int params = this.newLocal(objectsType);
                                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                                this.visitVarInsn(bytesType.getOpcode(54), bytesVar);
                                this.visitInsn(6);
                                this.visitTypeInsn(189, objectType.getInternalName());
                                this.visitVarInsn(objectsType.getOpcode(54), params);
                                this.visitVarInsn(objectsType.getOpcode(21), params);
                                this.visitInsn(3);
                                this.visitVarInsn(25, 0);
                                this.visitInsn(83);
                                this.visitVarInsn(objectsType.getOpcode(21), params);
                                this.visitInsn(4);
                                this.visitVarInsn(25, 0);
                                this.visitFieldInsn(180, "java/lang/invoke/AbstractValidatingLambdaMetafactory", "targetClass", classType.getDescriptor());
                                this.visitInsn(83);
                                this.visitVarInsn(objectsType.getOpcode(21), params);
                                this.visitInsn(5);
                                this.visitVarInsn(bytesType.getOpcode(21), bytesVar);
                                this.visitInsn(83);
                                this.visitFieldInsn(178, systemType.getInternalName(), "out", printStreamType.getDescriptor());
                                this.visitVarInsn(objectsType.getOpcode(21), params);
                                this.visitMethodInsn(182, printStreamType.getInternalName(), "print", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{objectType}), false);
                                this.visitVarInsn(objectsType.getOpcode(21), params);
                                this.visitInsn(5);
                                this.visitInsn(50);
                            } else {
                                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                            }
                        }
                    }
                    return new PatchClassDefinitionMethodVisitor(access, desc, mv);
                }
                return mv;
            }
        };
        classReader.accept(cv, 8);
        return new ClassDefinition(original.getDefinitionClass(), classWriter.toByteArray());
    }

    static void installTransformer(final LambdaClassTransformer transformer) {
        System.setOut(new PrintStream((OutputStream)System.out, true){

            @Override
            public void print(Object o) {
                Object[] params;
                if (o instanceof Object[] && (params = (Object[])o).length == 3 && RuntimeBytecodeInjector.isValidCaller(params[0]) && params[1] instanceof Class && params[2] instanceof byte[]) {
                    byte[] inBytes;
                    byte[] outBytes = inBytes = (byte[])params[2];
                    try {
                        outBytes = transformer.transform((Class)params[1], inBytes);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    params[2] = outBytes == null ? inBytes : outBytes;
                    return;
                }
                super.println(o);
            }
        });
    }

    private static boolean isValidCaller(Object o) {
        return o != null && CLASS.equals(o.getClass().getName());
    }

    private static ClassDefinition loadClassDefinition(Class<?> clazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        try (InputStream in = Object.class.getResourceAsStream('/' + clazz.getName().replace('.', '/') + ".class");){
            int c = 0;
            while ((c = in.read(buff)) > 0) {
                out.write(buff, 0, c);
            }
        }
        out.close();
        byte[] bytes = out.toByteArray();
        return new ClassDefinition(clazz, bytes);
    }

    private static ClassDefinition loadClassDefinition(String className) throws ClassNotFoundException, IOException {
        return RuntimeBytecodeInjector.loadClassDefinition(Class.forName(className));
    }

    static interface LambdaClassTransformer {
        public byte[] transform(Class<?> var1, byte[] var2) throws Throwable;
    }
}

