/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick.batchhandler;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.amplecode.quick.BatchHandler;
import org.amplecode.quick.JdbcConfiguration;
import org.amplecode.quick.StatementBuilder;
import org.amplecode.quick.factory.IdentifierExtractorFactory;
import org.amplecode.quick.factory.StatementBuilderFactory;
import org.amplecode.quick.identifier.IdentifierExtractor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractBatchHandler<T>
implements BatchHandler<T> {
    private Log log = LogFactory.getLog(AbstractBatchHandler.class);
    private JdbcConfiguration configuration;
    private Connection connection;
    private Statement statement;
    protected StatementBuilder statementBuilder;
    private IdentifierExtractor identifierExtractor;
    private StringBuffer sqlBuffer;
    private final int maxLength = 200000;
    private Collection<Integer> identifiers;
    private int statementCount = 0;
    private boolean hasNoAutoIncrementPrimaryKey = false;
    private boolean uniqueColumnsAreInclusive = false;

    private AbstractBatchHandler() {
    }

    protected AbstractBatchHandler(JdbcConfiguration configuration, boolean hasNoAutoIncrementPrimaryKey, boolean uniqueColumnsAreInclusive) {
        this.configuration = configuration;
        this.statementBuilder = StatementBuilderFactory.createStatementBuilder(configuration.getDialect());
        this.identifierExtractor = IdentifierExtractorFactory.createIdentifierExtractor(configuration.getDialect());
        this.hasNoAutoIncrementPrimaryKey = hasNoAutoIncrementPrimaryKey;
        this.uniqueColumnsAreInclusive = uniqueColumnsAreInclusive;
    }

    @Override
    public final BatchHandler<T> init() {
        try {
            Class.forName(this.configuration.getDriverClass());
            this.connection = DriverManager.getConnection(this.configuration.getConnectionUrl(), this.configuration.getUsername(), this.configuration.getPassword());
            this.sqlBuffer = new StringBuffer(200000);
            this.identifiers = new ArrayList<Integer>();
            this.statementCount = 0;
            this.statement = this.connection.createStatement();
            this.setTableName();
            this.setAutoIncrementColumn();
            this.setIdentifierColumns();
            this.setUniqueColumns();
            this.setMatchColumns();
            this.setColumns();
            this.sqlBuffer.append(this.getInsertStatementOpening());
            return this;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create statement", ex);
        }
    }

    @Override
    public BatchHandler<T> setTableName(String name) {
        this.statementBuilder.setTableName(name);
        return this;
    }

    @Override
    public final int insertObject(T object, boolean returnGeneratedIdentifier) {
        try {
            this.setValues(object);
            this.sqlBuffer = new StringBuffer(this.getInsertStatementOpening());
            this.sqlBuffer.append(this.statementBuilder.getInsertStatementValues());
            this.sqlBuffer.deleteCharAt(this.sqlBuffer.length() - 1);
            this.log.debug((Object)("Insert SQL: " + this.sqlBuffer));
            this.statement.executeUpdate(this.sqlBuffer.toString());
            return returnGeneratedIdentifier ? this.identifierExtractor.extract(this.statement) : 0;
        }
        catch (SQLException ex) {
            this.log.info((Object)("Insert SQL: " + this.sqlBuffer));
            throw new RuntimeException("Failed to insert " + object.getClass().getName(), ex);
        }
    }

    @Override
    public final void addObject(T object) {
        this.setValues(object);
        this.sqlBuffer.append(this.statementBuilder.getInsertStatementValues());
        ++this.statementCount;
        if (this.sqlBuffer.length() > 200000) {
            try {
                this.sqlBuffer.deleteCharAt(this.sqlBuffer.length() - 1);
                this.statement.executeUpdate(this.sqlBuffer.toString());
                this.log.debug((Object)("Add SQL: " + this.sqlBuffer));
                if (!this.hasNoAutoIncrementPrimaryKey) {
                    this.identifiers.addAll(this.identifierExtractor.extract(this.statement, this.statementCount));
                }
                this.sqlBuffer = new StringBuffer(200000).append(this.getInsertStatementOpening());
                this.statementCount = 0;
            }
            catch (SQLException ex) {
                this.log.info((Object)("Add SQL: " + this.sqlBuffer));
                throw new RuntimeException("Failed to add objects", ex);
            }
        }
    }

    @Override
    public final void updateObject(T object) {
        this.setIdentifierValues(object);
        this.setValues(object);
        String sql = this.statementBuilder.getUpdateStatement();
        this.log.debug((Object)("Update SQL: " + sql));
        try {
            this.statement.executeUpdate(sql);
        }
        catch (SQLException ex) {
            this.log.info((Object)("Update SQL: " + sql));
            throw new RuntimeException("Failed to update object", ex);
        }
    }

    @Override
    public final boolean objectExists(T object) {
        this.setUniqueValues(object);
        String sql = this.statementBuilder.getUniquenessStatement(this.uniqueColumnsAreInclusive);
        this.log.debug((Object)("Unique SQL: " + sql));
        try {
            return this.statement.executeQuery(sql).next();
        }
        catch (SQLException ex) {
            this.log.info((Object)("Unique SQL: " + sql));
            throw new RuntimeException("Failed to check uniqueness of object", ex);
        }
    }

    @Override
    public final int getObjectIdentifier(Object object) {
        this.setMatchValues(object);
        String sql = this.statementBuilder.getIdentifierStatement();
        this.log.debug((Object)("Identifier SQL: " + sql));
        try {
            ResultSet resultSet = this.statement.executeQuery(sql);
            return resultSet.next() ? resultSet.getInt(1) : 0;
        }
        catch (SQLException ex) {
            this.log.info((Object)("Identifier SQL: " + sql));
            throw new RuntimeException("Failed to get object identifier", ex);
        }
    }

    @Override
    public final Collection<Integer> flush() {
        try {
            if (this.sqlBuffer.length() > 2 && this.statementCount != 0) {
                this.sqlBuffer.deleteCharAt(this.sqlBuffer.length() - 1);
                this.log.debug((Object)("Flush SQL: " + this.sqlBuffer));
                this.statement.executeUpdate(this.sqlBuffer.toString());
                if (!this.hasNoAutoIncrementPrimaryKey) {
                    this.identifiers.addAll(this.identifierExtractor.extract(this.statement, this.statementCount));
                }
                this.statementCount = 0;
            }
            Collection<Integer> collection = this.identifiers;
            return collection;
        }
        catch (SQLException ex) {
            this.log.info((Object)("Flush SQL: " + this.sqlBuffer));
            throw new RuntimeException("Failed to flush BatchHandler", ex);
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException statementEx) {
                    statementEx.printStackTrace();
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException connectionEx) {
                    connectionEx.printStackTrace();
                }
            }
        }
    }

    protected void setAutoIncrementColumn() {
    }

    protected void setIdentifierColumns() {
    }

    protected void setIdentifierValues(T object) {
    }

    protected void setMatchColumns() {
        this.statementBuilder.setMatchColumnToFirstUniqueColumn();
    }

    protected void setMatchValues(Object object) {
        this.statementBuilder.setMatchValue(object);
    }

    protected String getInsertStatementOpening() {
        return this.statementBuilder.getInsertStatementOpening();
    }

    protected abstract void setTableName();

    protected abstract void setUniqueColumns();

    protected abstract void setUniqueValues(T var1);

    protected abstract void setColumns();

    protected abstract void setValues(T var1);
}

