/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick.factory;

import org.amplecode.quick.StatementDialect;
import org.amplecode.quick.identifier.DerbyIdentifierExtractor;
import org.amplecode.quick.identifier.H2IdentifierExtractor;
import org.amplecode.quick.identifier.IdentifierExtractor;
import org.amplecode.quick.identifier.MySqlIdentifierExtractor;
import org.amplecode.quick.identifier.PostgreSqlIdentifierExtractor;

public class IdentifierExtractorFactory {
    public static IdentifierExtractor createIdentifierExtractor(StatementDialect dialect) {
        if (dialect.equals((Object)StatementDialect.MYSQL)) {
            return new MySqlIdentifierExtractor();
        }
        if (dialect.equals((Object)StatementDialect.POSTGRESQL)) {
            return new PostgreSqlIdentifierExtractor();
        }
        if (dialect.equals((Object)StatementDialect.H2)) {
            return new H2IdentifierExtractor();
        }
        if (dialect.equals((Object)StatementDialect.DERBY)) {
            return new DerbyIdentifierExtractor();
        }
        throw new RuntimeException("Unsupported dialect: " + (Object)((Object)dialect));
    }
}

