/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick.statement;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.amplecode.quick.StatementHolder;

public class DefaultStatementHolder
implements StatementHolder {
    private Connection connection;
    private boolean pooled;
    private Statement statement;

    public DefaultStatementHolder(Connection connection, boolean pooled) {
        this.connection = connection;
        this.pooled = pooled;
        try {
            this.statement = connection.createStatement();
        }
        catch (SQLException ex) {
            this.close();
            throw new RuntimeException("Failed to create statement", ex);
        }
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isPooled() {
        return this.pooled;
    }

    @Override
    public int executeUpdate(String sql) {
        try {
            int n = this.statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public Integer queryForInteger(String sql) {
        try {
            ResultSet resultSet = this.statement.executeQuery(sql);
            Integer n = resultSet.next() ? Integer.valueOf(resultSet.getInt(1)) : null;
            return n;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public Double queryForDouble(String sql) {
        try {
            ResultSet resultSet = this.statement.executeQuery(sql);
            Double d = resultSet.next() ? Double.valueOf(resultSet.getDouble(1)) : null;
            return d;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public String queryForString(String sql) {
        try {
            ResultSet resultSet = this.statement.executeQuery(sql);
            String string = resultSet.next() ? resultSet.getString(1) : null;
            return string;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public int update(String sql) {
        try {
            int n = this.statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        if (!this.pooled) {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }
}

