/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick.statement;

import java.sql.Connection;
import java.sql.DriverManager;
import org.amplecode.quick.JdbcConfiguration;
import org.amplecode.quick.StatementHolder;
import org.amplecode.quick.StatementManager;
import org.amplecode.quick.statement.DefaultStatementHolder;

public class JdbcStatementManager
implements StatementManager {
    private ThreadLocal<StatementHolder> holderTag = new ThreadLocal();
    private JdbcConfiguration jdbcConfiguration;

    public void setJdbcConfiguration(JdbcConfiguration jdbcConfiguration) {
        this.jdbcConfiguration = jdbcConfiguration;
    }

    @Override
    public void initialise() {
        Connection connection = this.getConnection();
        DefaultStatementHolder holder = new DefaultStatementHolder(connection, true);
        this.holderTag.set(holder);
    }

    @Override
    public StatementHolder getHolder() {
        StatementHolder holder = this.holderTag.get();
        if (holder != null) {
            return holder;
        }
        return new DefaultStatementHolder(this.getConnection(), false);
    }

    @Override
    public void destroy() {
        StatementHolder holder = this.holderTag.get();
        if (holder != null) {
            holder.close();
            this.holderTag.remove();
        }
    }

    private Connection getConnection() {
        try {
            Class.forName(this.jdbcConfiguration.getDriverClass());
            Connection connection = DriverManager.getConnection(this.jdbcConfiguration.getConnectionUrl(), this.jdbcConfiguration.getUsername(), this.jdbcConfiguration.getPassword());
            return connection;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create connection", ex);
        }
    }
}

