/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick.statementbuilder;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.amplecode.quick.StatementBuilder;

public abstract class AbstractStatementBuilder
implements StatementBuilder {
    protected final String QUOTE = "'";
    protected final String NULL = "null";
    protected final String TRUE = "true";
    protected final String FALSE = "false";
    protected final String SEPARATOR = ",";
    protected final String BRACKET_START = "(";
    protected final String BRACKET_END = ")";
    protected String tableName = null;
    protected String autoIncrementColumn = null;
    protected List<String> identifierColums = new ArrayList<String>();
    protected List<String> identifierValues = new ArrayList<String>();
    protected List<String> matchColumns;
    protected List<String> matchValues;
    protected List<String> uniqueColumns = new ArrayList<String>();
    protected List<String> uniqueValues = new ArrayList<String>();
    protected List<String> columns;
    protected List<String> values;

    public AbstractStatementBuilder() {
        this.matchColumns = new ArrayList<String>();
        this.matchValues = new ArrayList<String>();
        this.columns = new ArrayList<String>();
        this.values = new ArrayList<String>();
    }

    @Override
    public final void setTableName(String name) {
        this.tableName = name;
    }

    @Override
    public final void setAutoIncrementColumn(String column) {
        this.autoIncrementColumn = column;
    }

    @Override
    public final void setIdentifierColumn(String column) {
        this.identifierColums.add(column);
    }

    @Override
    public final void setIdentifierValue(Object value) {
        this.identifierValues.add(this.defaultEncode(value));
    }

    @Override
    public final void setMatchColumn(String column) {
        this.matchColumns.add(column);
    }

    @Override
    public final void setMatchValue(Object value) {
        this.matchValues.add(this.defaultEncode(value));
    }

    @Override
    public final void setUniqueColumn(String column) {
        this.uniqueColumns.add(column);
    }

    @Override
    public final void setUniqueValue(Object value) {
        this.uniqueValues.add(this.defaultEncode(value));
    }

    @Override
    public final void setColumn(String column) {
        this.columns.add(column);
    }

    @Override
    public final void setValue(Object value) {
        this.values.add(this.defaultEncode(value));
    }

    @Override
    public String getNoColumnInsertStatementOpening() {
        return "INSERT INTO " + this.tableName + " VALUES ";
    }

    @Override
    public String getUpdateStatement() {
        int i;
        StringBuffer buffer = new StringBuffer("UPDATE " + this.tableName + " SET ");
        for (i = 0; i < this.columns.size(); ++i) {
            buffer.append(this.columns.get(i) + "=" + this.values.get(i));
            if (i + 1 >= this.columns.size()) continue;
            buffer.append(",");
        }
        buffer.append(" WHERE ");
        for (i = 0; i < this.identifierColums.size(); ++i) {
            buffer.append(this.identifierColums.get(i) + "=" + this.identifierValues.get(i));
            if (i + 1 >= this.identifierColums.size()) continue;
            buffer.append(" AND ");
        }
        this.values.clear();
        this.identifierValues.clear();
        return buffer.toString();
    }

    @Override
    public String getUniquenessStatement(boolean inclusive) {
        String operator = inclusive ? " AND " : " OR ";
        StringBuffer sqlBuffer = new StringBuffer().append("SELECT ").append(this.uniqueColumns.get(0)).append(" FROM ").append(this.tableName).append(" WHERE ");
        for (int i = 0; i < this.uniqueColumns.size(); ++i) {
            sqlBuffer.append(this.uniqueColumns.get(i) + "=" + this.uniqueValues.get(i));
            if (i + 1 >= this.uniqueColumns.size()) continue;
            sqlBuffer.append(operator);
        }
        this.uniqueValues.clear();
        return sqlBuffer.toString();
    }

    @Override
    public String getIdentifierStatement() {
        StringBuffer sqlBuffer = new StringBuffer().append("SELECT ").append(this.identifierColums.get(0)).append(" FROM ").append(this.tableName).append(" WHERE ");
        for (int i = 0; i < this.matchColumns.size(); ++i) {
            sqlBuffer.append(this.matchColumns.get(i) + "=" + this.matchValues.get(i));
            if (i + 1 >= this.matchColumns.size()) continue;
            sqlBuffer.append(" AND ");
        }
        this.matchValues.clear();
        return sqlBuffer.toString();
    }

    @Override
    public void setMatchColumnToFirstUniqueColumn() {
        if (this.uniqueColumns.size() > 0) {
            this.matchColumns.add(0, this.uniqueColumns.get(0));
        }
    }

    protected final String defaultEncode(Object value) {
        String encoded = "null";
        if (value != null) {
            Class<?> clazz = value.getClass();
            encoded = clazz.equals(String.class) ? this.encodeString((String)value) : (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) ? this.encodeInteger((Integer)value) : (clazz.equals(Double.class) || clazz.equals(Double.TYPE) ? this.encodeDouble((Double)value) : (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE) ? this.encodeBoolean((Boolean)value) : (clazz.equals(Date.class) || clazz.equals(java.sql.Date.class) || clazz.equals(Timestamp.class) || clazz.equals(Time.class) ? this.encodeDate((Date)value) : (String)value))));
        }
        return encoded;
    }

    protected String encodeString(String value) {
        if (value != null) {
            value = value.endsWith("\\") ? value.substring(0, value.length() - 1) : value;
            value = value.replaceAll("'", "\\\\'");
        }
        return "'" + value + "'";
    }

    protected String encodeInteger(Integer value) {
        return String.valueOf(value);
    }

    protected String encodeDouble(Double value) {
        return String.valueOf(value);
    }

    protected String encodeBoolean(Boolean value) {
        return value != false ? "true" : "false";
    }

    protected String encodeDate(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String yearString = String.valueOf(year);
        String monthString = month < 10 ? "0" + month : String.valueOf(month);
        String dayString = day < 10 ? "0" + day : String.valueOf(day);
        return "'" + yearString + "-" + monthString + "-" + dayString + "'";
    }
}

