/*
 * Decompiled with CFR 0.152.
 */
package org.amplecode.quick.statementbuilder;

import org.amplecode.quick.statementbuilder.AbstractStatementBuilder;

public class H2StatementBuilder
extends AbstractStatementBuilder {
    @Override
    public String getInsertStatementOpening() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO " + this.tableName + " (");
        for (String column : this.columns) {
            buffer.append(column + ",");
        }
        if (this.columns.size() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append(") VALUES ");
        return buffer.toString();
    }

    @Override
    public String getInsertStatementValues() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (String value : this.values) {
            buffer.append(value + ",");
        }
        if (this.values.size() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("),");
        this.values.clear();
        return buffer.toString();
    }

    @Override
    public String getDoubleColumnType() {
        return "DOUBLE";
    }

    @Override
    protected String encodeString(String value) {
        if (value != null) {
            value = value.endsWith("\\") ? value.substring(0, value.length() - 1) : value;
            value = value.replaceAll("'", "''");
        }
        return "'" + value + "'";
    }
}

