/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import org.androidannotations.api.sharedpreferences.AbstractPrefField;

public final class LongPrefField
extends AbstractPrefField<Long> {
    LongPrefField(SharedPreferences sharedPreferences, String key, Long defaultValue) {
        super(sharedPreferences, key, defaultValue);
    }

    @Override
    public Long getOr(Long defaultValue) {
        try {
            return this.sharedPreferences.getLong(this.key, defaultValue.longValue());
        }
        catch (ClassCastException e) {
            try {
                String value = this.sharedPreferences.getString(this.key, "" + defaultValue);
                return Long.parseLong(value);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    @Override
    protected void putInternal(Long value) {
        this.apply(this.edit().putLong(this.key, value.longValue()));
    }
}

