/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.AfterTextChange;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.TextWatcherHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class AfterTextChangeHandler
extends BaseAnnotationHandler<EComponentWithViewSupportHolder> {
    private IdAnnotationHelper idAnnotationHelper;

    public AfterTextChangeHandler(ProcessingEnvironment processingEnvironment) {
        super(AfterTextChange.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.idAnnotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validatedElements, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, valid);
        this.validatorHelper.hasAfterTextChangedMethodParameters((ExecutableElement)element, valid);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int editableParameterPosition = -1;
        int viewParameterPosition = -1;
        TypeMirror viewParameterType = null;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if ("android.text.Editable".equals(parameterType.toString())) {
                editableParameterPosition = i;
                continue;
            }
            TypeMirror textViewType = this.idAnnotationHelper.typeElementFromQualifiedName("android.widget.TextView").asType();
            if (!this.idAnnotationHelper.isSubtype(parameterType, textViewType)) continue;
            viewParameterPosition = i;
            viewParameterType = parameterType;
        }
        List<JFieldRef> idsRefs = this.idAnnotationHelper.extractAnnotationFieldRefs(this.processHolder, element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            TextWatcherHolder textWatcherHolder = holder.getTextWatcherHolder(idRef, viewParameterType);
            JBlock methodBody = textWatcherHolder.getAfterTextChangedBody();
            JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
            JInvocation textChangeCall = methodBody.invoke((JExpression)activityRef, methodName);
            for (int i = 0; i < parameters.size(); ++i) {
                if (i == editableParameterPosition) {
                    JVar afterTextChangeEditableParam = textWatcherHolder.getAfterTextChangedEditableParam();
                    textChangeCall.arg(afterTextChangeEditableParam);
                    continue;
                }
                if (i != viewParameterPosition) continue;
                JVar viewParameter = textWatcherHolder.getTextViewVariable();
                textChangeCall.arg(viewParameter);
            }
        }
    }
}

