/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.IgnoredWhenDetached;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EFragmentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class IgnoredWhenDetachedHandler
extends BaseAnnotationHandler<EFragmentHolder> {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public IgnoredWhenDetachedHandler(ProcessingEnvironment processingEnvironment) {
        super(IgnoredWhenDetached.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.isNotFinal(element, valid);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, valid);
        this.validatorHelper.enclosingElementHasEFragment(element, validatedElements, valid);
    }

    @Override
    public void process(Element element, EFragmentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousMethodBody = this.codeModelHelper.removeBody(delegatingMethod);
        delegatingMethod.body()._if(JExpr.invoke((JExpression)holder.getGeneratedClass().staticRef("this"), "getActivity").ne(JExpr._null()))._then().add(previousMethodBody);
    }
}

