/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.holder.EComponentHolder;

public class ActionBarSherlockHelper {
    private final AnnotationHelper annotationHelper;

    public ActionBarSherlockHelper(AnnotationHelper annotationHelper) {
        this.annotationHelper = annotationHelper;
    }

    public boolean usesActionBarSherlock(EComponentHolder holder) {
        TypeElement typeElement = this.annotationHelper.typeElementFromQualifiedName(holder.getGeneratedClass()._extends().fullName());
        return this.usesActionBarSherlock(typeElement);
    }

    public boolean usesActionBarSherlock(TypeElement typeElement) {
        TypeMirror superType;
        while (!((superType = typeElement.getSuperclass()) instanceof NoType)) {
            typeElement = (TypeElement)((DeclaredType)superType).asElement();
            String qName = typeElement.getQualifiedName().toString();
            if (!qName.startsWith("com.actionbarsherlock.app")) continue;
            return true;
        }
        return false;
    }
}

