/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api;

import android.os.Looper;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class BackgroundExecutor {
    private static final String TAG = "BackgroundExecutor";
    public static Executor DEFAULT_EXECUTOR;
    private static Executor executor;
    public static final WrongThreadListener DEFAULT_WRONG_THREAD_LISTENER;
    private static WrongThreadListener wrongThreadListener;
    private static final List<Task> tasks;
    private static final ThreadLocal<String> currentSerial;

    private static Future<?> directExecute(Runnable runnable, int delay) {
        Future<?> future = null;
        if (delay > 0) {
            if (!(executor instanceof ScheduledExecutorService)) {
                throw new IllegalArgumentException("The executor set does not support scheduling");
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor;
            future = scheduledExecutorService.schedule(runnable, (long)delay, TimeUnit.MILLISECONDS);
        } else if (executor instanceof ExecutorService) {
            ExecutorService executorService = (ExecutorService)executor;
            future = executorService.submit(runnable);
        } else {
            executor.execute(runnable);
        }
        return future;
    }

    public static synchronized void execute(Task task) {
        Future<?> future = null;
        if (task.serial == null || !BackgroundExecutor.hasSerialRunning(task.serial)) {
            task.executionAsked = true;
            future = BackgroundExecutor.directExecute(task, task.remainingDelay);
        }
        if (task.id != null || task.serial != null) {
            task.future = future;
            tasks.add(task);
        }
    }

    public static void execute(final Runnable runnable, String id, int delay, String serial) {
        BackgroundExecutor.execute(new Task(id, delay, serial){

            @Override
            public void execute() {
                runnable.run();
            }
        });
    }

    public static void execute(Runnable runnable, int delay) {
        BackgroundExecutor.directExecute(runnable, delay);
    }

    public static void execute(Runnable runnable) {
        BackgroundExecutor.directExecute(runnable, 0);
    }

    public static void execute(Runnable runnable, String id, String serial) {
        BackgroundExecutor.execute(runnable, id, 0, serial);
    }

    public static void setExecutor(Executor executor) {
        BackgroundExecutor.executor = executor;
    }

    public static void setWrongThreadListener(WrongThreadListener listener) {
        wrongThreadListener = listener;
    }

    public static synchronized void cancelAll(String id, boolean mayInterruptIfRunning) {
        for (int i = tasks.size() - 1; i >= 0; --i) {
            Task task = tasks.get(i);
            if (!id.equals(task.id)) continue;
            if (task.future != null) {
                task.future.cancel(mayInterruptIfRunning);
                if (task.managed.getAndSet(true)) continue;
                task.postExecute();
                continue;
            }
            if (task.executionAsked) {
                Log.w((String)TAG, (String)("A task with id " + task.id + " cannot be cancelled (the executor set does not support it)"));
                continue;
            }
            tasks.remove(i);
        }
    }

    public static void checkUiThread() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            wrongThreadListener.onUiExpected();
        }
    }

    public static void checkBgThread(String ... serials) {
        if (serials.length == 0) {
            if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
                wrongThreadListener.onBgExpected(serials);
            }
            return;
        }
        String current = currentSerial.get();
        if (current == null) {
            wrongThreadListener.onWrongBgSerial(null, serials);
            return;
        }
        for (String serial : serials) {
            if (!serial.equals(current)) continue;
            return;
        }
        wrongThreadListener.onWrongBgSerial(current, serials);
    }

    private static boolean hasSerialRunning(String serial) {
        for (Task task : tasks) {
            if (!task.executionAsked || !serial.equals(task.serial)) continue;
            return true;
        }
        return false;
    }

    private static Task take(String serial) {
        int len = tasks.size();
        for (int i = 0; i < len; ++i) {
            if (!serial.equals(tasks.get(i).serial)) continue;
            return tasks.remove(i);
        }
        return null;
    }

    static {
        executor = DEFAULT_EXECUTOR = Executors.newScheduledThreadPool(2 * Runtime.getRuntime().availableProcessors());
        wrongThreadListener = DEFAULT_WRONG_THREAD_LISTENER = new WrongThreadListener(){

            @Override
            public void onUiExpected() {
                throw new IllegalStateException("Method invocation is expected from the UI thread");
            }

            @Override
            public void onBgExpected(String ... expectedSerials) {
                if (expectedSerials.length == 0) {
                    throw new IllegalStateException("Method invocation is expected from a background thread, but it was called from the UI thread");
                }
                throw new IllegalStateException("Method invocation is expected from one of serials " + Arrays.toString(expectedSerials) + ", but it was called from the UI thread");
            }

            @Override
            public void onWrongBgSerial(String currentSerial, String ... expectedSerials) {
                if (currentSerial == null) {
                    currentSerial = "anonymous";
                }
                throw new IllegalStateException("Method invocation is expected from one of serials " + Arrays.toString(expectedSerials) + ", but it was called from " + currentSerial + " serial");
            }
        };
        tasks = new ArrayList<Task>();
        currentSerial = new ThreadLocal();
    }

    public static interface WrongThreadListener {
        public void onUiExpected();

        public void onBgExpected(String ... var1);

        public void onWrongBgSerial(String var1, String ... var2);
    }

    public static abstract class Task
    implements Runnable {
        private String id;
        private int remainingDelay;
        private long targetTimeMillis;
        private String serial;
        private boolean executionAsked;
        private Future<?> future;
        private AtomicBoolean managed = new AtomicBoolean();

        public Task(String id, int delay, String serial) {
            if (!"".equals(id)) {
                this.id = id;
            }
            if (delay > 0) {
                this.remainingDelay = delay;
                this.targetTimeMillis = System.currentTimeMillis() + (long)delay;
            }
            if (!"".equals(serial)) {
                this.serial = serial;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.managed.getAndSet(true)) {
                return;
            }
            try {
                currentSerial.set(this.serial);
                this.execute();
            }
            finally {
                this.postExecute();
            }
        }

        public abstract void execute();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postExecute() {
            if (this.id == null && this.serial == null) {
                return;
            }
            currentSerial.set(null);
            Class<BackgroundExecutor> clazz = BackgroundExecutor.class;
            synchronized (BackgroundExecutor.class) {
                Task next;
                tasks.remove(this);
                if (this.serial != null && (next = BackgroundExecutor.take(this.serial)) != null) {
                    if (next.remainingDelay != 0) {
                        next.remainingDelay = Math.max(0, (int)(this.targetTimeMillis - System.currentTimeMillis()));
                    }
                    BackgroundExecutor.execute(next);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

