/**
 * Copyright (C) 2010-2014 eBusiness Information, Excilys Group
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed To in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.androidannotations.rclass;

import org.androidannotations.process.ProcessHolder;

import com.sun.codemodel.JFieldRef;

public interface IRInnerClass {

	boolean containsIdValue(Integer idValue);

	boolean containsField(String name);

	String getIdQualifiedName(Integer idValue);

	String getIdQualifiedName(String name);

	JFieldRef getIdStaticRef(Integer idValue, ProcessHolder holder);

	JFieldRef getIdStaticRef(String name, ProcessHolder holder);

	final IRInnerClass EMPTY_R_INNER_CLASS = new RInnerClass(null);

}
