/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.GeneratingAnnotationHandler;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public abstract class BaseGeneratingAnnotationHandler<T extends GeneratedClassHolder>
extends BaseAnnotationHandler<T>
implements GeneratingAnnotationHandler<T> {
    public BaseGeneratingAnnotationHandler(Class<?> targetClass, ProcessingEnvironment processingEnvironment) {
        super(targetClass, processingEnvironment);
    }

    public BaseGeneratingAnnotationHandler(String target, ProcessingEnvironment processingEnvironment) {
        super(target, processingEnvironment);
    }

    @Override
    protected void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.isNotFinal(element, valid);
        if (this.isInnerClass(element)) {
            this.validatorHelper.isNotPrivate(element, valid);
            this.validatorHelper.isStatic(element, valid);
            this.validatorHelper.enclosingElementHasAndroidAnnotation(element, validatedElements, valid);
            this.validatorHelper.enclosingElementIsNotAbstractIfNotAbstract(element, valid);
        }
    }

    private boolean isInnerClass(Element element) {
        TypeElement typeElement = (TypeElement)element;
        return typeElement.getNestingKind().isNested();
    }
}

