/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.annotations.EViewGroup;
import org.androidannotations.handler.BaseGeneratingAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EViewGroupHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.process.ProcessHolder;
import org.androidannotations.rclass.IRClass;

public class EViewGroupHandler
extends BaseGeneratingAnnotationHandler<EViewGroupHolder> {
    private IdAnnotationHelper annotationHelper;

    public EViewGroupHandler(ProcessingEnvironment processingEnvironment) {
        super(EViewGroup.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public EViewGroupHolder createGeneratedClassHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        return new EViewGroupHolder(processHolder, annotatedElement);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        this.validatorHelper.extendsViewGroup(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.LAYOUT, IdValidatorHelper.FallbackStrategy.ALLOW_NO_RES_ID, valid);
    }

    @Override
    public void process(Element element, EViewGroupHolder holder) {
        JFieldRef contentViewId = this.annotationHelper.extractOneAnnotationFieldRef(this.processHolder, element, IRClass.Res.LAYOUT, false);
        if (contentViewId != null) {
            holder.getSetContentViewBlock().invoke("inflate").arg(holder.getContextRef()).arg(contentViewId).arg(JExpr._this());
        }
    }
}

