/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.FocusChange;
import org.androidannotations.handler.AbstractViewListenerHandler;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class FocusChangeHandler
extends AbstractViewListenerHandler {
    public FocusChangeHandler(ProcessingEnvironment processingEnvironment) {
        super(FocusChange.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.validatorHelper.param.hasZeroOrOneViewParameter(executableElement, valid);
        this.validatorHelper.param.hasZeroOrOneBooleanParameter(executableElement, valid);
        this.validatorHelper.param.hasNoOtherParameterThanViewOrBoolean(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        listenerMethodBody.add(call);
    }

    @Override
    protected void processParameters(EComponentWithViewSupportHolder holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> parameters) {
        JVar viewParam = listenerMethod.param(this.classes().VIEW, "view");
        JVar hasFocusParam = listenerMethod.param(this.codeModel().BOOLEAN, "hasFocus");
        for (VariableElement variableElement : parameters) {
            String parameterType = variableElement.asType().toString();
            if (parameterType.equals("android.view.View")) {
                call.arg(viewParam);
                continue;
            }
            if (!parameterType.equals(CanonicalNameConstants.BOOLEAN) && variableElement.asType().getKind() != TypeKind.BOOLEAN) continue;
            call.arg(hasFocusParam);
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, this.codeModel().VOID, "onFocusChange");
    }

    @Override
    protected String getSetterName() {
        return "setOnFocusChangeListener";
    }

    @Override
    protected JClass getListenerClass() {
        return this.classes().VIEW_ON_FOCUS_CHANGE_LISTENER;
    }
}

