/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.OnActivityResult;
import org.androidannotations.handler.AnnotationHandlers;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.ExtraParameterHandler;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.HasOnActivityResult;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class OnActivityResultHandler
extends BaseAnnotationHandler<HasOnActivityResult> {
    private ExtraHandler extraHandler;

    public OnActivityResultHandler(ProcessingEnvironment processingEnvironment) {
        super(OnActivityResult.class, processingEnvironment);
        this.extraHandler = new ExtraHandler(processingEnvironment);
    }

    public void register(AnnotationHandlers annotationHandlers) {
        annotationHandlers.add(this);
        annotationHandlers.add(this.extraHandler);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragment(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        OnActivityResult onResultAnnotation = element.getAnnotation(OnActivityResult.class);
        this.validatorHelper.annotationValuePositiveAndInAShort(element, valid, onResultAnnotation.value());
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.validatorHelper.param.hasNoOtherParameterThanIntentOrIntOrOnActivityResultExtraAnnotated(executableElement, valid);
    }

    @Override
    public void process(Element element, HasOnActivityResult holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int requestCode = executableElement.getAnnotation(OnActivityResult.class).value();
        JBlock onResultBlock = holder.getOnActivityResultCaseBlock(requestCode).block();
        JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
        JInvocation onResultInvocation = JExpr.invoke((JExpression)activityRef, methodName);
        JVar intent = holder.getOnActivityResultDataParam();
        JVar extras = null;
        for (VariableElement variableElement : parameters) {
            TypeMirror parameterType = variableElement.asType();
            if (variableElement.getAnnotation(OnActivityResult.Extra.class) != null) {
                if (extras == null) {
                    extras = onResultBlock.decl(this.classes().BUNDLE, "extras_", JOp.cond(intent.ne(JExpr._null()).cand(intent.invoke("getExtras").ne(JExpr._null())), intent.invoke("getExtras"), JExpr._new(this.classes().BUNDLE)));
                }
                JExpression extraParameter = this.extraHandler.getExtraValue(variableElement, extras, onResultBlock, holder);
                onResultInvocation.arg(extraParameter);
                continue;
            }
            if ("android.content.Intent".equals(parameterType.toString())) {
                onResultInvocation.arg(intent);
                continue;
            }
            if (!parameterType.getKind().equals((Object)TypeKind.INT) && !CanonicalNameConstants.INTEGER.equals(parameterType.toString())) continue;
            onResultInvocation.arg(holder.getOnActivityResultResultCodeParam());
        }
        onResultBlock.add(onResultInvocation);
    }

    private static class ExtraHandler
    extends ExtraParameterHandler {
        public ExtraHandler(ProcessingEnvironment processingEnvironment) {
            super(OnActivityResult.Extra.class, OnActivityResult.class, processingEnvironment);
        }

        @Override
        public String getAnnotationValue(VariableElement parameter) {
            return parameter.getAnnotation(OnActivityResult.Extra.class).value();
        }

        public JExpression getExtraValue(VariableElement parameter, JVar extras, JBlock block, HasOnActivityResult holder) {
            return super.getExtraValue(parameter, holder.getOnActivityResultDataParam(), extras, block, holder.getOnActivityResultMethod(), holder);
        }
    }
}

