/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.annotations.OptionsMenuItem;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.HasOptionsMenu;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class OptionsMenuItemHandler
extends BaseAnnotationHandler<HasOptionsMenu> {
    private IdAnnotationHelper annotationHelper;

    public OptionsMenuItemHandler(ProcessingEnvironment processingEnvironment) {
        super(OptionsMenuItem.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragment(element, validatedElements, valid);
        this.validatorHelper.isDeclaredType(element, valid);
        this.validatorHelper.extendsMenuItem(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, HasOptionsMenu holder) {
        String fieldName = element.getSimpleName().toString();
        JBlock body = holder.getOnCreateOptionsMenuMethodBody();
        JVar menuParam = holder.getOnCreateOptionsMenuMenuParam();
        JFieldRef idsRef = this.annotationHelper.extractOneAnnotationFieldRef(this.processHolder, element, IRClass.Res.ID, true);
        body.assign(JExpr.ref(fieldName), menuParam.invoke("findItem").arg(idsRef));
    }
}

