/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.OrmLiteDao;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.OrmLiteHelper;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class OrmLiteDaoHandler
extends BaseAnnotationHandler<EComponentHolder> {
    private final OrmLiteHelper ormLiteHelper;
    private final TargetAnnotationHelper helper;
    private final APTCodeModelHelper codeModelHelper;

    public OrmLiteDaoHandler(ProcessingEnvironment processingEnvironment) {
        super(OrmLiteDao.class, processingEnvironment);
        this.helper = new TargetAnnotationHelper(this.processingEnv, this.getTarget());
        this.ormLiteHelper = new OrmLiteHelper(this.helper);
        this.codeModelHelper = new APTCodeModelHelper();
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.hasOrmLiteJars(element, valid);
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.extendsOrmLiteDao(element, valid, this.ormLiteHelper);
        this.validatorHelper.hasASqlLiteOpenHelperParameterizedType(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        String fieldName = element.getSimpleName().toString();
        JClass modelClass = this.refClass(this.ormLiteHelper.getEntityType(element));
        JClass idClass = this.refClass(this.ormLiteHelper.getEntityIdType(element));
        JExpression modelClassDotClass = modelClass.dotclass();
        JClass daoClass = this.refClass("com.j256.ormlite.dao.Dao").narrow(modelClass, idClass);
        TypeMirror databaseHelperTypeMirror = (TypeMirror)this.helper.extractAnnotationParameter(element, "helper");
        JFieldVar databaseHelperRef = holder.getDatabaseHelperRef(databaseHelperTypeMirror);
        JBlock initBody = holder.getInitBody();
        JInvocation injectExpr = databaseHelperRef.invoke("getDao").arg(modelClassDotClass);
        if (this.elementExtendsRuntimeExceptionDao(element)) {
            JClass daoImplClass = this.codeModelHelper.typeMirrorToJClass(element.asType(), holder);
            injectExpr = JExpr._new(daoImplClass).arg(JExpr.cast(daoClass, injectExpr));
        }
        JTryBlock tryBlock = initBody._try();
        tryBlock.body().assign(JExpr.ref(fieldName), injectExpr);
        JCatchBlock catchBlock = tryBlock._catch(this.classes().SQL_EXCEPTION);
        JVar exception = catchBlock.param("e");
        catchBlock.body().staticInvoke(this.classes().LOG, "e").arg(holder.getGeneratedClass().name()).arg("Could not create DAO " + fieldName).arg(exception);
    }

    private boolean elementExtendsRuntimeExceptionDao(Element element) {
        TypeMirror elementType = element.asType();
        return this.helper.isSubtype(elementType, this.ormLiteHelper.getRuntimeExceptionDaoParametrizedType());
    }
}

