/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IntentBuilder;
import org.androidannotations.holder.HasIntentBuilder;

public class ActivityIntentBuilder
extends IntentBuilder {
    private static final int MIN_SDK_WITH_FRAGMENT_SUPPORT = 11;
    private static final int MIN_SDK_WITH_ACTIVITY_OPTIONS = 16;
    private JFieldVar fragmentField;
    private JFieldVar fragmentSupportField;
    private JFieldRef optionsField;

    public ActivityIntentBuilder(HasIntentBuilder holder, AndroidManifest androidManifest) {
        super(holder, androidManifest);
    }

    @Override
    public void build() throws JClassAlreadyExistsException {
        super.build();
        this.optionsField = JExpr.ref("lastOptions");
        this.createAdditionalConstructor();
        this.createAdditionalIntentMethods();
        this.overrideStartForResultMethod();
    }

    private void createAdditionalIntentMethods() {
        JVar fragmentParam;
        JMethod method;
        if (this.hasFragmentInClasspath()) {
            method = this.holder.getGeneratedClass().method(17, this.holder.getIntentBuilderClass(), "intent");
            fragmentParam = method.param(this.holder.classes().FRAGMENT, "fragment");
            method.body()._return(JExpr._new(this.holder.getIntentBuilderClass()).arg(fragmentParam));
        }
        if (this.hasFragmentSupportInClasspath()) {
            method = this.holder.getGeneratedClass().method(17, this.holder.getIntentBuilderClass(), "intent");
            fragmentParam = method.param(this.holder.classes().SUPPORT_V4_FRAGMENT, "supportFragment");
            method.body()._return(JExpr._new(this.holder.getIntentBuilderClass()).arg(fragmentParam));
        }
    }

    @Override
    protected JClass getSuperClass() {
        JClass superClass = this.holder.refClass(org.androidannotations.api.builder.ActivityIntentBuilder.class);
        return superClass.narrow((JClass)this.builderClass);
    }

    private void createAdditionalConstructor() {
        if (this.hasFragmentInClasspath()) {
            this.fragmentField = this.addFragmentConstructor(this.holder.classes().FRAGMENT, "fragment_");
        }
        if (this.hasFragmentSupportInClasspath()) {
            this.fragmentSupportField = this.addFragmentConstructor(this.holder.classes().SUPPORT_V4_FRAGMENT, "fragmentSupport_");
        }
    }

    private JFieldVar addFragmentConstructor(JClass fragmentClass, String fieldName) {
        JFieldVar fragmentField = this.holder.getIntentBuilderClass().field(4, fragmentClass, fieldName);
        JExpression generatedClass = this.holder.getGeneratedClass().dotclass();
        JMethod constructor = this.holder.getIntentBuilderClass().constructor(1);
        JVar constructorFragmentParam = constructor.param(fragmentClass, "fragment");
        JBlock constructorBody = constructor.body();
        constructorBody.invoke("super").arg(constructorFragmentParam.invoke("getActivity")).arg(generatedClass);
        constructorBody.assign(fragmentField, constructorFragmentParam);
        return fragmentField;
    }

    private void overrideStartForResultMethod() {
        JMethod method = this.holder.getIntentBuilderClass().method(1, this.holder.codeModel().VOID, "startForResult");
        method.annotate(Override.class);
        JVar requestCode = method.param(this.holder.codeModel().INT, "requestCode");
        JBlock body = method.body();
        JConditional condition = null;
        if (this.fragmentSupportField != null) {
            condition = body._if(this.fragmentSupportField.ne(JExpr._null()));
            condition._then().invoke((JExpression)this.fragmentSupportField, "startActivityForResult").arg(this.intentField).arg(requestCode);
        }
        if (this.fragmentField != null) {
            condition = condition == null ? body._if(this.fragmentField.ne(JExpr._null())) : condition._elseif(this.fragmentField.ne(JExpr._null()));
            JBlock fragmentStartForResultInvocationBlock = this.hasActivityOptionsInFragment() && this.shouldGuardActivityOptions() ? this.createCallWithIfGuard(requestCode, condition._then(), this.fragmentField) : condition._then();
            JInvocation invocation = fragmentStartForResultInvocationBlock.invoke((JExpression)this.fragmentField, "startActivityForResult").arg(this.intentField).arg(requestCode);
            if (this.hasActivityOptionsInFragment()) {
                invocation.arg(this.optionsField);
            }
        }
        JBlock activityStartInvocationBlock = null;
        activityStartInvocationBlock = condition != null ? condition._else() : method.body();
        JConditional activityCondition = activityStartInvocationBlock._if(this.contextField._instanceof(this.holder.classes().ACTIVITY));
        JBlock thenBlock = activityCondition._then();
        JVar activityVar = thenBlock.decl(this.holder.classes().ACTIVITY, "activity", JExpr.cast(this.holder.classes().ACTIVITY, this.contextField));
        if (this.hasActivityCompatInClasspath() && this.hasActivityOptionsInActivityCompat()) {
            thenBlock.staticInvoke(this.holder.classes().ACTIVITY_COMPAT, "startActivityForResult").arg(activityVar).arg(this.intentField).arg(requestCode).arg(this.optionsField);
        } else if (this.hasActivityOptionsInFragment()) {
            JBlock startForResultInvocationBlock = this.shouldGuardActivityOptions() ? this.createCallWithIfGuard(requestCode, thenBlock, activityVar) : thenBlock;
            startForResultInvocationBlock.invoke((JExpression)activityVar, "startActivityForResult").arg(this.intentField).arg(requestCode).arg(this.optionsField);
        } else {
            thenBlock.invoke((JExpression)activityVar, "startActivityForResult").arg(this.intentField).arg(requestCode);
        }
        if (this.hasActivityOptionsInFragment()) {
            JBlock startInvocationBlock = this.shouldGuardActivityOptions() ? this.createCallWithIfGuard(null, activityCondition._else(), this.contextField) : activityCondition._else();
            startInvocationBlock.invoke((JExpression)this.contextField, "startActivity").arg(this.intentField).arg(this.optionsField);
        } else {
            activityCondition._else().invoke((JExpression)this.contextField, "startActivity").arg(this.intentField);
        }
    }

    private JBlock createCallWithIfGuard(JVar requestCode, JBlock thenBlock, JExpression invocationTarget) {
        JConditional guardIf = thenBlock._if(this.holder.classes().BUILD_VERSION.staticRef("SDK_INT").gte(this.holder.classes().BUILD_VERSION_CODES.staticRef("JELLY_BEAN")));
        JBlock startInvocationBlock = guardIf._then();
        String methodName = requestCode != null ? "startActivityForResult" : "startActivity";
        JInvocation invocation = guardIf._else().invoke(invocationTarget, methodName).arg(this.intentField);
        if (requestCode != null) {
            invocation.arg(requestCode);
        }
        return startInvocationBlock;
    }

    protected boolean hasFragmentInClasspath() {
        boolean fragmentExistsInSdk = this.androidManifest.getMinSdkVersion() >= 11;
        return fragmentExistsInSdk && this.elementUtils.getTypeElement("android.app.Fragment") != null;
    }

    protected boolean hasFragmentSupportInClasspath() {
        return this.elementUtils.getTypeElement("android.support.v4.app.Fragment") != null;
    }

    protected boolean hasActivityCompatInClasspath() {
        return this.elementUtils.getTypeElement("android.support.v4.app.ActivityCompat") != null;
    }

    protected boolean hasActivityOptionsInFragment() {
        if (!this.hasFragmentInClasspath()) {
            return false;
        }
        TypeElement fragment = this.elementUtils.getTypeElement("android.app.Fragment");
        return this.hasActivityOptions(fragment, 1);
    }

    protected boolean hasActivityOptionsInActivityCompat() {
        TypeElement activityCompat = this.elementUtils.getTypeElement("android.support.v4.app.ActivityCompat");
        return this.hasActivityOptions(activityCompat, 2);
    }

    private boolean hasActivityOptions(TypeElement type, int optionsParamPosition) {
        if (type == null) {
            return false;
        }
        for (Element element : type.getEnclosedElements()) {
            VariableElement parameter;
            List<? extends VariableElement> parameters;
            ExecutableElement executableElement;
            if (element.getKind() != ElementKind.METHOD || !(executableElement = (ExecutableElement)element).getSimpleName().contentEquals("startActivity") || (parameters = executableElement.getParameters()).size() != optionsParamPosition + 1 || !(parameter = parameters.get(optionsParamPosition)).asType().toString().equals("android.os.Bundle")) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldGuardActivityOptions() {
        return this.androidManifest.getMinSdkVersion() < 16;
    }
}

