/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.util.Collections;
import java.util.List;

public class AndroidManifest {
    private final String applicationPackage;
    private final List<String> componentQualifiedNames;
    private final List<String> permissionQualifiedNames;
    private final String applicationClassName;
    private final boolean libraryProject;
    private final boolean debugabble;
    private final int minSdkVersion;
    private final int maxSdkVersion;
    private final int targetSdkVersion;

    public String toString() {
        return "AndroidManifest [applicationPackage=" + this.applicationPackage + ", componentQualifiedNames=" + this.componentQualifiedNames + ", permissionQualifiedNames=" + this.permissionQualifiedNames + ", applicationClassName=" + this.applicationClassName + ", libraryProject=" + this.libraryProject + ", debugabble=" + this.debugabble + ", minSdkVersion=" + this.minSdkVersion + ", maxSdkVersion=" + this.maxSdkVersion + ", targetSdkVersion=" + this.targetSdkVersion + "]";
    }

    public static AndroidManifest createManifest(String applicationPackage, String applicationClassName, List<String> componentQualifiedNames, List<String> permissionQualifiedNames, int minSdkVersion, int maxSdkVersion, int targetSdkVersion, boolean debugabble) {
        return new AndroidManifest(false, applicationPackage, applicationClassName, componentQualifiedNames, permissionQualifiedNames, minSdkVersion, maxSdkVersion, targetSdkVersion, debugabble);
    }

    public static AndroidManifest createLibraryManifest(String applicationPackage, int minSdkVersion, int maxSdkVersion, int targetSdkVersion) {
        return new AndroidManifest(true, applicationPackage, "", Collections.<String>emptyList(), Collections.<String>emptyList(), minSdkVersion, maxSdkVersion, targetSdkVersion, false);
    }

    private AndroidManifest(boolean libraryProject, String applicationPackage, String applicationClassName, List<String> componentQualifiedNames, List<String> permissionQualifiedNames, int minSdkVersion, int maxSdkVersion, int targetSdkVersion, boolean debuggable) {
        this.libraryProject = libraryProject;
        this.applicationPackage = applicationPackage;
        this.applicationClassName = applicationClassName;
        this.componentQualifiedNames = componentQualifiedNames;
        this.permissionQualifiedNames = permissionQualifiedNames;
        this.minSdkVersion = minSdkVersion;
        this.maxSdkVersion = maxSdkVersion;
        this.targetSdkVersion = targetSdkVersion;
        this.debugabble = debuggable;
    }

    public String getApplicationPackage() {
        return this.applicationPackage;
    }

    public List<String> getComponentQualifiedNames() {
        return Collections.unmodifiableList(this.componentQualifiedNames);
    }

    public List<String> getPermissionQualifiedNames() {
        return Collections.unmodifiableList(this.permissionQualifiedNames);
    }

    public String getApplicationClassName() {
        return this.applicationClassName;
    }

    public boolean isLibraryProject() {
        return this.libraryProject;
    }

    public boolean isDebuggable() {
        return this.debugabble;
    }

    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public int getMaxSdkVersion() {
        return this.maxSdkVersion;
    }

    public int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }
}

