/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JMethod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.GeneratedClassHolder;

public class BundleHelper {
    public static final Map<String, String> METHOD_SUFFIX_BY_TYPE_NAME = new HashMap<String, String>();
    private AnnotationHelper annotationHelper;
    private APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();
    private TypeMirror element;
    private boolean restoreCallNeedCastStatement = false;
    private boolean restoreCallNeedsSuppressWarning = false;
    private String methodNameToSave;
    private String methodNameToRestore;

    public BundleHelper(AnnotationHelper helper, TypeMirror element) {
        this.annotationHelper = helper;
        this.element = element;
        String typeString = element.toString();
        TypeElement elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
        if (METHOD_SUFFIX_BY_TYPE_NAME.containsKey(typeString)) {
            this.methodNameToSave = "put" + METHOD_SUFFIX_BY_TYPE_NAME.get(typeString);
            this.methodNameToRestore = "get" + METHOD_SUFFIX_BY_TYPE_NAME.get(typeString);
        } else if (element.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)element;
            boolean hasTypeArguments = false;
            if (arrayType.getComponentType() instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)arrayType.getComponentType();
                typeString = declaredType.asElement().toString();
                hasTypeArguments = declaredType.getTypeArguments().size() > 0;
            } else {
                typeString = arrayType.getComponentType().toString();
            }
            elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
            if (this.isTypeParcelable(elementType)) {
                this.methodNameToSave = "putParcelableArray";
                this.methodNameToRestore = "getParcelableArray";
                if (hasTypeArguments) {
                    this.restoreCallNeedsSuppressWarning = true;
                }
            } else {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
            }
        } else if (typeString.startsWith(CanonicalNameConstants.ARRAYLIST)) {
            DeclaredType declaredType;
            List<? extends TypeMirror> typeArguments;
            boolean hasTypeArguments = false;
            if (element instanceof DeclaredType && (typeArguments = (declaredType = (DeclaredType)element).getTypeArguments()).size() == 1) {
                TypeMirror typeArgument = typeArguments.get(0);
                if (typeArgument instanceof DeclaredType) {
                    declaredType = (DeclaredType)typeArgument;
                    typeString = declaredType.asElement().toString();
                    elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
                    boolean bl = hasTypeArguments = declaredType.getTypeArguments().size() > 0;
                }
                if (this.isTypeParcelable(elementType)) {
                    this.methodNameToSave = "putParcelableArrayList";
                    this.methodNameToRestore = "getParcelableArrayList";
                    if (hasTypeArguments) {
                        this.restoreCallNeedsSuppressWarning = true;
                    }
                }
            }
            if (this.methodNameToSave == null) {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
                this.restoreCallNeedsSuppressWarning = true;
            }
        } else {
            boolean hasTypeArguments = false;
            if (element instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)element;
                typeString = declaredType.asElement().toString();
                elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
                boolean bl = hasTypeArguments = declaredType.getTypeArguments().size() > 0;
            }
            if (this.isTypeParcelable(elementType)) {
                this.methodNameToSave = "putParcelable";
                this.methodNameToRestore = "getParcelable";
            } else {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
                if (hasTypeArguments) {
                    this.restoreCallNeedsSuppressWarning = true;
                }
            }
        }
    }

    public String getMethodNameToSave() {
        return this.methodNameToSave;
    }

    private boolean isTypeParcelable(TypeElement elementType) {
        TypeElement parcelableType = this.annotationHelper.typeElementFromQualifiedName("android.os.Parcelable");
        return elementType != null && this.annotationHelper.isSubtype(elementType, parcelableType);
    }

    public JExpression getExpressionToRestoreFromIntentOrBundle(JClass variableClass, JExpression intent, JExpression extras, JExpression extraKey, JMethod method, GeneratedClassHolder holder) {
        if ("byte[]".equals(this.element.toString())) {
            return intent.invoke("getByteArrayExtra").arg(extraKey);
        }
        return this.getExpressionToRestoreFromBundle(variableClass, extras, extraKey, method, holder);
    }

    public JExpression getExpressionToRestoreFromBundle(JClass variableClass, JExpression bundle, JExpression extraKey, JMethod method, GeneratedClassHolder holder) {
        JExpressionImpl expressionToRestore;
        if (this.methodNameToRestore.equals("getParcelableArray")) {
            JClass erasure = variableClass.elementType().erasure().array();
            expressionToRestore = holder.refClass(org.androidannotations.api.bundle.BundleHelper.class).staticInvoke("getParcelableArray").arg(bundle).arg(extraKey).arg(erasure.dotclass());
        } else {
            expressionToRestore = JExpr.invoke(bundle, this.methodNameToRestore).arg(extraKey);
        }
        if (this.restoreCallNeedCastStatement) {
            expressionToRestore = JExpr.cast(variableClass, expressionToRestore);
            if (this.restoreCallNeedsSuppressWarning) {
                this.codeModelHelper.addSuppressWarnings(method, "unchecked");
            }
        }
        return expressionToRestore;
    }

    static {
        METHOD_SUFFIX_BY_TYPE_NAME.put("android.os.Bundle", "Bundle");
        METHOD_SUFFIX_BY_TYPE_NAME.put("boolean", "Boolean");
        METHOD_SUFFIX_BY_TYPE_NAME.put("boolean[]", "BooleanArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("byte", "Byte");
        METHOD_SUFFIX_BY_TYPE_NAME.put("byte[]", "ByteArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("char", "Char");
        METHOD_SUFFIX_BY_TYPE_NAME.put("char[]", "CharArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put(CanonicalNameConstants.CHAR_SEQUENCE, "CharSequence");
        METHOD_SUFFIX_BY_TYPE_NAME.put("double", "Double");
        METHOD_SUFFIX_BY_TYPE_NAME.put("double[]", "DoubleArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("float", "Float");
        METHOD_SUFFIX_BY_TYPE_NAME.put("float[]", "FloatArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("int", "Int");
        METHOD_SUFFIX_BY_TYPE_NAME.put("int[]", "IntArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("java.util.ArrayList<java.lang.Integer>", "IntegerArrayList");
        METHOD_SUFFIX_BY_TYPE_NAME.put("long", "Long");
        METHOD_SUFFIX_BY_TYPE_NAME.put("long[]", "LongArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("short", "Short");
        METHOD_SUFFIX_BY_TYPE_NAME.put("short[]", "ShortArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put(CanonicalNameConstants.STRING, "String");
        METHOD_SUFFIX_BY_TYPE_NAME.put("java.lang.String[]", "StringArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("java.util.ArrayList<java.lang.String>", "StringArrayList");
    }
}

