/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.logger;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.androidannotations.logger.Level;
import org.androidannotations.logger.LoggerContext;

public class Logger {
    private final LoggerContext loggerContext;
    private final String name;

    public Logger(LoggerContext loggerContext, String name) {
        this.loggerContext = loggerContext;
        this.name = name;
    }

    public void trace(String message, Object ... args) {
        this.trace(message, null, args);
    }

    public void trace(String message, Element element, Object ... args) {
        this.log(Level.TRACE, message, element, null, null, args);
    }

    public void debug(String message, Object ... args) {
        this.debug(message, null, args);
    }

    public void debug(String message, Element element, Object ... args) {
        this.log(Level.DEBUG, message, element, null, null, args);
    }

    public void info(String message, Object ... args) {
        this.info(message, null, args);
    }

    public void info(String message, Element element, Object ... args) {
        this.log(Level.INFO, message, element, null, null, args);
    }

    public void warn(String message, Object ... args) {
        this.warn(message, null, null, args);
    }

    public void warn(String message, Throwable thr, Object ... args) {
        this.warn(message, null, thr, args);
    }

    public void warn(String message, Element element, Object ... args) {
        this.warn(message, element, null, args);
    }

    public void warn(String message, Element element, Throwable thr, Object ... args) {
        this.log(Level.WARN, message, element, null, thr, args);
    }

    public void error(String message, Object ... args) {
        this.error(message, null, null, args);
    }

    public void error(String message, Element element, Object ... args) {
        this.error(message, element, null, args);
    }

    public void error(String message, Throwable thr, Object ... args) {
        this.error(message, null, thr, args);
    }

    public void error(String message, Element element, Throwable thr, Object ... args) {
        this.log(Level.ERROR, message, element, null, thr, args);
    }

    public boolean isLoggable(Level level) {
        return level.isGreaterOrEquals(this.loggerContext.getCurrentLevel());
    }

    public void log(Level level, String message, Element element, AnnotationMirror annotationMirror, Throwable thr, Object ... args) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.loggerContext.writeLog(level, this.name, message, element, annotationMirror, thr, args);
    }
}

