/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.logger.appender;

import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.androidannotations.logger.Level;
import org.androidannotations.logger.appender.Appender;
import org.androidannotations.logger.formatter.FormatterSimple;

public class MessagerAppender
extends Appender {
    private Messager messager;

    public MessagerAppender() {
        super(new FormatterSimple());
    }

    @Override
    public void open() {
        this.messager = this.processingEnv.getMessager();
    }

    @Override
    public void append(Level level, Element element, AnnotationMirror annotationMirror, String message) {
        if (this.messager == null) {
            return;
        }
        Diagnostic.Kind kind = this.resolveKind(level);
        this.messager.printMessage(kind, message, element, annotationMirror);
    }

    @Override
    public void close() {
    }

    private Diagnostic.Kind resolveKind(Level level) {
        switch (level) {
            case TRACE: {
                return Diagnostic.Kind.NOTE;
            }
            case DEBUG: {
                return Diagnostic.Kind.NOTE;
            }
            case INFO: {
                return Diagnostic.Kind.NOTE;
            }
            case WARN: {
                return Diagnostic.Kind.WARNING;
            }
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }
}

